/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.amazonaws.auth.AWSCredentials;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsCredentialUtil;
import com.jaspersoft.jasperserver.war.amazon.client.AwsDataSourceService;
import com.jaspersoft.jasperserver.war.dto.AwsDBInstanceDTO;
import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AwsDataSourceTreeDataProvider
implements TreeDataProvider {
    public static final String AWS_DB = "awsDb";
    public static final String ROOT_URI = "/";
    private MessageSource messageSource;
    private AwsDataSourceService awsDataSourceService;
    private List<String> amazonDBServices;
    private Map<String, TreeNode> treeNodeBasedOnURI = new HashMap<String, TreeNode>();
    private Map<String, List<TreeNode>> childrenNodesBasedOnParentURI = new HashMap<String, List<TreeNode>>();

    @Override
    public TreeNode getNode(ExecutionContext executionContext, String uri, int depth) {
        TreeNode node;
        if (this.treeNodeBasedOnURI.isEmpty() || ROOT_URI.equals(uri)) {
            this.refreshTreeData(this.retrieveCredentialsFromRequest(), this.retrieveEndpointFromRequest());
        }
        if ((node = this.treeNodeBasedOnURI.get(uri)) != null) {
            if (depth > 0) {
                this.processFolder(node, depth - 1);
            }
            return node;
        }
        return null;
    }

    public void refreshTreeData(AWSCredentials awsCredentials, String endpoint) {
        this.childrenNodesBasedOnParentURI.clear();
        this.treeNodeBasedOnURI.clear();
        this.createRootNode(ROOT_URI, "root");
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        for (String service : this.amazonDBServices) {
            String nodeUri = ROOT_URI + service.toLowerCase();
            TreeNode childNode = this.createRootNode(nodeUri, service);
            this.childrenNodesBasedOnParentURI.put(nodeUri, this.createChildrenNodes(this.awsDataSourceService.getAwsDBInstances(awsCredentials, service, endpoint)));
            children.add(childNode);
        }
        this.childrenNodesBasedOnParentURI.put(ROOT_URI, children);
    }

    private AWSCredentials retrieveCredentialsFromRequest() {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = attr.getRequest();
        String accessKey = request.getParameter("awsAccessKey");
        String secretKey = request.getParameter("awsSecretKey");
        String arn = request.getParameter("arn");
        arn = !StringUtils.isBlank((String)arn) ? arn : null;
        return AwsCredentialUtil.getAWSCredentials((String)accessKey, (String)secretKey, (String)arn);
    }

    private String retrieveEndpointFromRequest() {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = attr.getRequest();
        return request.getParameter("region");
    }

    private TreeNode createRootNode(String nodeUri, String serviceName) {
        RDSProperties extraProperty = new RDSProperties();
        extraProperty.dbUri = nodeUri;
        String label = this.messageSource.getMessage("tree.aws.folder." + serviceName, null, LocaleContextHolder.getLocale());
        TreeNodeImpl treeNode = new TreeNodeImpl(this, serviceName.toLowerCase(), label, "com.jaspersoft.jasperserver.api.metadata.common.domain.Folder", nodeUri, 1, extraProperty);
        this.treeNodeBasedOnURI.put(nodeUri, treeNode);
        return treeNode;
    }

    private List<TreeNode> createChildrenNodes(List<AwsDBInstanceDTO> dbInstances) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        if (dbInstances != null && dbInstances.size() > 0) {
            for (AwsDBInstanceDTO dbInstance : dbInstances) {
                String uri;
                RDSProperties extraProperty = new RDSProperties();
                extraProperty.dbUri = uri = this.generateAmazonDbInstanceURI(dbInstance);
                extraProperty.dBName = dbInstance.getdBName();
                extraProperty.dbType = dbInstance.getEngine();
                extraProperty.dbVersion = dbInstance.getEngineVersion();
                extraProperty.dnsAddress = dbInstance.getAddress();
                extraProperty.dbPort = dbInstance.getPort();
                extraProperty.jdbcTemplate = dbInstance.getJdbcTemplate();
                extraProperty.jdbcUrl = dbInstance.getJdbcUrl();
                extraProperty.jdbcDriverClass = dbInstance.getJdbcDriverClass();
                TreeNodeImpl treeNode = new TreeNodeImpl(this, dbInstance.getdBInstanceIdentifier(), dbInstance.getdBInstanceIdentifier(), AWS_DB, uri, 1, extraProperty);
                this.treeNodeBasedOnURI.put(uri, treeNode);
                treeNodeList.add(treeNode);
            }
            return treeNodeList;
        }
        return treeNodeList;
    }

    private String generateAmazonDbInstanceURI(AwsDBInstanceDTO dbInstance) {
        if (dbInstance != null) {
            return ROOT_URI + dbInstance.getAmazonDbService().toLowerCase() + ROOT_URI + dbInstance.getdBInstanceIdentifier();
        }
        return ROOT_URI;
    }

    @Override
    public List getChildren(ExecutionContext executionContext, String parentUri, int depth) {
        TreeNode n = this.getNode(executionContext, parentUri, depth + 1);
        if (n != null) {
            return n.getChildren();
        }
        return null;
    }

    private void processFolder(TreeNode node, int depth) {
        List<TreeNode> children = this.childrenNodesBasedOnParentURI.get(node.getUriString());
        if (children != null) {
            node.getChildren().clear();
            for (TreeNode child : children) {
                node.getChildren().add(child);
                if (depth <= 0) continue;
                this.processFolder(child, depth - 1);
            }
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setAwsDataSourceService(AwsDataSourceService awsDatasourceService) {
        this.awsDataSourceService = awsDatasourceService;
    }

    public void setAmazonDBServices(List<String> amazonDBServices) {
        this.amazonDBServices = amazonDBServices;
    }

    private static class RDSProperties
    implements JSONObject {
        public String dBName = null;
        public String dbType = null;
        public String dbVersion = null;
        public String dnsAddress = null;
        public Integer dbPort = null;
        public String dbUri = null;
        public String jdbcTemplate = null;
        public String jdbcUrl = null;
        public String jdbcDriverClass = null;

        private RDSProperties() {
        }

        @Override
        public String toJSONString() {
            org.json.JSONObject jsonObject = new org.json.JSONObject();
            try {
                jsonObject.put("dBName", (Object)this.dBName);
                jsonObject.put("dbType", (Object)this.dbType);
                jsonObject.put("dbVersion", (Object)this.dbVersion);
                jsonObject.put("dnsAddress", (Object)this.dnsAddress);
                jsonObject.put("dbPort", (Object)this.dbPort);
                jsonObject.put("dbUri", (Object)this.dbUri);
                jsonObject.put("jdbcTemplate", (Object)this.jdbcTemplate);
                jsonObject.put("jdbcUrl", (Object)this.jdbcUrl);
                jsonObject.put("jdbcDriverClass", (Object)this.jdbcDriverClass);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jsonObject.toString();
        }
    }
}

