/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFactoryFlowFactory;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRXml4SwfExporter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.view.AbstractView;

public class XmlExportController
implements Controller {
    private SessionObjectSerieAccessor jasperPrintAccessor;
    private String jasperPrintNameParameter;
    private String pageParameter;
    private HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory;
    private JasperReportsContext jasperReportsContext;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws JRException {
        JRHyperlinkProducerFactory factory;
        JasperPrint jasperPrint;
        String jasperPrintName = request.getParameter(this.getJasperPrintNameParameter());
        ReportUnitResult result = (ReportUnitResult)this.getJasperPrintAccessor().getObject(request, jasperPrintName);
        JasperPrint jasperPrint2 = jasperPrint = result == null ? null : result.getJasperPrint();
        if (jasperPrint == null) {
            throw new JSException("jsexception.jasperprint.not.found", new Object[]{jasperPrintName});
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JRXml4SwfExporter exporter = new JRXml4SwfExporter(this.getJasperReportsContext());
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        if (this.getHyperlinkProducerFactory() != null && (factory = this.getHyperlinkProducerFactory().getHyperlinkProducerFactory(request, response)) != null) {
            exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)factory);
        }
        int pageIndex = -1;
        try {
            pageIndex = Integer.parseInt(request.getParameter("page"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pageIndex >= 0 && jasperPrint.getPages().size() > 0) {
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer(pageIndex));
        }
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new JSException((Throwable)e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ex) {}
        }
        XmlExportView view = new XmlExportView(baos.toByteArray());
        return new ModelAndView((View)view);
    }

    public SessionObjectSerieAccessor getJasperPrintAccessor() {
        return this.jasperPrintAccessor;
    }

    public void setJasperPrintAccessor(SessionObjectSerieAccessor jasperPrintAccessor) {
        this.jasperPrintAccessor = jasperPrintAccessor;
    }

    public String getJasperPrintNameParameter() {
        return this.jasperPrintNameParameter;
    }

    public void setJasperPrintNameParameter(String jasperPrintNameAttribute) {
        this.jasperPrintNameParameter = jasperPrintNameAttribute;
    }

    public String getPageParameter() {
        return this.pageParameter;
    }

    public void setPageParameter(String pageParameter) {
        this.pageParameter = pageParameter;
    }

    public HyperlinkProducerFactoryFlowFactory getHyperlinkProducerFactory() {
        return this.hyperlinkProducerFactory;
    }

    public void setHyperlinkProducerFactory(HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory) {
        this.hyperlinkProducerFactory = hyperlinkProducerFactory;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    protected static class XmlExportView
    extends AbstractView {
        private final byte[] xmlData;

        public XmlExportView(byte[] xmlData) {
            this.xmlData = xmlData;
        }

        protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (this.xmlData != null && this.xmlData.length > 0) {
                response.setContentType("text/xml");
                response.setContentLength(this.xmlData.length);
                ServletOutputStream ouputStream = response.getOutputStream();
                ouputStream.write(this.xmlData, 0, this.xmlData.length);
                ouputStream.flush();
                ouputStream.close();
            } else {
                response.getOutputStream().close();
            }
        }
    }
}

