/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceLookupImpl;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapManagementService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.control.JRBaseMultiActionController;
import com.jaspersoft.jasperserver.war.util.OlapSessionState;
import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.mondrian.JPivotPackageAccess;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.OlapModelDecorator;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.bookmarks.BookmarkManager;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.table.EditableTableComponent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class OlapModelController
extends JRBaseMultiActionController {
    private static final Logger log = Logger.getLogger(OlapModelController.class);
    private Resources resources = Resources.instance(OlapModelController.class);
    private OlapConnectionService olapConnectionService;
    private OlapManagementService olapManagementService;
    private AuditContext auditContext;

    public OlapConnectionService getOlapConnectionService() {
        return this.olapConnectionService;
    }

    public void setOlapConnectionService(OlapConnectionService olapConnectionService) {
        this.olapConnectionService = olapConnectionService;
    }

    public OlapManagementService getOlapManagementService() {
        return this.olapManagementService;
    }

    public void setOlapManagementService(OlapManagementService olapManagementService) {
        this.olapManagementService = olapManagementService;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    private void createAuditEvent(final String olapUnitUri) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                AuditEvent auditEvent = OlapModelController.this.auditContext.getOpenedAuditEvent("olapView");
                if (auditEvent == null) {
                    auditEvent = OlapModelController.this.auditContext.createAuditEvent("olapView", olapUnitUri, null);
                } else {
                    auditEvent.setResourceUri(olapUnitUri);
                }
                OlapModelController.this.auditContext.setResourceTypeToAuditEvent(OlapUnit.class.getName(), auditEvent);
            }
        });
    }

    private void updateAuditEvent(final String olapUnitUri) {
        this.auditContext.doInAuditContext("olapView", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditEvent.setResourceUri(olapUnitUri);
            }
        });
    }

    public ModelAndView viewOlap(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        if (req.getParameter("_eventId_backFromErrorPage") != null) {
            String redirect = "redirect:/flow.html?_flowId=" + req.getParameter("_flowId") + "&folder=" + req.getParameter("folderPath");
            return new ModelAndView(redirect);
        }
        if (!this.isAnalysisFeatureSupported().booleanValue()) {
            return new ModelAndView("redirect:/licenseAnalysisFeatureUnavailable.html");
        }
        String viewUri = req.getParameter("name");
        if (viewUri != null && viewUri.startsWith("//")) {
            viewUri = viewUri.substring(1);
        }
        this.createAuditEvent(viewUri);
        HttpSession sess = req.getSession();
        if (viewUri == null || "".equals(viewUri)) {
            viewUri = (String)sess.getAttribute("currentView");
        } else if ("true".equals(req.getParameter("new"))) {
            try {
                OlapModelController.clearOlapSession(sess, viewUri);
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        if (viewUri == null || viewUri.length() == 0) {
            log.warn((Object)this.resources.getString("jsexception.session.timeout.occurred"));
            viewUri = (String)sess.getServletContext().getAttribute("name");
            if (viewUri == null) {
                log.warn((Object)this.resources.getString("jsexception.no.olap.model.name"));
                String redirect = "redirect:/" + this.resources.getString("jasperserver.OlapModelController.olapViewList");
                return new ModelAndView(redirect);
            }
        }
        this.updateAuditEvent(viewUri);
        String currentView = (String)sess.getAttribute("currentView");
        String currentUserName = (String)sess.getAttribute("currentUserName");
        Locale browserLocale = req.getLocale();
        Locale defaultLocale = RequestContext.instance().getLocale();
        Locale locale = LocaleContextHolder.getLocale();
        if (locale == null) {
            locale = defaultLocale;
        }
        log.debug((Object)("Request locale set to: " + locale.toString()));
        req.setAttribute("locale", (Object)locale);
        sess.setAttribute("locale", (Object)locale);
        sess.getServletContext().setAttribute("locale", (Object)browserLocale);
        boolean wasInDrillThrough = sess.getAttribute("inDrillThrough") != null && ((String)sess.getAttribute("inDrillThrough")).equals("true");
        String drillThrough = this.getDrillThrough(req, sess);
        if (wasInDrillThrough && drillThrough == null) {
            try {
                OlapModelController.clearDrillThroughConnectionFromSession(sess, currentView);
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        sess.setAttribute("drillthrough", (Object)drillThrough);
        req.setAttribute("name", (Object)viewUri);
        sess.getServletContext().setAttribute("name", (Object)viewUri);
        boolean isSameView = false;
        if (currentView != null && viewUri.equals(currentView)) {
            isSameView = true;
        } else {
            if (currentView != null) {
                try {
                    OlapModelController.clearOlapSession(sess, currentView);
                }
                catch (Exception ex) {
                    throw new ServletException((Throwable)ex);
                }
            }
            sess.setAttribute("currentView", (Object)viewUri);
        }
        boolean isSameUser = this.setCurrentUser(sess, currentUserName);
        if (!isSameUser) {
            this.removeAttributesEndingWith(sess, "saveas");
        }
        log.debug((Object)("Viewing OLAP Model: " + viewUri + ", isSameView: " + isSameView + ", isSameUser: " + isSameUser));
        HashMap<String, OlapSessionState> olapModels = (HashMap<String, OlapSessionState>)sess.getAttribute("olapModels");
        if (olapModels == null) {
            olapModels = new HashMap<String, OlapSessionState>();
            sess.setAttribute("olapModels", olapModels);
        }
        sess.setAttribute("drillThroughTableModel", (Object)new MondrianDrillThroughTableModel(null));
        OlapSessionState sessionState = (OlapSessionState)olapModels.get(viewUri);
        if (sessionState == null || sessionState.getOlapModel() == null || req.getParameter("mdx") != null || !isSameUser) {
            Util.PropertyList connectInfo;
            Model mdl;
            String curView;
            EditableTableComponent drillthru;
            log.debug((Object)"Swapping view");
            sessionState = this.getOlapSession(viewUri, sess);
            olapModels.put(viewUri, sessionState);
            sess.setAttribute("drillthrough", (Object)drillThrough);
            sess.setAttribute("olapUnit", (Object)sessionState.getOlapUnit());
            BookmarkManager.instance((HttpSession)sess).restoreSessionState(null);
            Object state = null;
            OlapUnit olapUnit = sessionState.getOlapUnit();
            if (olapUnit != null && olapUnit.getOlapViewOptions() != null) {
                state = olapUnit.getOlapViewOptions();
                BookmarkManager.instance((HttpSession)sess).restoreSessionState(state);
            }
            if ((drillthru = (EditableTableComponent)sess.getAttribute((curView = (String)sess.getAttribute("currentView")) + ".drillthroughtable")) == null && (mdl = ((OlapModelProxy)sessionState.getOlapModel()).getRootModel()) instanceof MondrianModel && (connectInfo = ((MondrianModel)mdl).getConnectProperties()) != null) {
                MondrianDrillThroughTableModel dtm = new MondrianDrillThroughTableModel(null);
                String jdbcUrl = connectInfo.get(RolapConnectionProperties.Jdbc.name());
                String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
                String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
                String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
                dtm.setJdbcUrl(jdbcUrl);
                dtm.setJdbcUser(jdbcUser);
                dtm.setJdbcPassword(jdbcPassword);
                dtm.setDataSourceName(dataSourceName);
                HashMap hMap = (HashMap)state;
                if (hMap != null) {
                    String curSql = (String)hMap.get("drillThruSQL");
                    dtm.setSql(curSql);
                    sess.setAttribute("drillThroughTableModel", (Object)dtm);
                    sess.removeAttribute("belowCube");
                    if (curSql != null && curSql.length() > 0) {
                        log.debug((Object)("Drillthrough SQL: " + curSql));
                        log.debug((Object)"Display drill-through table.");
                        if (state != null && viewUri != null) {
                            HashMap stateMap = (HashMap)((HashMap)state).get(viewUri + "/displayform");
                            if (stateMap != null) {
                                Boolean showTableBelowCube = (Boolean)stateMap.get("extensions(drillThrough).showTableBelowCube");
                                sess.setAttribute("belowCube", (Object)(showTableBelowCube != false ? "true" : "false"));
                            } else {
                                log.error((Object)"Invalid displayform state.");
                            }
                        } else {
                            log.error((Object)"Invalid view URI, or view state.");
                        }
                        sess.setAttribute("drillthrough", (Object)"y");
                        sess.setAttribute("inDrillThrough", (Object)"true");
                    } else {
                        log.debug((Object)"Drill-through table not displayed");
                    }
                } else {
                    dtm.setSql("");
                }
            }
        } else if (!isSameView) {
            log.debug((Object)"setting session state as !isSameView");
            sessionState = this.getOlapSession(viewUri, sess);
        }
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        this.getOlapManagementService().notifySchemaUse((ExecutionContext)executionContext, (Resource)sessionState.getOlapClientConnection());
        this.setJPivotParams(req, sessionState.getOlapModel());
        req.setAttribute("olapModel", (Object)sessionState.getOlapModel());
        req.setAttribute("olapSession", (Object)sessionState);
        req.setAttribute("drillthrough", (Object)drillThrough);
        if (sess != null && sess.getAttribute("olapModel") == null || sessionState != null && sessionState.getOlapModel() != null && sess.getAttribute("olapModel") != sessionState.getOlapModel()) {
            sess.setAttribute("olapModel", (Object)sessionState.getOlapModel());
        }
        return new ModelAndView("/modules/olap/viewOlap");
    }

    public static void clearOlapSession(HttpSession sess, String uriToRemove) throws Exception {
        Map olapModels = (Map)sess.getAttribute("olapModels");
        if (olapModels == null) {
            return;
        }
        log.debug((Object)("clearing OLAP session of " + uriToRemove));
        OlapSessionState existingModel = (OlapSessionState)olapModels.get(uriToRemove);
        if (existingModel != null) {
            ((OlapModelProxy)existingModel.getOlapModel()).destroyAll();
        }
        olapModels.remove(uriToRemove);
        sess.setAttribute("olapUnit", null);
        Enumeration coll = sess.getAttributeNames();
        while (coll.hasMoreElements()) {
            String attName = (String)coll.nextElement();
            if (!attName.startsWith(uriToRemove)) continue;
            log.debug((Object)("Removing " + attName + ", " + sess.getAttribute(attName).getClass().getName()));
            Object att = sess.getAttribute(attName);
            OlapModelController.clearDrillThroughConnection(attName, att);
            sess.removeAttribute(attName);
        }
        BookmarkManager.instance((HttpSession)sess).restoreSessionState(null);
    }

    public static void clearDrillThroughConnectionFromSession(HttpSession sess, String uriToRemove) throws Exception {
        Enumeration coll = sess.getAttributeNames();
        while (coll.hasMoreElements()) {
            String attName = (String)coll.nextElement();
            Object att = sess.getAttribute(attName);
            if (!attName.startsWith(uriToRemove)) continue;
            OlapModelController.clearDrillThroughConnection(attName, att);
        }
    }

    public static void clearDrillThroughConnection(String attName, Object att) throws Exception {
        if (attName.endsWith(".drillthroughtable") && att instanceof EditableTableComponent) {
            EditableTableComponent etc = (EditableTableComponent)att;
            log.debug((Object)("clearDrillThroughConnection for URI " + attName));
            MondrianDrillThroughTableModel dtm = (MondrianDrillThroughTableModel)etc.getModel();
            dtm.destroy();
        }
    }

    private void removeAttributesEndingWith(HttpSession sess, String component) {
        Enumeration attributeNames = sess.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attribute = (String)attributeNames.nextElement();
            if (!attribute.endsWith(component)) continue;
            sess.removeAttribute(attribute);
            break;
        }
    }

    private String getDrillThrough(HttpServletRequest req, HttpSession sess) {
        String drillthrough = null;
        Map parametersMap = req.getParameterMap();
        Iterator itrMap = parametersMap.entrySet().iterator();
        sess.setAttribute("inDrillThrough", (Object)"false");
        while (itrMap.hasNext()) {
            Map.Entry mapEntry = itrMap.next();
            String requestParameter = (String)mapEntry.getKey();
            if (requestParameter.equals("d")) {
                drillthrough = ((String[])mapEntry.getValue())[0];
                sess.setAttribute("inDrillThrough", (Object)"true");
                if (sess.getAttribute("changemode") == null) break;
                sess.removeAttribute("changemode");
                break;
            }
            if (!requestParameter.contains("drillthrough")) continue;
            if (sess.getAttribute("changemode") != null) {
                sess.removeAttribute("changemode");
                break;
            }
            drillthrough = "x";
            sess.setAttribute("inDrillThrough", (Object)"true");
            break;
        }
        return drillthrough;
    }

    protected void setJPivotParams(HttpServletRequest req, OlapModel model) {
        String mdx = req.getParameter("mdx");
        if (mdx != null) {
            log.debug((Object)("mdx request param: |" + mdx + "|"));
            log.debug((Object)("OlapModel class: " + model.getClass()));
            while (model instanceof OlapModelDecorator) {
                model = ((OlapModelDecorator)model).getDelegate();
                log.debug((Object)("OlapModel class: " + model.getClass()));
            }
            if (model.getClass() == MondrianModel.class) {
                JPivotPackageAccess.setMdx((MondrianModel)model, mdx);
            }
            if (model.getClass() == XMLA_Model.class) {
                try {
                    ((XMLA_Model)model).setUserMdx(mdx);
                }
                catch (OlapException oe) {
                    log.error((Object)oe);
                }
            }
        }
    }

    protected OlapSessionState getOlapSession(String viewUri, HttpSession sess) {
        log.debug((Object)("Setting OlapModel for " + viewUri));
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        OlapUnit olapUnit = (OlapUnit)this.getRepository().getResource((ExecutionContext)executionContext, viewUri);
        if (olapUnit == null) {
            throw new JSException("jsexception.no.olap.model.retrieved");
        }
        OlapModel model = this.getOlapConnectionService().initializeOlapModel((ExecutionContext)executionContext, olapUnit, sess);
        OlapClientConnection olapConnection = (OlapClientConnection)this.getOlapConnectionService().dereference((ExecutionContext)executionContext, olapUnit.getOlapClientConnection());
        return new OlapSessionState(model, olapUnit, olapConnection);
    }

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ModelAndView modelAndView = null;
        ResourceLookupImpl olapUnitCommand = (ResourceLookupImpl)command;
        String olapUnitName = olapUnitCommand.getName();
        if (olapUnitName != null) {
            modelAndView = new ModelAndView("modules/olap/viewOlap", "olapUnitName", (Object)olapUnitName);
        } else {
            ExecutionContext executionContext = JasperServerUtil.getExecutionContext(request);
            ResourceLookup[] olapUnits = this.repository.findResource(executionContext, FilterCriteria.createFilter(OlapUnit.class));
            modelAndView = new ModelAndView("modules/listOlapViews", "olapUnits", (Object)olapUnits);
        }
        return modelAndView;
    }

    private boolean setCurrentUser(HttpSession sess, String currentUserName) {
        User user;
        boolean isSameUser = false;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication.getPrincipal() == null) {
            log.error((Object)"authenticationError");
        }
        if ((user = (User)authentication.getPrincipal()) == null) {
            log.error((Object)"userError");
        }
        String userName = user.getFullName();
        if (currentUserName != null && userName.equals(currentUserName)) {
            isSameUser = true;
        } else {
            sess.setAttribute("currentUserName", (Object)userName);
        }
        return isSameUser;
    }

    protected Boolean isAnalysisFeatureSupported() {
        return true;
    }
}

