/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;

public class InputControlValueClassResolver {
    public static Class<?> getValueClass(DataType dataType, ReportInputControlInformation info, boolean returnNestedType) {
        Class<Object> valueClass = InputControlValueClassResolver.getInputControlValueClass(info, returnNestedType);
        if (valueClass == null && dataType != null) {
            switch (dataType.getType()) {
                case 1: {
                    valueClass = String.class;
                    break;
                }
                case 2: {
                    valueClass = BigDecimal.class;
                    break;
                }
                case 3: {
                    valueClass = Date.class;
                    break;
                }
                case 4: {
                    valueClass = Timestamp.class;
                    break;
                }
                case 5: {
                    valueClass = Time.class;
                }
            }
        }
        if (valueClass == null) {
            valueClass = String.class;
        }
        return valueClass;
    }

    public static Class<?> getValueClass(DataType dataType, ReportInputControlInformation info) {
        return InputControlValueClassResolver.getValueClass(dataType, info, true);
    }

    private static Class<?> getInputControlValueClass(ReportInputControlInformation info, boolean returnNestedType) {
        Class parameterType = null;
        if (info != null && info.getValueType() != null) {
            if (Collection.class.isAssignableFrom(info.getValueType())) {
                if (!returnNestedType) {
                    parameterType = info.getValueType();
                } else if (info.getNestedType() != null) {
                    parameterType = info.getNestedType();
                }
            } else {
                parameterType = info.getValueType();
            }
        }
        return parameterType;
    }
}

