/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers;

import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.BasicInputControlHandler;
import com.jaspersoft.jasperserver.war.cascade.handlers.ValuesLoader;
import com.jaspersoft.jasperserver.war.dto.InputControlOption;
import com.jaspersoft.jasperserver.war.dto.InputControlState;
import com.jaspersoft.jasperserver.war.dto.ReportInputControl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleSelectListInputControlHandler
extends BasicInputControlHandler {
    protected static final Log log = LogFactory.getLog(SingleSelectListInputControlHandler.class);
    private ValuesLoader loader;

    public ValuesLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ValuesLoader loader) {
        this.loader = loader;
    }

    @Override
    public ReportInputControl buildReportInputControl(InputControl inputControl, String uiType) throws CascadeResourceNotFoundException {
        ReportInputControl reportInputControl = super.buildReportInputControl(inputControl, uiType);
        Set<String> masterDependencies = this.loader.getMasterDependencies(inputControl);
        if (masterDependencies != null) {
            reportInputControl.getMasterDependencies().addAll(masterDependencies);
        }
        return reportInputControl;
    }

    @Override
    public Set<String> getMasterDependencies(InputControl control) throws CascadeResourceNotFoundException {
        return this.loader.getMasterDependencies(control);
    }

    @Override
    protected Object internalConvertParameterValueFromRawData(String[] rawData, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException, InputControlValidationException {
        Object value;
        try {
            value = super.internalConvertParameterValueFromRawData(rawData, inputControl, info);
        }
        catch (InputControlValidationException e) {
            e.getValidationError().setInvalidValue(null);
            throw e;
        }
        return value;
    }

    @Override
    protected void internalValidateValue(Object value, InputControl inputControl, ReportInputControlInformation info) throws InputControlValidationException, CascadeResourceNotFoundException {
        DataType dataType = inputControl.getDataType() != null ? this.cachedRepositoryService.getResource(DataType.class, inputControl.getDataType()) : null;
        try {
            this.validateSingleValue(value, dataType);
        }
        catch (InputControlValidationException e) {
            e.getValidationError().setInvalidValue(null);
            throw e;
        }
    }

    @Override
    protected void fillStateValue(InputControlState state, InputControl inputControl, ResourceReference dataSource, Map<String, Object> parameters, ReportInputControlInformation info, Map<String, Class<?>> parameterTypes) throws CascadeResourceNotFoundException {
        List<ListOfValuesItem> values = this.loader.loadValues(inputControl, dataSource, parameters, parameterTypes, info);
        DataType dataType = inputControl.getDataType() != null ? this.cachedRepositoryService.getResource(DataType.class, inputControl.getDataType()) : null;
        ArrayList<InputControlOption> options = new ArrayList<InputControlOption>();
        InputControlOption nothingOption = null;
        if (this.shouldAddNothinSelectedOption(inputControl).booleanValue()) {
            nothingOption = this.buildInputControlOption("---", "~NOTHING~");
            options.add(nothingOption);
        }
        HashMap<InputControlOption, Object> defaultOptions = new HashMap<InputControlOption, Object>();
        ArrayList<Object> selectedValues = new ArrayList<Object>();
        String controlName = inputControl.getName();
        Boolean isNothingSelected = this.isNothingSelected(controlName, parameters);
        Object incomingValue = parameters.get(controlName);
        Object defaultValue = info.getDefaultValue();
        if (values != null && !values.isEmpty()) {
            for (ListOfValuesItem currentItem : values) {
                Object currentItemValue = currentItem.getValue();
                if (currentItemValue instanceof String) {
                    try {
                        currentItemValue = this.dataConverterService.convertSingleValue((String)currentItemValue, inputControl, info);
                    }
                    catch (InputControlValidationException e) {
                        throw new IllegalStateException(e.getValidationError().getDefaultMessage());
                    }
                }
                boolean optionIsValid = true;
                try {
                    this.validateSingleValue(currentItem.getValue(), dataType);
                }
                catch (InputControlValidationException e) {
                    optionIsValid = false;
                }
                if (!optionIsValid) continue;
                InputControlOption option = this.buildInputControlOption(currentItem.getLabel(), this.dataConverterService.formatSingleValue(currentItemValue, inputControl, info));
                Boolean isSelected = isNothingSelected == false && this.matches(currentItemValue, incomingValue) != false;
                option.setSelected(isSelected);
                if (isSelected.booleanValue()) {
                    selectedValues.add(currentItemValue);
                }
                if (selectedValues.size() == 0 && !isNothingSelected.booleanValue() && this.matches(currentItemValue, defaultValue).booleanValue()) {
                    defaultOptions.put(option, currentItemValue);
                }
                options.add(option);
            }
        }
        if (selectedValues.size() == 0 && !options.isEmpty()) {
            if (!defaultOptions.isEmpty()) {
                for (InputControlOption defaultOption : defaultOptions.keySet()) {
                    defaultOption.setSelected(true);
                }
                selectedValues = new ArrayList(defaultOptions.values());
            } else if (inputControl.isMandatory() && !isNothingSelected.booleanValue()) {
                ((InputControlOption)options.get(0)).setSelected(true);
                selectedValues.add(values.get(0).getValue());
            }
        }
        state.setOptions(options);
        if (selectedValues.size() == 0) {
            if (inputControl.isMandatory()) {
                this.doMandatoryValidation(null, state);
            }
            this.applyNothingSelected(controlName, parameters);
            if (nothingOption != null) {
                nothingOption.setSelected(true);
            }
            this.internalApplyNothingSubstitution(controlName, parameters);
        } else {
            parameters.put(controlName, this.getConcreteSelectedValue(selectedValues));
        }
    }

    protected Boolean shouldAddNothinSelectedOption(InputControl inputControl) {
        return !inputControl.isMandatory();
    }

    protected Boolean isNothingSelected(String inputControlName, Map<String, Object> incomingParameters) {
        return !incomingParameters.containsKey(inputControlName);
    }

    protected Object getConcreteSelectedValue(List<Object> selectedValues) {
        return selectedValues != null && !selectedValues.isEmpty() ? selectedValues.get(0) : null;
    }

    protected Boolean matches(Object valueToCheck, Object selected) {
        boolean isWorkaroudForNumbers;
        boolean areBothNulls = valueToCheck == null && selected == null;
        boolean isDirectEquality = selected != null && selected.equals(valueToCheck);
        boolean bl = isWorkaroudForNumbers = valueToCheck instanceof Number && selected instanceof Number && ((Number)((Object)valueToCheck)).doubleValue() == ((Number)((Object)selected)).doubleValue();
        if (areBothNulls || isDirectEquality || isWorkaroudForNumbers) {
            return true;
        }
        boolean isEqualityByStringFormats = false;
        try {
            if (valueToCheck != null && selected != null) {
                String valueToCheckInStringFormat = this.dataConverterService.formatSingleValue((Object)valueToCheck, null, (Class)null);
                String selectedInStringFormat = this.dataConverterService.formatSingleValue(selected, null, (Class)null);
                if (valueToCheckInStringFormat != null && selectedInStringFormat != null) {
                    isEqualityByStringFormats = selectedInStringFormat.equals(valueToCheckInStringFormat);
                }
            }
        }
        catch (IllegalStateException e) {
            log.warn((Object)MessageFormat.format("Can't convert incoming value type '{0}'  or  selected value type '{1}' to string format. Add converters to register", valueToCheck != null ? valueToCheck.getClass() : valueToCheck, selected != null ? selected.getClass() : selected));
        }
        return isEqualityByStringFormats;
    }

    protected InputControlOption buildInputControlOption(String label, String value) {
        return new InputControlOption(value, label);
    }
}

