/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlsInformation;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportLoadingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.war.cascade.CachedRepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.cache.ControlLogicCacheManager;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import com.jaspersoft.jasperserver.war.cascade.token.FilterResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class CachedEngineService {
    private static final Log log = LogFactory.getLog(CachedEngineService.class);
    @Resource
    private ControlLogicCacheManager controlLogicCacheManager;
    @Resource
    private CachedRepositoryService cachedRepositoryService;
    @Resource
    protected EngineService engineService;
    @Resource
    private FilterResolver filterResolver;
    @Resource
    private ReportLoadingService reportLoadingService;
    @Resource(name="inputControlsCachingEnabled")
    private boolean doCache;

    public ReportInputControlsInformation getReportInputControlsInformation(ExecutionContext exContext, InputControlsContainer container, Map<String, Object> initialParameters) {
        SessionCache sessionCache = this.controlLogicCacheManager.getSessionCache();
        ReportInputControlsInformation infos = sessionCache.getCacheInfo(ReportInputControlsInformation.class, container.getURI());
        if (!this.doCache || infos == null) {
            infos = this.engineService.getReportInputControlsInformation(exContext, container, initialParameters);
            sessionCache.setCacheInfo(ReportInputControlsInformation.class, container.getURI(), infos);
        }
        return infos;
    }

    public List<InputControl> getInputControls(InputControlsContainer container) {
        SessionCache sessionCache = this.controlLogicCacheManager.getSessionCache();
        List inputControls = sessionCache.getCacheInfo(List.class, container.getURI());
        if (!this.doCache || inputControls == null) {
            inputControls = this.reportLoadingService.getInputControls(ExecutionContextImpl.getRuntimeExecutionContext(), container);
            sessionCache.setCacheInfo(List.class, container.getURI(), inputControls);
        }
        ArrayList<InputControl> copy = new ArrayList<InputControl>(inputControls.size());
        copy.addAll(inputControls);
        return copy;
    }

    public ReportInputControlsInformation getReportInputControlsInformation(ReportUnit reportUnit) {
        return this.getReportInputControlsInformation(ExecutionContextImpl.getRuntimeExecutionContext(), (InputControlsContainer)reportUnit, null);
    }

    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference, Map<String, Object> parameterValues, Map<String, Class<?>> parameterTypes, String controlName) throws CascadeResourceNotFoundException {
        Query query = this.cachedRepositoryService.getResource(Query.class, queryReference);
        String cacheKey = String.valueOf(this.filterResolver.getCacheKey(query.getSql(), parameterValues));
        SessionCache sessionCache = this.controlLogicCacheManager.getSessionCache();
        OrderedMap results = sessionCache.getCacheInfo(OrderedMap.class, cacheKey);
        if (!this.doCache || results == null) {
            results = this.engineService.executeQuery(context != null ? context : ExecutionContextImpl.getRuntimeExecutionContext(), queryReference, keyColumn, resultColumns, defaultDataSourceReference, parameterValues, parameterTypes, false);
            sessionCache.setCacheInfo(OrderedMap.class, cacheKey, results);
            log.debug((Object)("Database query \"" + cacheKey + "\""));
        } else {
            log.debug((Object)("Cached query \"" + cacheKey + "\""));
        }
        return results;
    }

    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference, Map<String, Object> parameterValues, String controlName) throws CascadeResourceNotFoundException {
        return this.executeQuery(context, queryReference, keyColumn, resultColumns, defaultDataSourceReference, parameterValues, null, controlName);
    }

    public ControlLogicCacheManager getControlLogicCacheManager() {
        return this.controlLogicCacheManager;
    }

    public void setControlLogicCacheManager(ControlLogicCacheManager controlLogicCacheManager) {
        this.controlLogicCacheManager = controlLogicCacheManager;
    }

    public EngineService getEngineService() {
        return this.engineService;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }

    public boolean isDoCache() {
        return this.doCache;
    }

    public void setDoCache(boolean doCache) {
        this.doCache = doCache;
    }

    public void setCachedRepositoryService(CachedRepositoryService cachedRepositoryService) {
        this.cachedRepositoryService = cachedRepositoryService;
    }
}

