/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSShowOnlyErrorMessage;
import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.domain.ReportResult;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.service.VirtualizerFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.RepositoryUtils;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.war.action.JSController;
import com.jaspersoft.jasperserver.war.action.ReportCanceledException;
import com.jaspersoft.jasperserver.war.action.ReportExecutionAttributes;
import com.jaspersoft.jasperserver.war.action.ReportParametersAction;
import com.jaspersoft.jasperserver.war.action.UIExceptionRouter;
import com.jaspersoft.jasperserver.war.action.WebflowReportContext;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFactoryFlowFactory;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationError;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.web.JRInteractiveException;
import net.sf.jasperreports.web.JRInteractiveRuntimeException;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.actions.MultiAction;
import net.sf.jasperreports.web.commands.CommandStack;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import net.sf.jasperreports.web.util.JacksonUtil;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.RequestContext;

public class ViewReportAction
extends ReportParametersAction {
    protected static final Log log = LogFactory.getLog(ViewReportAction.class);
    public static final String REPORTUNIT_URI = "reportUnit";
    private static final String ATTRIBUTE_ORGANIZATION_ID = "organizationId";
    private static final String ATTRIBUTE_PUBLIC_FOLDER_URI = "publicFolderUri";
    private static final String ATTRIBUTE_TEMP_FOLDER_URI = "tempFolderUri";
    public static final String ATTRIBUTE_EMPTY_REPORT_MESSAGE = "emptyReportMessage";
    private String flowAttributeInhibitRequestParsing;
    private String requestParameterPageIndex;
    private String flowAttributePageIndex;
    private String requestAttributeHtmlLinkHandlerFactory;
    private String flowAttributeDepth;
    private String flowAttributeJasperPrintName;
    private String flowAttributeReportRequestId = "reportRequestId";
    private HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory;
    private String flowAttributeIsSubflow;
    private String requestParameterReportOutput;
    private String flowAttributeReportOutput;
    private String flowAttributeUseClientTimezone;
    private SessionObjectSerieAccessor jasperPrintAccessor;
    private VirtualizerFactory virtualizerFactory;
    private Map configuredExporters;
    private List exportersSupportedByiPad;
    private String attributeReportControlsLayout;
    private String attributeReportForceControls;
    private String attributeSavedInputsState;
    private String attributeControlsHidden;
    private String attributeDashboardParametersHasError;
    private String attributeIgnorePagination;
    private String attributeReportLocale;
    private String parameterReportLocale;
    private AuditContext auditContext;
    private String requestParameterAnchor;
    private String flowAttributeInitialPageIndex;
    private String flowAttributeInitialAnchor;
    private boolean defaultAsyncReport = true;
    private boolean defaultRecordDataSnapshot = true;
    private String parameterAsyncReport = "asyncReport";
    private String attributeAsyncReport = "asyncReport";
    private SecurityContextProvider securityContextProvider;
    private ConfigurationBean configuration;
    private JasperReportsContext jasperReportsContext;
    @Resource(name="uiExceptionRouter")
    private UIExceptionRouter uiExceptionRouter;
    public static final String PARAMETERS_WITHOUT_DEFAULT_VALUES = "parametersWithoutDefaultValues";
    private Boolean showDialogForMandatoryInputControlsWithoutDefaultValue = false;

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    protected void createInputControlsAuditEvent() {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ViewReportAction.this.auditContext.createAuditEvent("inputControlsQuery");
            }
        });
    }

    protected void setResourceUriToInputControlsAuditEvent(final String resourceUri) {
        this.auditContext.doInAuditContext("inputControlsQuery", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                if (auditEvent.getResourceUri() == null) {
                    auditEvent.setResourceUri(resourceUri);
                }
            }
        });
    }

    protected void closeInputControlsAuditEvent() {
        this.auditContext.doInAuditContext("inputControlsQuery", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ViewReportAction.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public Event checkSessionRefresh(RequestContext context) {
        HttpServletRequest req = (HttpServletRequest)context.getExternalContext().getNativeRequest();
        if (!req.isRequestedSessionIdValid()) {
            req.setAttribute("needPageRefresh", (Object)true);
        }
        return this.success();
    }

    @Override
    public Event checkForParams(RequestContext context) {
        String reportOutput;
        String standAlone;
        this.createInputControlsAuditEvent();
        MutableAttributeMap flowScope = context.getFlowScope();
        Integer depth = flowScope.getInteger(this.getFlowAttributeDepth());
        if (depth == null) {
            depth = new Integer(0);
            flowScope.put(this.getFlowAttributeDepth(), (Object)depth);
        }
        boolean isSubflow = !context.getFlowExecutionContext().getActiveSession().isRoot();
        flowScope.put(this.getFlowAttributeIsSubflow(), (Object)isSubflow);
        String folderURI = context.getRequestParameters().get("ParentFolderUri");
        if (folderURI != null) {
            flowScope.put("ParentFolderUri", (Object)folderURI);
        }
        if ((standAlone = context.getRequestParameters().get("standAlone")) != null) {
            flowScope.put("standAlone", (Object)standAlone);
        }
        if ((reportOutput = context.getRequestParameters().get(this.getRequestParameterReportOutput())) != null) {
            flowScope.put(this.getFlowAttributeReportOutput(), (Object)reportOutput);
        }
        try {
            Integer initialPageIndex = context.getRequestParameters().getInteger(this.requestParameterPageIndex);
            if (initialPageIndex != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting initial page index to " + initialPageIndex));
                }
                flowScope.put(this.flowAttributeInitialPageIndex, (Object)initialPageIndex);
            }
        }
        catch (ConversionExecutionException e) {
            log.debug((Object)("Unable to parse page index parameter with value " + context.getRequestParameters().get(this.requestParameterPageIndex)));
        }
        String initialAnchor = context.getRequestParameters().get(this.requestParameterAnchor);
        if (initialAnchor != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting initial anchor to " + initialAnchor));
            }
            flowScope.put(this.flowAttributeInitialAnchor, (Object)initialAnchor);
        }
        this.setReportLocale(context);
        this.setAsyncReport(context);
        boolean parseRequest = this.toParseRequest(context);
        flowScope.put(this.getFlowAttributeUseClientTimezone(), (Object)(!parseRequest ? 1 : 0));
        flowScope.put(PARAMETERS_WITHOUT_DEFAULT_VALUES, (Object)this.getMandatoryParametersWithoutDefaultValuesAsJSON(context));
        try {
            super.checkForParams(context);
        }
        catch (Exception e) {
            if ("true".equals(context.getRequestParameters().get("viewAsDashboardFrame"))) {
                context.getFlashScope().put(this.getAttributeDashboardParametersHasError(), (Object)"true");
            }
            throw new RuntimeException(e);
        }
        this.closeInputControlsAuditEvent();
        return this.success();
    }

    protected String getMandatoryParametersWithoutDefaultValuesAsJSON(RequestContext context) {
        if (!this.showDialogForMandatoryInputControlsWithoutDefaultValue.booleanValue()) {
            return this.convertObjectToJSONString(Collections.emptySet());
        }
        Set<String> parametersWithoutDefaults = this.getParametersWithoutDefaultValues(context);
        for (InputControl ic : this.getInputControls(context)) {
            if (ic.isMandatory()) continue;
            parametersWithoutDefaults.remove(ic.getName());
        }
        return this.convertObjectToJSONString(parametersWithoutDefaults);
    }

    protected void setReportLocale(RequestContext context) {
        Locale locale = (Locale)context.getFlowScope().get(this.getAttributeReportLocale(), Locale.class);
        if (locale == null) {
            String localeCode = context.getRequestParameters().get(this.getParameterReportLocale());
            locale = localeCode == null ? LocaleContextHolder.getLocale() : LocaleHelper.getInstance().getLocale(localeCode);
            context.getFlowScope().put(this.getAttributeReportLocale(), (Object)locale);
        }
    }

    protected void setAsyncReport(RequestContext context) {
        Boolean asyncReportParam = context.getRequestParameters().getBoolean(this.getParameterAsyncReport());
        if (asyncReportParam != null) {
            context.getFlowScope().put(this.getAttributeAsyncReport(), (Object)asyncReportParam);
        }
    }

    @Override
    protected void setReportUnitAttributes(RequestContext context, ReportUnit reportUnit) {
        super.setReportUnitAttributes(context, reportUnit);
        MutableAttributeMap flowScope = context.getFlowScope();
        flowScope.put(this.getAttributeReportControlsLayout(), (Object)new Byte(reportUnit.getControlsLayout()));
        flowScope.put(this.getAttributeReportForceControls(), (Object)reportUnit.isAlwaysPromptControls());
    }

    protected boolean toParseRequest(RequestContext context) {
        Boolean inhibitRequestParsingAttr = context.getFlowScope().getBoolean(this.getFlowAttributeInhibitRequestParsing());
        boolean parseRequest = inhibitRequestParsingAttr == null || inhibitRequestParsingAttr == false;
        return parseRequest;
    }

    protected void addReportExecutionParameters(RequestContext context, Map<String, Object> parameterValues) {
        if (this.virtualizerFactory != null) {
            parameterValues.put("REPORT_VIRTUALIZER", this.virtualizerFactory.getVirtualizer());
        }
        this.setIgnorePaginationParameter(context, parameterValues);
        this.setReportLocaleParameter(context, parameterValues);
        ReportContext reportContext = this.getReportContext(context);
        parameterValues.put("REPORT_CONTEXT", reportContext);
        parameterValues.put("HTTP_SERVLET_REQUEST", context.getExternalContext().getNativeRequest());
        ((WebflowReportContext)reportContext).setParameterValue("REPORT_LOCALE", context.getFlowScope().get(this.getAttributeReportLocale(), Locale.class));
        Action action = this.getAction(reportContext, this.jasperReportsContext);
        JSController controller = new JSController(this.jasperReportsContext);
        try {
            controller.runAction(reportContext, action);
        }
        catch (JRInteractiveException e) {
            throw new JRInteractiveRuntimeException(e.getMessage());
        }
    }

    protected void setReportLocaleParameter(RequestContext context, Map<String, Object> parameterValues) {
        Locale locale = (Locale)context.getFlowScope().get(this.getAttributeReportLocale(), Locale.class);
        if (locale != null) {
            parameterValues.put("REPORT_LOCALE", locale);
        }
    }

    protected void setIgnorePaginationParameter(RequestContext context, Map<String, Object> parameterValues) {
        Boolean ignorePagination = (Boolean)context.getRequestScope().get(this.getAttributeIgnorePagination(), Boolean.class);
        if (ignorePagination != null) {
            parameterValues.put("IS_IGNORE_PAGINATION", ignorePagination);
        }
    }

    public Event chooseExportMode(RequestContext context) {
        String reportOutput = context.getFlowScope().getString("reportOutput");
        Boolean reportForceControls = context.getFlowScope().getBoolean("reportForceControls");
        Boolean hasInputControls = context.getFlowScope().getBoolean("hasInputControls");
        String action = context.getRequestParameters().get("action");
        if (reportOutput == null || reportOutput.isEmpty() || reportOutput.equals("html")) {
            return this.getEventFactorySupport().event((Object)this, "viewReport");
        }
        if (hasInputControls.booleanValue() && reportForceControls.booleanValue() && action == null) {
            return this.getEventFactorySupport().event((Object)this, "showInputControlsByExport");
        }
        return this.getEventFactorySupport().event((Object)this, "exportReport");
    }

    public Event runReport(RequestContext context) {
        this.removeCurrentJasperPrint(context);
        ReportUnitResult result = this.executeReport(context);
        this.setJasperPrint(context, result);
        Integer pageIndex = this.getInitialPageIndex(result, context);
        if (pageIndex == null) {
            context.getFlowScope().remove(this.getFlowAttributePageIndex());
        } else {
            context.getFlowScope().put(this.getFlowAttributePageIndex(), (Object)pageIndex);
        }
        return this.success();
    }

    protected Integer getInitialPageIndex(ReportUnitResult result, RequestContext context) {
        JasperPrintAccessor printAccessor = result.getJasperPrintAccessor();
        Integer pageIndex = context.getFlowScope().getInteger(this.flowAttributeInitialPageIndex);
        if (pageIndex == null) {
            String anchor = context.getFlowScope().getString(this.flowAttributeInitialAnchor);
            if (anchor != null) {
                JasperPrint jasperPrint = printAccessor.getFinalJasperPrint();
                Map anchorIndexes = jasperPrint.getAnchorIndexes();
                JRPrintAnchorIndex anchorIndex = (JRPrintAnchorIndex)anchorIndexes.get(anchor);
                if (anchorIndex != null) {
                    pageIndex = anchorIndex.getPageIndex();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resolved anchor " + anchor + " to page " + pageIndex));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Anchor " + anchor + " not found in report"));
                }
            }
        } else {
            ReportPageStatus pageStatus = printAccessor.pageStatus(pageIndex - 1, null);
            if (pageStatus.pageExists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using initial page index " + pageIndex));
                }
                pageIndex = pageIndex - 1;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Page index " + pageIndex + " out of range for report with " + printAccessor.getReportStatus().getTotalPageCount() + " pages"));
                }
                pageIndex = null;
            }
        }
        return pageIndex;
    }

    protected ReportUnitResult executeReport(RequestContext context) {
        long currentTime = System.currentTimeMillis();
        Map<String, Object> parameterValues = null;
        context.getFlashScope().put(ATTRIBUTE_EMPTY_REPORT_MESSAGE, (Object)this.getMessages().getMessage("jasper.report.view.empty", null, LocaleContextHolder.getLocale()));
        try {
            parameterValues = this.getReportParameterValuesFromRequest(context);
        }
        catch (JSValidationException e) {
            String validationMessage = this.formatInputControlsValidationErrorMessage(e.getErrors());
            context.getFlashScope().put(ATTRIBUTE_EMPTY_REPORT_MESSAGE, (Object)validationMessage);
            return this.createEmptyReportUnitResult(this.getReportURI(context));
        }
        ReportContext reportContext = this.getReportContext(context);
        int initialStackSize = 0;
        CommandStack commandStack = (CommandStack)reportContext.getParameterValue("net.sf.jasperreports.command.stack");
        if (commandStack != null) {
            initialStackSize = commandStack.getExecutionStackSize();
        }
        this.addReportExecutionParameters(context, parameterValues);
        String reportUnitUri = this.getReportURI(context);
        ReportUnitRequest request = new ReportUnitRequest(reportUnitUri, parameterValues);
        request.setCreateAuditEvent(true);
        request.setStartTime(currentTime);
        boolean async = this.isAsyncReport(context);
        request.setAsynchronous(async);
        String freshDataParam = context.getRequestParameters().get("freshData");
        request.setUseDataSnapshot(!Boolean.parseBoolean(freshDataParam));
        request.setRecordDataSnapshot(this.isDefaultRecordDataSnapshot());
        ReportUnitResult result = null;
        try {
            result = this.executeReport(context, request);
        }
        catch (RuntimeException t) {
            this.undoAction(reportContext, initialStackSize);
            JSShowOnlyErrorMessage uiException = this.uiExceptionRouter.getUIException(t);
            if (uiException != null) {
                throw uiException;
            }
            throw t;
        }
        this.setReportRequestId(context, request.getId());
        return result;
    }

    private String formatInputControlsValidationErrorMessage(ValidationErrors validationErrors) {
        List errors = validationErrors.getErrors();
        StringBuilder builder = new StringBuilder();
        for (InputControlValidationError error : errors) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(RepositoryUtils.getName((String)error.getInputControlUri()));
        }
        return this.getMessages().getMessage("jasper.report.view.controls.validation.failed", new Object[]{builder.toString()}, LocaleContextHolder.getLocale());
    }

    private ReportUnitResult createEmptyReportUnitResult(String uri) {
        JasperPrint jasperPrint = new JasperPrint();
        return new ReportUnitResult(uri, jasperPrint, null);
    }

    @Override
    protected void saveInputControlsState(RequestContext context, Map<String, String[]> requestValues) {
        context.getFlowScope().put(this.getAttributeSavedInputsState(), requestValues);
    }

    protected Map<String, String[]> getInputControlsState(RequestContext context) {
        return (Map)context.getFlowScope().get(this.getAttributeSavedInputsState(), Map.class, (Object)Collections.EMPTY_MAP);
    }

    private void undoAction(ReportContext webReportContext, int initialStackSize) {
        CommandStack commandStack = (CommandStack)webReportContext.getParameterValue("net.sf.jasperreports.command.stack");
        if (commandStack != null) {
            for (int i = 0; i < commandStack.getExecutionStackSize() - initialStackSize; ++i) {
                commandStack.undo();
            }
        }
    }

    protected boolean isAsyncReport(RequestContext context) {
        if (ViewReportAction.isDashboard(context)) {
            return false;
        }
        Boolean asyncAttribute = context.getFlowScope().getBoolean(this.getAttributeAsyncReport());
        return asyncAttribute == null ? this.defaultAsyncReport : asyncAttribute;
    }

    private Action getAction(ReportContext webReportContext, JasperReportsContext jrContext) {
        String jsonData = (String)webReportContext.getParameterValue("jr.action");
        Action result = null;
        List actions = JacksonUtil.getInstance((JasperReportsContext)jrContext).loadAsList(jsonData, AbstractAction.class);
        if (actions != null) {
            if (actions.size() == 1) {
                result = (Action)actions.get(0);
            } else if (actions.size() > 1) {
                result = new MultiAction(actions);
            }
            ((AbstractAction)result).init(jrContext, webReportContext);
        }
        return result;
    }

    protected void startReportExecution(RequestContext context, ReportUnitRequest request) {
        FlowExecutionKey key = context.getFlowExecutionContext().getKey();
        if (key != null) {
            SharedAttributeMap sessionScope = context.getExternalContext().getSessionMap();
            String sessionName = "flowReportExecution" + key.toString();
            ReportExecutionAttributes reportExecution = new ReportExecutionAttributes(request.getId());
            sessionScope.put(sessionName, (Object)reportExecution);
        }
    }

    protected void endReportExecution(RequestContext context) {
        FlowExecutionKey key = context.getFlowExecutionContext().getKey();
        if (key != null) {
            SharedAttributeMap sessionScope = context.getExternalContext().getSessionMap();
            String sessionName = "flowReportExecution" + key.toString();
            sessionScope.remove(sessionName);
        }
    }

    protected ReportUnitResult executeReport(RequestContext context, ReportUnitRequest request) {
        this.startReportExecution(context, request);
        try {
            ReportContext reportContext = this.getReportContext(context);
            request.setReportContext(reportContext);
            ReportUnitResult reportUnitResult = (ReportUnitResult)this.getEngine().execute(ViewReportAction.getExecutionContext(context), (Request)request);
            return reportUnitResult;
        }
        catch (JRRuntimeException e) {
            int indexIO = ExceptionUtils.indexOfThrowable((Throwable)e, IOException.class);
            if (indexIO != -1) {
                throw new JSShowOnlyErrorMessage(((Exception)ExceptionUtils.getThrowableList((Throwable)e).get(indexIO)).getMessage());
            }
            throw e;
        }
        catch (JRFillInterruptedException e) {
            throw new ReportCanceledException(e);
        }
        finally {
            this.endReportExecution(context);
        }
    }

    protected void setJasperPrint(RequestContext context, ReportUnitResult result) {
        ServletExternalContext externalContext = (ServletExternalContext)context.getExternalContext();
        String name = this.getJasperPrintAccessor().putObject((HttpServletRequest)externalContext.getNativeRequest(), result);
        this.setJasperPrintId(context, name);
    }

    protected void removeCurrentJasperPrint(RequestContext context) {
        String jasperPrintName = this.getJasperPrintId(context);
        if (jasperPrintName != null) {
            ServletExternalContext externalContext = (ServletExternalContext)context.getExternalContext();
            ReportUnitResult result = (ReportUnitResult)this.getJasperPrintAccessor().getObject((HttpServletRequest)externalContext.getNativeRequest(), jasperPrintName);
            if (result != null) {
                this.cancelReportExecution(context, result);
                if (this.virtualizerFactory != null) {
                    this.virtualizerFactory.disposeReport((ReportResult)result);
                }
            }
            this.getJasperPrintAccessor().removeObject((HttpServletRequest)externalContext.getNativeRequest(), jasperPrintName);
        }
    }

    protected ReportUnitResult getCurrentReportResult(RequestContext context) {
        ReportUnitResult result = null;
        String jasperPrintName = this.getJasperPrintId(context);
        if (jasperPrintName != null) {
            ServletExternalContext externalContext = (ServletExternalContext)context.getExternalContext();
            result = (ReportUnitResult)this.getJasperPrintAccessor().getObject((HttpServletRequest)externalContext.getNativeRequest(), jasperPrintName);
        }
        return result;
    }

    protected void cancelReportExecution(RequestContext context, ReportUnitResult result) {
        JasperPrintAccessor printAccessor = result.getJasperPrintAccessor();
        if (printAccessor != null && printAccessor.getReportStatus().getStatus() == ReportExecutionStatus.Status.RUNNING) {
            String requestId = this.getReportRequestId(context);
            if (requestId == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No request Id found to cancel");
                }
            } else {
                boolean canceled;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Canceling request " + requestId));
                }
                if (canceled = this.getEngine().cancelExecution(requestId)) {
                    log.debug((Object)("Request " + requestId + " canceled: " + canceled));
                }
            }
        }
    }

    protected String getJasperPrintId(RequestContext context) {
        return context.getFlowScope().getString(this.getFlowAttributeJasperPrintName());
    }

    protected void setJasperPrintId(RequestContext context, String jasperPrintId) {
        context.getFlowScope().put(this.getFlowAttributeJasperPrintName(), (Object)jasperPrintId);
    }

    protected String getReportRequestId(RequestContext context) {
        return context.getFlowScope().getString(this.getFlowAttributeReportRequestId());
    }

    protected void setReportRequestId(RequestContext context, String requestId) {
        context.getFlowScope().put(this.getFlowAttributeReportRequestId(), (Object)requestId);
    }

    public Event navigate(RequestContext context) {
        Event flowEvent;
        Integer pageIndex = (Integer)context.getRequestParameters().getNumber(this.getRequestParameterPageIndex(), Integer.class);
        MutableAttributeMap flowScope = context.getFlowScope();
        if (pageIndex == null) {
            flowScope.remove(this.getFlowAttributePageIndex());
        } else {
            flowScope.put(this.getFlowAttributePageIndex(), (Object)pageIndex);
        }
        String ajaxParamValue = context.getRequestParameters().get("ajax");
        if (ajaxParamValue != null && ajaxParamValue.equals("true")) {
            flowEvent = this.result("ajaxPaginator");
        } else {
            flowScope.put(this.flowAttributeInitialPageIndex, (Object)pageIndex);
            flowEvent = this.result("directPaginator");
        }
        return flowEvent;
    }

    public Event initFlowScope(RequestContext context) {
        WebflowReportContext.initFlowScope(context);
        return this.success();
    }

    public Event prepareReportView(RequestContext context) {
        HashMap exporters;
        boolean isIPad;
        if (this.getHyperlinkProducerFactory() != null) {
            context.getRequestScope().put(this.getRequestAttributeHtmlLinkHandlerFactory(), (Object)this.getHyperlinkProducerFactory());
        }
        MutableAttributeMap requestScope = context.getRequestScope();
        Object isIPadAttr = context.getExternalContext().getRequestMap().get("isIPad");
        boolean bl = isIPad = isIPadAttr != null && Boolean.valueOf(isIPadAttr.toString()) != false;
        if (isIPad && this.getExportersSupportedByiPad() != null) {
            exporters = new HashMap();
            Iterator i$ = this.getConfiguredExporters().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                if (!this.getExportersSupportedByiPad().contains(entry.getKey())) continue;
                exporters.put(entry.getKey(), entry.getValue());
            }
        } else {
            exporters = this.getConfiguredExporters();
        }
        requestScope.put("configuredExporters", exporters);
        requestScope.put(ATTRIBUTE_ORGANIZATION_ID, (Object)this.securityContextProvider.getContextUser().getTenantId());
        requestScope.put(ATTRIBUTE_PUBLIC_FOLDER_URI, (Object)this.configuration.getPublicFolderUri());
        requestScope.put(ATTRIBUTE_TEMP_FOLDER_URI, (Object)this.configuration.getTempFolderUri());
        requestScope.put("reportParameterValues", (Object)new JSONObject(this.getInputControlsState(context)).toString());
        requestScope.put("allRequestParameters", (Object)this.getRequestParametersAsJSON(context));
        return this.success();
    }

    public Event cleanSession(RequestContext context) {
        this.removeCurrentJasperPrint(context);
        return this.success();
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public String getFlowAttributeInhibitRequestParsing() {
        return this.flowAttributeInhibitRequestParsing;
    }

    public void setFlowAttributeInhibitRequestParsing(String flowAttributeInhibitRequestParsing) {
        this.flowAttributeInhibitRequestParsing = flowAttributeInhibitRequestParsing;
    }

    public String getFlowAttributePageIndex() {
        return this.flowAttributePageIndex;
    }

    public void setFlowAttributePageIndex(String flowAttributePageIndex) {
        this.flowAttributePageIndex = flowAttributePageIndex;
    }

    public String getRequestParameterPageIndex() {
        return this.requestParameterPageIndex;
    }

    public void setRequestParameterPageIndex(String requestParameterPageIndex) {
        this.requestParameterPageIndex = requestParameterPageIndex;
    }

    public String getRequestAttributeHtmlLinkHandlerFactory() {
        return this.requestAttributeHtmlLinkHandlerFactory;
    }

    public void setRequestAttributeHtmlLinkHandlerFactory(String requestAttributeHtmlLinkHandlerFactory) {
        this.requestAttributeHtmlLinkHandlerFactory = requestAttributeHtmlLinkHandlerFactory;
    }

    public String getFlowAttributeDepth() {
        return this.flowAttributeDepth;
    }

    public void setFlowAttributeDepth(String flowAttributeDepth) {
        this.flowAttributeDepth = flowAttributeDepth;
    }

    public String getFlowAttributeJasperPrintName() {
        return this.flowAttributeJasperPrintName;
    }

    public void setFlowAttributeJasperPrintName(String flowAttributeJasperPrintName) {
        this.flowAttributeJasperPrintName = flowAttributeJasperPrintName;
    }

    public HyperlinkProducerFactoryFlowFactory getHyperlinkProducerFactory() {
        return this.hyperlinkProducerFactory;
    }

    public void setHyperlinkProducerFactory(HyperlinkProducerFactoryFlowFactory hyperlinkProducerFactory) {
        this.hyperlinkProducerFactory = hyperlinkProducerFactory;
    }

    public String getFlowAttributeIsSubflow() {
        return this.flowAttributeIsSubflow;
    }

    public void setFlowAttributeIsSubflow(String requestAttributeIsSubflow) {
        this.flowAttributeIsSubflow = requestAttributeIsSubflow;
    }

    public String getFlowAttributeReportOutput() {
        return this.flowAttributeReportOutput;
    }

    public void setFlowAttributeReportOutput(String flowAttributeReportOutput) {
        this.flowAttributeReportOutput = flowAttributeReportOutput;
    }

    public String getRequestParameterReportOutput() {
        return this.requestParameterReportOutput;
    }

    public void setRequestParameterReportOutput(String requestParameterReportOutput) {
        this.requestParameterReportOutput = requestParameterReportOutput;
    }

    public String getFlowAttributeUseClientTimezone() {
        return this.flowAttributeUseClientTimezone;
    }

    public void setFlowAttributeUseClientTimezone(String flowAttributeUseClientTimezone) {
        this.flowAttributeUseClientTimezone = flowAttributeUseClientTimezone;
    }

    public SessionObjectSerieAccessor getJasperPrintAccessor() {
        return this.jasperPrintAccessor;
    }

    public void setJasperPrintAccessor(SessionObjectSerieAccessor jasperPrintAccessor) {
        this.jasperPrintAccessor = jasperPrintAccessor;
    }

    public VirtualizerFactory getVirtualizerFactory() {
        return this.virtualizerFactory;
    }

    public void setVirtualizerFactory(VirtualizerFactory virtualizerFactory) {
        this.virtualizerFactory = virtualizerFactory;
    }

    public Map getConfiguredExporters() {
        return this.configuredExporters;
    }

    public void setConfiguredExporters(Map configuredExporters) {
        this.configuredExporters = configuredExporters;
    }

    public List getExportersSupportedByiPad() {
        return this.exportersSupportedByiPad;
    }

    public void setExportersSupportedByiPad(List exportersSupportedByiPad) {
        this.exportersSupportedByiPad = exportersSupportedByiPad;
    }

    public String getAttributeReportControlsLayout() {
        return this.attributeReportControlsLayout;
    }

    public void setAttributeReportControlsLayout(String attributeReportControlsLayout) {
        this.attributeReportControlsLayout = attributeReportControlsLayout;
    }

    public String getAttributeReportForceControls() {
        return this.attributeReportForceControls;
    }

    public void setAttributeReportForceControls(String attributeReportForceControls) {
        this.attributeReportForceControls = attributeReportForceControls;
    }

    public String getAttributeSavedInputsState() {
        return this.attributeSavedInputsState;
    }

    public void setAttributeSavedInputsState(String attributeLastInputsState) {
        this.attributeSavedInputsState = attributeLastInputsState;
    }

    public String getAttributeControlsHidden() {
        return this.attributeControlsHidden;
    }

    public void setAttributeControlsHidden(String attributeControlsHidden) {
        this.attributeControlsHidden = attributeControlsHidden;
    }

    public String getAttributeReportLocale() {
        return this.attributeReportLocale;
    }

    public void setAttributeReportLocale(String attributeReportLocale) {
        this.attributeReportLocale = attributeReportLocale;
    }

    public String getAttributeIgnorePagination() {
        return this.attributeIgnorePagination;
    }

    public void setAttributeIgnorePagination(String attributeIgnorePagination) {
        this.attributeIgnorePagination = attributeIgnorePagination;
    }

    public String getAttributeDashboardParametersHasError() {
        return this.attributeDashboardParametersHasError;
    }

    public void setAttributeDashboardParametersHasError(String attributeDashboardParametersHasError) {
        this.attributeDashboardParametersHasError = attributeDashboardParametersHasError;
    }

    public String getParameterReportLocale() {
        return this.parameterReportLocale;
    }

    public void setParameterReportLocale(String parameterReportLocale) {
        this.parameterReportLocale = parameterReportLocale;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public String getRequestParameterAnchor() {
        return this.requestParameterAnchor;
    }

    public void setRequestParameterAnchor(String requestParameterAnchor) {
        this.requestParameterAnchor = requestParameterAnchor;
    }

    public String getFlowAttributeInitialPageIndex() {
        return this.flowAttributeInitialPageIndex;
    }

    public void setFlowAttributeInitialPageIndex(String flowAttributeInitialPageIndex) {
        this.flowAttributeInitialPageIndex = flowAttributeInitialPageIndex;
    }

    public String getFlowAttributeInitialAnchor() {
        return this.flowAttributeInitialAnchor;
    }

    public void setFlowAttributeInitialAnchor(String flowAttributeInitialAnchor) {
        this.flowAttributeInitialAnchor = flowAttributeInitialAnchor;
    }

    public String getFlowAttributeReportRequestId() {
        return this.flowAttributeReportRequestId;
    }

    public void setFlowAttributeReportRequestId(String flowAttributeReportRequestId) {
        this.flowAttributeReportRequestId = flowAttributeReportRequestId;
    }

    public ReportContext getReportContext(RequestContext context) {
        return WebflowReportContext.getInstance(context);
    }

    public String getParameterAsyncReport() {
        return this.parameterAsyncReport;
    }

    public void setParameterAsyncReport(String parameterAsyncReport) {
        this.parameterAsyncReport = parameterAsyncReport;
    }

    public String getAttributeAsyncReport() {
        return this.attributeAsyncReport;
    }

    public void setAttributeAsyncReport(String attributeAsyncReport) {
        this.attributeAsyncReport = attributeAsyncReport;
    }

    public boolean isDefaultAsyncReport() {
        return this.defaultAsyncReport;
    }

    public void setDefaultAsyncReport(boolean defaultAsyncReport) {
        this.defaultAsyncReport = defaultAsyncReport;
    }

    public boolean isDefaultRecordDataSnapshot() {
        return this.defaultRecordDataSnapshot;
    }

    public void setDefaultRecordDataSnapshot(boolean defaultRecordDataSnapshot) {
        this.defaultRecordDataSnapshot = defaultRecordDataSnapshot;
    }

    public Boolean getShowDialogForMandatoryInputControlsWithoutDefaultValue() {
        return this.showDialogForMandatoryInputControlsWithoutDefaultValue;
    }

    public void setShowDialogForMandatoryInputControlsWithoutDefaultValue(Boolean showDialogForMandatoryInputControlsWithoutDefaultValue) {
        this.showDialogForMandatoryInputControlsWithoutDefaultValue = showDialogForMandatoryInputControlsWithoutDefaultValue;
    }
}

