/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlsInformation;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportLoadingService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.InputControlLabelResolver;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.MessageSourceLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.security.JasperServerAclEntry;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.war.action.ReportInputControlsAction;
import com.jaspersoft.jasperserver.war.action.ReportParametersUtils;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationError;
import com.jaspersoft.jasperserver.war.cascade.InputControlsLogicService;
import com.jaspersoft.jasperserver.war.cascade.InputControlsValidationException;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.InputControlState;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import com.jaspersoft.jasperserver.war.util.ServletContextWrapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.Authentication;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class ReportParametersAction
extends FormAction
implements ReportInputControlsAction {
    private static final Log log = LogFactory.getLog(ReportParametersAction.class);
    protected static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    public static final String VIEW_AS_DASHBOARD_FRAME = "viewAsDashboardFrame";
    public static final String IS_DASHBOARD = "isDashboard";
    public static final String IS_IC_REORDERING_ENABLED = "isIcReorderingEnabled";
    public static final String REPORT_PARAMETER_VALUES = "reportParameterValues";
    public static final String ALL_REQUEST_PARAMETERS = "allRequestParameters";
    public static final String ESCAPED_REPORT_DESCRIPTION_KEY = "escapedReportDescription";
    private static final String COLUMN_VALUE_SEPARATOR = " | ";
    private static final int COLUMN_VALUE_SEPARATOR_LENGTH = " | ".length();
    private String reportUnitAttrName;
    private String reportUnitObjectAttrName;
    private String messageSourceObjectAttrName;
    private String controlsDisplayFormAttrName;
    private String controlsDisplayViewAttrName;
    private String reportDisplayFormAttrName;
    private String calendarDatePatternAttrName;
    private String calendarDatetimePatternAttrName;
    private EngineService engine;
    private RepositoryService repository;
    private MessageSource messages;
    private String hasInputControlsAttrName;
    private String reportReadOnlyAttrName;
    private String reportFolderReadOnlyAttrName;
    private String staticDatePattern;
    private CalendarFormatProvider calendarFormatProvider;
    private String inputNamePrefix;
    private String attributeInputControlsInformation;
    private String inputControlsAttrName;
    @Resource
    protected ReportLoadingService reportLoadingService;
    @Resource
    protected InputControlsLogicService inputControlsLogicService;
    private String attributeReportOptionsURI;
    @Resource
    protected ServletContextWrapper servletContextWrapper;
    @Resource
    protected ObjectPermissionService objectPermissionService;
    protected ObjectMapper jsonMapper = new ObjectMapper();

    public Event checkForParams(RequestContext context) {
        ReportUnit reportUnit = this.getReportUnit(context);
        if (reportUnit == null) {
            throw new JSException("jsexception.view.report.could.not.load");
        }
        this.setReportUnitAttributes(context, reportUnit);
        MutableAttributeMap flowScope = context.getFlowScope();
        flowScope.put(this.getCalendarDatePatternAttrName(), (Object)this.getCalendarDatePattern());
        flowScope.put(this.getCalendarDatetimePatternAttrName(), (Object)this.getCalendarDatetimePattern());
        ExecutionContext exContext = ReportParametersAction.getExecutionContext(context);
        MessageSource messageSource = MessageSourceLoader.loadMessageSource((ExecutionContext)exContext, (ResourceContainer)reportUnit, (RepositoryService)this.repository);
        if (messageSource != null) {
            context.getExternalContext().getSessionMap().put(this.getMessageSourceObjectAttrName(), (Object)messageSource);
        } else {
            context.getExternalContext().getSessionMap().remove(this.getMessageSourceObjectAttrName());
        }
        flowScope.put(this.getHasInputControlsAttrName(), (Object)this.hasVisibleInputControls(context));
        flowScope.put(this.getReportReadOnlyAttrName(), (Object)this.isReportReadOnly(context));
        flowScope.put(this.getReportFolderReadOnlyAttrName(), (Object)this.isReportFolderReadOnly(context));
        return this.success();
    }

    protected String getRequestParametersAsJSON(RequestContext context) {
        Map nativeRequestMap = ((ServletRequest)context.getExternalContext().getNativeRequest()).getParameterMap();
        return this.convertObjectToJSONString(nativeRequestMap);
    }

    protected String convertObjectToJSONString(Object o) {
        try {
            return this.jsonMapper.writeValueAsString(o);
        }
        catch (IOException e) {
            throw new JSException((Throwable)e);
        }
    }

    protected List<InputControl> getInputControls(RequestContext context) {
        List<InputControl> controls = (List<InputControl>)context.getFlowScope().get(this.getInputControlsAttrName());
        if (controls == null) {
            ReportUnit reportUnit = this.getReportUnit(context);
            ExecutionContext exContext = ReportParametersAction.getExecutionContext(context);
            exContext = ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)exContext);
            controls = this.getInputControls(exContext, (InputControlsContainer)reportUnit);
            context.getFlowScope().put(this.getInputControlsAttrName(), controls);
        }
        return controls;
    }

    protected List<InputControl> getInputControls(ExecutionContext exContext, InputControlsContainer container) {
        return this.reportLoadingService.getInputControls(exContext, container);
    }

    protected List<ResourceReference> getRuntimeInputControls(ExecutionContext exContext, ReportUnit reportUnit) {
        return this.reportLoadingService.getInputControlReferences(exContext, (InputControlsContainer)reportUnit);
    }

    protected ReportUnit getReportUnit(RequestContext context) {
        ReportUnit reportUnit = (ReportUnit)context.getFlowScope().get(this.getReportUnitObjectAttrName());
        if (reportUnit != null) {
            return reportUnit;
        }
        String reportUnitUri = this.getReportURI(context);
        if (reportUnitUri == null || reportUnitUri.trim().length() == 0) {
            reportUnit = null;
        } else {
            reportUnit = (ReportUnit)this.repository.getResource(ReportParametersAction.getExecutionContext(context), reportUnitUri);
            if (reportUnit != null) {
                context.getFlowScope().put(this.getReportUnitObjectAttrName(), (Object)reportUnit);
                context.getFlowScope().put(ESCAPED_REPORT_DESCRIPTION_KEY, (Object)StringEscapeUtils.escapeJavaScript((String)reportUnit.getDescription()));
            }
        }
        return reportUnit;
    }

    @Override
    public String getReportURI(RequestContext context) {
        String reportUnitUri = (String)context.getFlowScope().get(this.getReportUnitAttrName());
        if (reportUnitUri == null && (reportUnitUri = context.getRequestParameters().get(this.getReportUnitAttrName())) != null) {
            context.getFlowScope().put(this.getReportUnitAttrName(), (Object)reportUnitUri);
        }
        return reportUnitUri;
    }

    protected boolean hasInputControls(RequestContext context) {
        return !this.getInputControls(context).isEmpty();
    }

    private boolean isReportReadOnly(RequestContext context) {
        return this.isResourceReadOnly(context, this.getReportUnit(context));
    }

    private boolean isReportFolderReadOnly(RequestContext context) {
        ReportUnit reportUnit = this.getReportUnit(context);
        return this.isResourceReadOnly(context, this.repository.getFolder(ReportParametersAction.getExecutionContext(context), reportUnit.getParentFolder()));
    }

    private boolean isResourceReadOnly(RequestContext context, Object resource) {
        ExecutionContext exContext = ReportParametersAction.getExecutionContext(context);
        HashSet<Integer> allUserPermissions = null;
        List<Object> currentUserRecipients = this.getCurrentUserRecipients();
        if (currentUserRecipients != null && currentUserRecipients.size() > 0) {
            allUserPermissions = new HashSet<Integer>();
            for (Object recipient : this.getCurrentUserRecipients()) {
                List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(exContext, resource, recipient);
                if (permissions != null && !permissions.isEmpty()) {
                    ObjectPermission permissionObject = (ObjectPermission)permissions.get(0);
                    allUserPermissions.add(permissionObject.getPermissionMask());
                    continue;
                }
                allUserPermissions.add(this.objectPermissionService.getInheritedObjectPermissionMask(exContext, resource, recipient));
            }
        }
        if (allUserPermissions != null && allUserPermissions.size() > 0) {
            JasperServerAclEntry jasperServerAclEntry = new JasperServerAclEntry();
            return jasperServerAclEntry.printPermissionsOverlappingBlock(allUserPermissions) == SimpleAclEntry.READ;
        }
        return false;
    }

    protected List<Object> getCurrentUserRecipients() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        ArrayList<Object> recipients = new ArrayList<Object>();
        if (authenticationToken.getPrincipal() instanceof User) {
            User user = (User)authenticationToken.getPrincipal();
            recipients.add(user);
            recipients.addAll(user.getRoles());
            return recipients;
        }
        return null;
    }

    protected boolean hasVisibleInputControls(RequestContext context) {
        List<InputControl> controls = this.getInputControls(context);
        for (InputControl control : controls) {
            if (!control.isVisible()) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getParametersWithoutDefaultValues(RequestContext context) {
        HashSet<String> parameters = new HashSet<String>();
        ReportInputControlsInformation infos = this.getControlsInformation(context);
        for (String controlName : infos.getControlNames()) {
            ReportInputControlInformation info = infos.getInputControlInformation(controlName);
            if (info.getDefaultValue() != null) continue;
            parameters.add(controlName);
        }
        return parameters;
    }

    protected void setReportUnitAttributes(RequestContext context, ReportUnit reportUnit) {
        MutableAttributeMap flowScope = context.getFlowScope();
        String controlsView = reportUnit.getInputControlRenderingView();
        if (controlsView != null && controlsView.endsWith(".jsp")) {
            String controlsFlowView = controlsView.substring(0, controlsView.length() - ".jsp".length());
            flowScope.put(this.getControlsDisplayViewAttrName(), (Object)controlsFlowView);
        }
        flowScope.put(this.getControlsDisplayFormAttrName(), (Object)controlsView);
        String reportRenderingView = reportUnit.getReportRenderingView();
        if (StringUtils.isNotEmpty((String)reportRenderingView) && reportRenderingView.charAt(0) != '/') {
            reportRenderingView = this.servletContextWrapper.getJspPathPrefix() + reportRenderingView;
        }
        flowScope.put(this.getReportDisplayFormAttrName(), (Object)reportRenderingView);
        flowScope.put(IS_IC_REORDERING_ENABLED, (Object)(reportUnit.getInputControls() != null && reportUnit.getInputControls().size() > 0 ? 1 : 0));
    }

    protected static ExecutionContext getExecutionContext(RequestContext reqContext) {
        return ReportParametersAction.getExecutionContext(JasperServerUtil.getExecutionContext(reqContext), reqContext);
    }

    protected static ExecutionContext getExecutionContext(ExecutionContext exContext, RequestContext reqContext) {
        return EngineServiceImpl.getRuntimeExecutionContext((ExecutionContext)exContext);
    }

    protected static boolean isDashboard(RequestContext reqContext) {
        String dashFrameParam = reqContext.getRequestParameters().get(VIEW_AS_DASHBOARD_FRAME);
        Boolean dashFlowParam = (Boolean)reqContext.getFlowScope().get(IS_DASHBOARD);
        return Boolean.valueOf(dashFrameParam) != false || dashFlowParam != null && dashFlowParam != false;
    }

    @Override
    public Map<String, Object> getReportParameterValuesFromRequest(RequestContext context) {
        ReportInputControlsInformation infos = this.getControlsInformation(context);
        List<InputControl> controls = this.getInputControls(context);
        String reportOptionURI = this.getReportOptionURI(context);
        String inputControlsContainerURI = reportOptionURI == null ? this.getReportURI(context) : reportOptionURI;
        Map<String, String[]> requestParametersForControlLogic = this.getRequestParametersForControlLogic(context, controls);
        try {
            List<InputControlState> inputControlStates = this.inputControlsLogicService.getValuesForInputControls(inputControlsContainerURI, infos.getControlNames(), requestParametersForControlLogic);
            this.checkInputControlStateForValidationErrors(inputControlStates);
            Map<String, String[]> inputControlFormattedValues = ReportParametersUtils.getValueMapFromInputControlStates(inputControlStates);
            Map<String, Object> inputControlValues = this.inputControlsLogicService.getTypedParameters(inputControlsContainerURI, inputControlFormattedValues);
            this.addCustomParameters(context, inputControlValues);
            this.saveInputControlsState(context, inputControlFormattedValues);
            return inputControlValues;
        }
        catch (CascadeResourceNotFoundException e) {
            throw new JSException(String.format("Resource not found URI: %s Type: %s", e.getResourceUri(), e.getResourceType()));
        }
        catch (InputControlsValidationException e) {
            throw new JSValidationException(e.getErrors());
        }
    }

    public String getReportOptionURI(RequestContext context) {
        return (String)context.getFlowScope().get(this.getAttributeReportOptionsURI());
    }

    private void checkInputControlStateForValidationErrors(List<InputControlState> inputControlStates) throws InputControlsValidationException {
        ValidationErrorsImpl validationErrors = new ValidationErrorsImpl();
        for (InputControlState state : inputControlStates) {
            if (state.getError() == null) continue;
            validationErrors.add((ValidationError)new InputControlValidationError(state.getError(), null, state.getError(), state.getUri(), null));
        }
        if (!validationErrors.getErrors().isEmpty()) {
            throw new InputControlsValidationException((ValidationErrors)validationErrors);
        }
    }

    protected void saveInputControlsState(RequestContext context, Map<String, String[]> requestValues) {
    }

    protected Map<String, String[]> formatReportParameterValues(String reportUri, Map<String, Object> reportParameters) {
        if (reportParameters == null) {
            return new HashMap<String, String[]>();
        }
        try {
            return this.inputControlsLogicService.formatTypedParameters(reportUri, reportParameters);
        }
        catch (CascadeResourceNotFoundException e) {
            throw new JSException(String.format("Resource not found URI: %s Type: %s", e.getResourceUri(), e.getResourceType()));
        }
        catch (InputControlsValidationException e) {
            throw new JSValidationException(e.getErrors());
        }
    }

    protected Map<String, String[]> getRequestParametersForControlLogic(RequestContext context, List<InputControl> controls) {
        ParameterMap requestParameters = context.getRequestParameters();
        HashMap<String, String[]> requestParametersForControlLogic = new HashMap<String, String[]>();
        for (InputControl control : controls) {
            requestParametersForControlLogic.put(control.getName(), requestParameters.getArray(control.getName()));
        }
        return requestParametersForControlLogic;
    }

    protected void addCustomParameters(RequestContext context, Map<String, Object> parameterValues) {
    }

    protected InputValueProvider initialValueProvider(RequestContext context) {
        return this.defaultValuesProvider(context);
    }

    public String getAttributeReportOptionsURI() {
        return this.attributeReportOptionsURI;
    }

    public void setAttributeReportOptionsURI(String attributeReportOptionsURI) {
        this.attributeReportOptionsURI = attributeReportOptionsURI;
    }

    protected InputValueProvider defaultValuesProvider(RequestContext context) {
        ReportInputControlsInformation controlsInfo = this.getControlsInformation(context);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        for (String name : controlsInfo.getControlNames()) {
            ReportInputControlInformation info = controlsInfo.getInputControlInformation(name);
            if (info == null) continue;
            defaults.put(name, info.getDefaultValue());
        }
        return new MapValueProvider(defaults);
    }

    protected ReportInputControlsInformation getControlsInformation(RequestContext context) {
        ReportInputControlsInformation info = (ReportInputControlsInformation)context.getFlowScope().get(this.getAttributeInputControlsInformation());
        if (info == null) {
            ExecutionContext executionContext = ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)ReportParametersAction.getExecutionContext(context));
            info = this.getEngine().getReportInputControlsInformation(executionContext, this.getReportURI(context), Collections.emptyMap());
            if (info != null) {
                context.getFlowScope().put(this.getAttributeInputControlsInformation(), (Object)info);
            }
        }
        return info;
    }

    protected String resolveLabel(ExecutionContext exContext, String label, ResourceContainer reportUnit) {
        MessageSource reportMessageSource = MessageSourceLoader.loadMessageSource((ExecutionContext)exContext, (ResourceContainer)reportUnit, (RepositoryService)this.repository);
        return InputControlLabelResolver.resolve((String)label, (MessageSource)reportMessageSource, (MessageSource)this.messages);
    }

    protected void setupThreadRepositoryContext(ExecutionContext exContext) {
        if (RepositoryUtil.getThreadRepositoryContext() == null) {
            RepositoryContext rc = new RepositoryContext();
            rc.setRepository(this.repository);
            rc.setExecutionContext(exContext);
            RepositoryUtil.setThreadRepositoryContext((RepositoryContext)rc);
        }
    }

    protected DateFormat getDateFormat(boolean interactiveParameters) {
        DateFormat format = interactiveParameters ? this.getCalendarFormatProvider().getDateFormat() : new SimpleDateFormat(this.getStaticDatePattern());
        return format;
    }

    protected DateFormat getDatetimeFormat(boolean interactiveParameters) {
        DateFormat format = interactiveParameters ? this.getCalendarFormatProvider().getDatetimeFormat() : new SimpleDateFormat(this.getStaticDatePattern());
        return format;
    }

    protected String getCalendarDatePattern() {
        return this.getCalendarFormatProvider().getCalendarDatePattern();
    }

    protected String getCalendarDatetimePattern() {
        return this.getCalendarFormatProvider().getCalendarDatetimePattern();
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public String getReportUnitAttrName() {
        return this.reportUnitAttrName;
    }

    public void setReportUnitAttrName(String reportUnitAttrName) {
        this.reportUnitAttrName = reportUnitAttrName;
    }

    public String getHasInputControlsAttrName() {
        return this.hasInputControlsAttrName;
    }

    public void setHasInputControlsAttrName(String hasInputControlsAttrName) {
        this.hasInputControlsAttrName = hasInputControlsAttrName;
    }

    public String getReportReadOnlyAttrName() {
        return this.reportReadOnlyAttrName;
    }

    public void setReportReadOnlyAttrName(String reportReadOnlyAttrName) {
        this.reportReadOnlyAttrName = reportReadOnlyAttrName;
    }

    public String getReportFolderReadOnlyAttrName() {
        return this.reportFolderReadOnlyAttrName;
    }

    public void setReportFolderReadOnlyAttrName(String reportFolderReadOnlyAttrName) {
        this.reportFolderReadOnlyAttrName = reportFolderReadOnlyAttrName;
    }

    public String getStaticDatePattern() {
        return this.staticDatePattern;
    }

    public void setStaticDatePattern(String staticDatePattern) {
        this.staticDatePattern = staticDatePattern;
    }

    public String getReportUnitObjectAttrName() {
        return this.reportUnitObjectAttrName;
    }

    public void setReportUnitObjectAttrName(String reportUnitObjectAttrName) {
        this.reportUnitObjectAttrName = reportUnitObjectAttrName;
    }

    public String getControlsDisplayFormAttrName() {
        return this.controlsDisplayFormAttrName;
    }

    public String getMessageSourceObjectAttrName() {
        return this.messageSourceObjectAttrName;
    }

    public void setMessageSourceObjectAttrName(String messageSourceObjectAttrName) {
        this.messageSourceObjectAttrName = messageSourceObjectAttrName;
    }

    public void setControlsDisplayFormAttrName(String controlsDisplayFormAttrName) {
        this.controlsDisplayFormAttrName = controlsDisplayFormAttrName;
    }

    public String getReportDisplayFormAttrName() {
        return this.reportDisplayFormAttrName;
    }

    public void setReportDisplayFormAttrName(String reportDisplayFormAttrName) {
        this.reportDisplayFormAttrName = reportDisplayFormAttrName;
    }

    public String getCalendarDatePatternAttrName() {
        return this.calendarDatePatternAttrName;
    }

    public void setCalendarDatePatternAttrName(String calendarDatePatternAttrName) {
        this.calendarDatePatternAttrName = calendarDatePatternAttrName;
    }

    public CalendarFormatProvider getCalendarFormatProvider() {
        return this.calendarFormatProvider;
    }

    public void setCalendarFormatProvider(CalendarFormatProvider calendarFormatProvider) {
        this.calendarFormatProvider = calendarFormatProvider;
    }

    public String getCalendarDatetimePatternAttrName() {
        return this.calendarDatetimePatternAttrName;
    }

    public void setCalendarDatetimePatternAttrName(String calendarDatetimePatternAttrName) {
        this.calendarDatetimePatternAttrName = calendarDatetimePatternAttrName;
    }

    public String getInputControlsAttrName() {
        return this.inputControlsAttrName;
    }

    public void setInputControlsAttrName(String inputControlsAttrName) {
        this.inputControlsAttrName = inputControlsAttrName;
    }

    public String getInputNamePrefix() {
        return this.inputNamePrefix;
    }

    public void setInputNamePrefix(String inputNamePrefix) {
        this.inputNamePrefix = inputNamePrefix;
    }

    public String getControlsDisplayViewAttrName() {
        return this.controlsDisplayViewAttrName;
    }

    public void setControlsDisplayViewAttrName(String controlsDisplayViewAttrName) {
        this.controlsDisplayViewAttrName = controlsDisplayViewAttrName;
    }

    public String getAttributeInputControlsInformation() {
        return this.attributeInputControlsInformation;
    }

    public void setAttributeInputControlsInformation(String attributeInputControlsInformation) {
        this.attributeInputControlsInformation = attributeInputControlsInformation;
    }

    public void setReportLoadingService(ReportLoadingService reportLoadingService) {
        this.reportLoadingService = reportLoadingService;
    }

    public InputControlsLogicService getInputControlsLogicService() {
        return this.inputControlsLogicService;
    }

    public void setInputControlsLogicService(InputControlsLogicService inputControlsLogicService) {
        this.inputControlsLogicService = inputControlsLogicService;
    }

    public ObjectPermissionService getObjectPermissionService() {
        return this.objectPermissionService;
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    protected static class MapValueProvider
    extends InputValueProvider {
        private final Map values;

        public MapValueProvider(Map values) {
            this.values = values;
        }

        public MapValueProvider(Map values, InputValueProvider parent) {
            super(parent);
            this.values = values;
        }

        @Override
        protected boolean hasOwnValue(String inputName) {
            return this.values.containsKey(inputName);
        }

        @Override
        protected Object getOwnValue(String inputName) {
            return this.values.get(inputName);
        }
    }

    protected static abstract class InputValueProvider {
        private final InputValueProvider parent;

        protected InputValueProvider() {
            this(null);
        }

        protected InputValueProvider(InputValueProvider parent) {
            this.parent = parent;
        }

        public Object getValue(String inputName) {
            Object value = this.hasOwnValue(inputName) ? this.getOwnValue(inputName) : (this.parent != null ? this.parent.getValue(inputName) : null);
            return value;
        }

        protected abstract boolean hasOwnValue(String var1);

        protected abstract Object getOwnValue(String var1);
    }
}

