/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;
import com.jaspersoft.jasperserver.war.action.ExporterConfigurationBean;
import com.jaspersoft.jasperserver.war.action.ViewReportAction;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class ReportExporterAction
extends FormAction {
    private static final Log log = LogFactory.getLog(ReportExporterAction.class);
    public static final String REPORT_EXPORT = "export";
    public static final String REPORT_EXPORT_PARAMS = "exportParams";
    public static final String REPORT_EXPORT_OPTION = "exportOption";
    public static final String PARAMETER_DIALOG_NAME = "parameterDialogName";
    public static final String OUTPUT = "output";
    public static final String REPORT_OUTPUT = "reportOutput";
    public static final String EXPORTER_TYPE = "exporterType";
    public static final String EXPORT_TYPE_NOT_SUPPORTED_MESSAGE_KEY = "report.output.type.not.supported";
    private Map configuredExporters;
    private Object exportParameters;
    private ConfigurationBean configurationBean;
    private MessageSource messageSource;
    private ViewReportAction viewReportAction;

    private String getSupportedExportTypesAsString() {
        StringBuilder sb = new StringBuilder();
        for (Object type : this.configuredExporters.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(type);
        }
        return sb.toString();
    }

    public Event exportStart(RequestContext context) {
        String type = this.getExporterType(context);
        ExporterConfigurationBean exporterConfiguration = (ExporterConfigurationBean)this.getConfiguredExporters().get(type);
        if (exporterConfiguration != null && !exporterConfiguration.getCurrentExporter().isPaginated()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"requested unpaginated report");
            }
            context.getRequestScope().put(this.getViewReportAction().getAttributeIgnorePagination(), (Object)true);
        }
        return this.success();
    }

    public Event exportOptions(RequestContext context) throws Exception {
        MutableAttributeMap flowScope = context.getFlowScope();
        String type = this.getExporterType(context);
        if (!this.configuredExporters.containsKey(type)) {
            throw new JSException(this.messageSource.getMessage(EXPORT_TYPE_NOT_SUPPORTED_MESSAGE_KEY, (Object[])new String[]{this.getSupportedExportTypesAsString()}, LocaleContextHolder.getLocale()));
        }
        flowScope.put(EXPORTER_TYPE, (Object)type);
        ExporterConfigurationBean exporterConfiguration = (ExporterConfigurationBean)this.getConfiguredExporters().get(type);
        if (type != null && StringUtils.isNotEmpty((String)exporterConfiguration.getParameterDialogName())) {
            this.exportParameters = exporterConfiguration.getExportParameters();
            String parameterDialogName = exporterConfiguration.getParameterDialogName();
            this.setFormObjectClass(this.exportParameters.getClass());
            this.setFormObjectName(parameterDialogName);
            this.setFormObjectScope(ScopeType.FLOW);
            if (this.configurationBean.isReportLevelConfigurable()) {
                flowScope.put(PARAMETER_DIALOG_NAME, (Object)parameterDialogName);
                ExportParameters formObject = (ExportParameters)this.getFormObject(context);
                formObject.setOverrideReportHints(true);
                context.getRequestScope().put(parameterDialogName, (Object)formObject);
                flowScope.put(REPORT_EXPORT_OPTION, (Object)REPORT_EXPORT_PARAMS);
            } else {
                flowScope.put(parameterDialogName, this.getFormObject(context));
                flowScope.put(REPORT_EXPORT_OPTION, (Object)REPORT_EXPORT);
            }
        } else {
            flowScope.put(REPORT_EXPORT_OPTION, (Object)REPORT_EXPORT);
        }
        return this.success();
    }

    public void export(RequestContext context) throws Exception {
        ExporterConfigurationBean exporterConfiguration = (ExporterConfigurationBean)this.getConfiguredExporters().get(context.getFlowScope().get(EXPORTER_TYPE));
        exporterConfiguration.getCurrentExporter().export(context);
        context.getExternalContext().recordResponseComplete();
    }

    public Map getConfiguredExporters() {
        return this.configuredExporters;
    }

    public void setConfiguredExporters(Map configuredExporters) {
        this.configuredExporters = configuredExporters;
    }

    private String getExporterType(RequestContext context) {
        String type = context.getRequestParameters().get(OUTPUT) == null ? (String)context.getFlowScope().get(REPORT_OUTPUT) : context.getRequestParameters().get(OUTPUT);
        return this.getCanonicValue(type);
    }

    public Object getExportParameters() {
        return this.exportParameters;
    }

    public void setExportParameters(Object exportParameters) {
        this.exportParameters = exportParameters;
    }

    public Object createFormObject(RequestContext context) throws Exception {
        ExportParameters exportParams;
        ExporterConfigurationBean exporterConfiguration = (ExporterConfigurationBean)this.getConfiguredExporters().get(context.getFlowScope().get(EXPORTER_TYPE));
        if (null != exporterConfiguration && null != (exportParams = exporterConfiguration.getExportParameters())) {
            ExportParameters exp = (ExportParameters)exportParams.getClass().newInstance();
            exp.setPropertyValues((Object)exportParams);
            return exp;
        }
        return null;
    }

    private String getCanonicValue(String type) {
        if ("excel".equalsIgnoreCase(type)) {
            return "xls";
        }
        return type;
    }

    public ConfigurationBean getConfigurationBean() {
        return this.configurationBean;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public ViewReportAction getViewReportAction() {
        return this.viewReportAction;
    }

    public void setViewReportAction(ViewReportAction viewReportAction) {
        this.viewReportAction = viewReportAction;
    }
}

