/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseSettingsAction
extends MultiAction {
    protected static final Log log = LogFactory.getLog(BaseSettingsAction.class);
    private static final String AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_VALUE = "value";
    private PropertiesManagementService propertiesManagementService;
    private AuditContext auditContext;

    public void init(RequestContext context) {
    }

    public Event saveSingleProperty(RequestContext context) throws Exception {
        String res;
        log.info((Object)"Saving Server Property");
        String name = context.getRequestParameters().get(OPTION_NAME);
        String value = context.getRequestParameters().get(OPTION_VALUE);
        String error = this.validate(name, value);
        if (error == null) {
            this.createAuditEvent();
            this.saveSingleProperty(name, value);
            this.addParamToAuditEvent(name, value);
            this.closeAuditEvent();
            res = "{\"result\":\"JAM_056_UPDATED\",\"optionName\":\"" + name + "\"}";
        } else {
            res = "{\"error\":\"" + error + "\",\"optionName\":\"" + name + "\"}";
        }
        context.getRequestScope().put(AJAX_RESPONSE_MODEL, (Object)res);
        return this.success();
    }

    protected void saveSingleProperty(String key, String value) {
        this.getPropertiesManagementService().setProperty(key, value);
    }

    protected abstract String validate(String var1, String var2);

    protected abstract String getSettingsContextName();

    private void createAuditEvent() {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                BaseSettingsAction.this.auditContext.createAuditEvent(BaseSettingsAction.this.getSettingsContextName());
            }
        });
    }

    private void addParamToAuditEvent(final String name, final Object value) {
        this.auditContext.doInAuditContext(this.getSettingsContextName(), new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                BaseSettingsAction.this.auditContext.addPropertyToAuditEvent(name, value, auditEvent);
            }
        });
    }

    private void closeAuditEvent() {
        this.auditContext.doInAuditContext(this.getSettingsContextName(), new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                BaseSettingsAction.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public PropertiesManagementService getPropertiesManagementService() {
        return this.propertiesManagementService;
    }

    public void setPropertiesManagementService(PropertiesManagementService propertiesManagementService) {
        this.propertiesManagementService = propertiesManagementService;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }
}

