/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.LocaleUtils;
import org.springframework.web.servlet.LocaleResolver;

public class JSSessionLocaleResolver
implements LocaleResolver {
    public Locale resolveLocale(HttpServletRequest request) {
        String sessionAttribute = JasperServerConstImpl.getUserLocaleSessionAttr();
        Locale locale = (Locale)request.getSession().getAttribute(sessionAttribute);
        if (locale == null) {
            locale = this.getLocaleFromCookies(request);
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        return locale;
    }

    private Locale getLocaleFromCookies(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(JasperServerConstImpl.getUserLocaleSessionAttr())) continue;
                if (cookie.getValue() == null || cookie.getValue().length() <= 0) break;
                return LocaleUtils.toLocale((String)cookie.getValue());
            }
        }
        return null;
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        String sessionAttribute = JasperServerConstImpl.getUserLocaleSessionAttr();
        request.getSession().setAttribute(sessionAttribute, (Object)locale);
    }
}

