/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIntrospector {
    private final Class<?> fTestClass;

    public TestIntrospector(Class<?> testClass) {
        this.fTestClass = testClass;
    }

    public List<Method> getTestMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<Method> results = new ArrayList<Method>();
        for (Class eachClass : this.getSuperClasses(this.fTestClass)) {
            Method[] methods;
            Method[] methodArray = methods = eachClass.getDeclaredMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method eachMethod = methodArray[n];
                Annotation annotation = eachMethod.getAnnotation(annotationClass);
                if (annotation != null && !this.isShadowed(eachMethod, results)) {
                    results.add(eachMethod);
                }
                ++n;
            }
        }
        if (this.runsTopToBottom(annotationClass)) {
            Collections.reverse(results);
        }
        return results;
    }

    public boolean isIgnored(Method eachMethod) {
        return eachMethod.getAnnotation(Ignore.class) != null;
    }

    private boolean runsTopToBottom(Class<? extends Annotation> annotation) {
        return annotation.equals(Before.class) || annotation.equals(BeforeClass.class);
    }

    private boolean isShadowed(Method method, List<Method> results) {
        for (Method each : results) {
            if (!each.getName().equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    private List<Class> getSuperClasses(Class<?> testClass) {
        ArrayList<Class> results = new ArrayList<Class>();
        Class<?> current = testClass;
        while (current != null) {
            results.add(current);
            current = current.getSuperclass();
        }
        return results;
    }

    long getTimeout(Method method) {
        Test annotation = method.getAnnotation(Test.class);
        long timeout = annotation.timeout();
        return timeout;
    }

    Class<? extends Throwable> expectedException(Method method) {
        Test annotation = method.getAnnotation(Test.class);
        if (annotation.expected() == Test.None.class) {
            return null;
        }
        return annotation.expected();
    }
}

