/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.JSJobMethodInvocationFailedException;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.JSQuartzJobBean;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;

public class JSMethodInvokingJobDetailFactoryBean
extends ArgumentConvertingMethodInvoker
implements FactoryBean,
BeanNameAware,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    private Scheduler scheduler;
    private static Class jobDetailImplClass;
    private String name;
    private String group = "DEFAULT";
    private boolean concurrent = true;
    private String targetBeanName;
    private String[] jobListenerNames;
    private String beanName;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private BeanFactory beanFactory;
    private JobDetail jobDetail;

    public Scheduler getScheduler() throws JobExecutionException {
        if (this.scheduler == null) {
            throw new JobExecutionException("Fatal Error:  bean '" + ((Object)((Object)this)).getClass().getName() + "' does not have its QuartzScheduler bean set and it is required to be.");
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public void setJobListenerNames(String[] names) {
        this.jobListenerNames = names;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected Class resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName((String)className, (ClassLoader)this.beanClassLoader);
    }

    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchMethodException {
        Class jobClass;
        this.prepare();
        String name = this.name == null ? this.beanName : this.name;
        Class clazz = jobClass = this.concurrent ? MethodInvokingJob.class : StatefulMethodInvokingJob.class;
        if (jobDetailImplClass != null) {
            this.jobDetail = (JobDetail)BeanUtils.instantiate((Class)jobDetailImplClass);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.jobDetail);
            bw.setPropertyValue("name", (Object)name);
            bw.setPropertyValue("group", (Object)this.group);
            bw.setPropertyValue("jobClass", jobClass);
            bw.setPropertyValue("durability", (Object)true);
            ((JobDataMap)bw.getPropertyValue("jobDataMap")).put("methodInvoker", (Object)this);
        } else {
            this.jobDetail = new JobDetailImpl(name, this.group, jobClass);
            if (!(this.jobDetail instanceof JobDetailImpl)) {
                throw new RuntimeException("Expected JobDetail to be an instance of '" + JobDetailImpl.class + "' but instead we got '" + this.jobDetail.getClass().getName() + "'");
            }
            ((JobDetailImpl)this.jobDetail).setDurability(true);
            this.jobDetail.getJobDataMap().put("methodInvoker", (Object)this);
        }
        if (this.jobListenerNames != null) {
            String[] as = this.jobListenerNames;
            int j = this.jobListenerNames.length;
            for (int i = 0; i < j; ++i) {
                String jobListenerName = as[i];
                if (jobDetailImplClass != null) {
                    throw new IllegalStateException("Non-global JobListeners not supported on Quartz 2 - manually register a Matcher against the Quartz ListenerManager instead");
                }
                JobKey jk = this.jobDetail.getKey();
                KeyMatcher matcher = KeyMatcher.keyEquals((Key)jk);
                try {
                    this.getScheduler().getListenerManager().addJobListenerMatcher(jobListenerName, (Matcher)matcher);
                    continue;
                }
                catch (SchedulerException e) {
                    throw new RuntimeException("Error adding Quartz Trigger Listener: " + e.getMessage());
                }
            }
        }
        this.postProcessJobDetail(this.jobDetail);
    }

    protected void postProcessJobDetail(JobDetail jobdetail) {
    }

    public Class getTargetClass() {
        Class targetClass = super.getTargetClass();
        if (targetClass == null && this.targetBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set when using 'targetBeanName'");
            targetClass = this.beanFactory.getType(this.targetBeanName);
        }
        return targetClass;
    }

    public Object getTargetObject() {
        Object targetObject = super.getTargetObject();
        if (targetObject == null && this.targetBeanName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set when using 'targetBeanName'");
            targetObject = this.beanFactory.getBean(this.targetBeanName);
        }
        return targetObject;
    }

    public JobDetail getObject() {
        return this.jobDetail;
    }

    public Class getObjectType() {
        return this.jobDetail == null ? JobDetailImpl.class : this.jobDetail.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    static {
        try {
            jobDetailImplClass = Class.forName("org.quartz.impl.JobDetailImpl");
        }
        catch (ClassNotFoundException _ex) {
            jobDetailImplClass = null;
        }
    }

    public static class StatefulMethodInvokingJob
    extends MethodInvokingJob
    implements StatefulJob {
    }

    public static class MethodInvokingJob
    extends JSQuartzJobBean {
        protected static final Log logger = LogFactory.getLog(MethodInvokingJob.class);
        private MethodInvoker methodInvoker;

        public void setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
        }

        @Override
        protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
            try {
                context.setResult(this.methodInvoker.invoke());
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof JobExecutionException) {
                    throw (JobExecutionException)ex.getTargetException();
                }
                throw new JSJobMethodInvocationFailedException(this.methodInvoker, ex.getTargetException());
            }
            catch (Exception ex) {
                throw new JSJobMethodInvocationFailedException(this.methodInvoker, ex);
            }
        }
    }
}

