/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class InputControlLabelResolver {
    private static Pattern LABEL_KEY_PATTERN = Pattern.compile("^\\$R\\{(.+)\\}(.*)$");

    public static String resolve(String key, ResourceBundle reportMessageSource, MessageSource serverMessageSource) {
        return InputControlLabelResolver.resolve(key, new ResourceBundleLabelResolverAdapter(reportMessageSource), new MessageSourceLabelResolverAdapter(serverMessageSource));
    }

    public static String resolve(String key, MessageSource reportMessageSource, MessageSource serverMessageSource) {
        return InputControlLabelResolver.resolve(key, new MessageSourceLabelResolverAdapter(reportMessageSource), new MessageSourceLabelResolverAdapter(serverMessageSource));
    }

    private static String resolve(String key, LabelResolver reportLabelResolver, LabelResolver serverLabelResolver) {
        String label = key;
        Matcher m = LABEL_KEY_PATTERN.matcher(key);
        if (m.matches()) {
            String labelKey = m.group(1);
            String labelPostfix = m.group(2);
            boolean messageFound = false;
            try {
                label = reportLabelResolver.getLabel(labelKey);
                messageFound = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!messageFound) {
                try {
                    label = serverLabelResolver.getLabel(labelKey);
                    messageFound = true;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (messageFound) {
                label = label + labelPostfix;
            }
        }
        return label;
    }

    static class ResourceBundleLabelResolverAdapter
    implements LabelResolver {
        private ResourceBundle resourceBundle;

        ResourceBundleLabelResolverAdapter(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        @Override
        public String getLabel(String key) {
            if (this.resourceBundle != null) {
                return this.resourceBundle.getString(key);
            }
            throw new MissingResourceException(String.format("Can't find resource for bundle %s, key %s", this.getClass().getName(), key), this.getClass().getName(), key);
        }
    }

    static class MessageSourceLabelResolverAdapter
    implements LabelResolver {
        private MessageSource messageSource;

        MessageSourceLabelResolverAdapter(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        @Override
        public String getLabel(String key) {
            if (this.messageSource != null) {
                return this.messageSource.getMessage(key, null, LocaleContextHolder.getLocale());
            }
            throw new NoSuchMessageException(key);
        }
    }

    static interface LabelResolver {
        public String getLabel(String var1);
    }
}

