/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwsEc2MetadataClient {
    public static final String EC2_METADATA_SERVICE_OVERRIDE = "com.amazonaws.sdk.ec2MetadataServiceEndpointOverride";
    private static final String EC2_METADATA_SERVICE_URL = "http://169.254.169.254";
    public static final String INSTANCE_ID_RESOURCE = "/latest/meta-data/instance-id/";
    public static final String REGION_RESOURCE = "/latest/meta-data/placement/availability-zone/";
    public static final String MACS_RESOURCE = "/latest/meta-data/network/interfaces/macs/";
    public static final String PRIVATE_IP_RESOURCE = "/latest/meta-data/local-ipv4/";
    public static final String PUBLIC_IP_RESOURCE = "/latest/meta-data/public-ipv4/";
    public static final String PRODUCT_CODES_RESOURCE = "/latest/meta-data/product-codes";
    public static final String INSTANCE_TYPE_RESOURCE = "/latest/meta-data/instance-type";
    public static final String SECURITY_CREDENTIALS_RESOURCE = "/latest/meta-data/iam/security-credentials/";
    public static final String DOCUMENT_RESOURCE = "/latest/dynamic/instance-identity/document";
    public static final String ACCOUNT_ID = "accountId";
    public static int SECOND = 1000;
    public static final String VPC_ID = "vpc-id";
    private static final Log log = LogFactory.getLog(AwsEc2MetadataClient.class);
    private static Map<String, String> metadataValuesCache = new HashMap<String, String>();
    private List<String> awsRegions;

    public void setAwsRegions(List<String> awsRegions) {
        this.awsRegions = awsRegions;
    }

    public String getEc2InstanceMetadataItem(String resource) {
        if (!metadataValuesCache.containsKey(resource)) {
            String value = this.readResource(resource);
            metadataValuesCache.put(resource, value);
            return value;
        }
        return metadataValuesCache.get(resource);
    }

    public Boolean hasAwsProductCode(String jsProductCode) {
        if (!StringUtils.isNotEmpty((String)jsProductCode)) {
            return false;
        }
        List<String> ec2InstanceProductCodes = this.parseValueAsList(this.getEc2InstanceMetadataItem(PRODUCT_CODES_RESOURCE));
        if (ec2InstanceProductCodes != null && ec2InstanceProductCodes.size() > 0) {
            for (String productCode : ec2InstanceProductCodes) {
                if (!productCode.equals(jsProductCode)) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean hasAwsAccountId(String jsAmazonAccountId) {
        if (!StringUtils.isNotEmpty((String)jsAmazonAccountId)) {
            return false;
        }
        String accountId = this.parsePropertyValueFromJson(this.getEc2InstanceMetadataItem(DOCUMENT_RESOURCE), ACCOUNT_ID);
        return accountId != null && accountId.equals(jsAmazonAccountId);
    }

    public Boolean hasSecurityCredentials() {
        String securityCredentialsList = this.getEc2InstanceMetadataItem(SECURITY_CREDENTIALS_RESOURCE);
        return securityCredentialsList != null && securityCredentialsList.trim().length() > 0;
    }

    public Boolean isEc2InstanceInTargetVpc(String vpcId) {
        List<String> ec2MacAddresses;
        if (!StringUtils.isNotEmpty((String)vpcId) && !this.isEc2InstanceInVpc().booleanValue()) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)vpcId) && (ec2MacAddresses = this.parseValueAsList(this.getEc2InstanceMetadataItem(MACS_RESOURCE))) != null) {
            for (String ec2MacAddress : ec2MacAddresses) {
                String ec2VpcId = this.getEc2InstanceMetadataItem(MACS_RESOURCE + ec2MacAddress + VPC_ID);
                if (ec2VpcId == null || !ec2VpcId.trim().equals(vpcId.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean isEc2InstanceInVpc() {
        List<String> ec2MacAddresses = this.parseValueAsList(this.getEc2InstanceMetadataItem(MACS_RESOURCE));
        if (ec2MacAddresses != null && ec2MacAddresses.size() > 0) {
            for (String ec2MacAddress : ec2MacAddresses) {
                List<String> networkInformation = this.parseValueAsList(this.getEc2InstanceMetadataItem(MACS_RESOURCE + ec2MacAddress));
                if (networkInformation == null || networkInformation.size() <= 0 || !networkInformation.contains(VPC_ID)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEc2Instance() {
        return this.getEc2InstanceId() != null;
    }

    public String getEc2InstanceId() {
        return this.getEc2InstanceMetadataItem(INSTANCE_ID_RESOURCE);
    }

    public String getEc2InstanceRegion() {
        return this.parseRegionFromSubRegion(this.getEc2InstanceMetadataItem(REGION_RESOURCE));
    }

    private String parseRegionFromSubRegion(String region) {
        String regionPrefix = ".amazonaws.com";
        if (region != null) {
            for (String awsRegion : this.awsRegions) {
                String[] parse = awsRegion.split(regionPrefix);
                if (!region.contains(parse[0])) continue;
                return awsRegion;
            }
        }
        return null;
    }

    private List<String> parseValueAsList(String value) {
        if (value != null && value.trim().length() > 0) {
            String[] values = value.trim().split("\n");
            ArrayList<String> valueList = new ArrayList<String>();
            for (String val : values) {
                valueList.add(val.trim());
            }
            return valueList;
        }
        return null;
    }

    public String parsePropertyValueFromJson(String jsonText, String property) {
        if (StringUtils.isEmpty((String)jsonText) || StringUtils.isEmpty((String)property)) {
            return null;
        }
        Matcher matcher = Pattern.compile("(\"" + property + "\")\\s*:\\s*\"([^\"]+)").matcher(jsonText);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    private URL getEc2MetadataServiceUrlForResource(String resourcePath) throws Exception {
        String endpoint = EC2_METADATA_SERVICE_URL;
        if (System.getProperty(EC2_METADATA_SERVICE_OVERRIDE) != null) {
            endpoint = System.getProperty(EC2_METADATA_SERVICE_OVERRIDE);
        }
        return new URL(endpoint + resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(String resourcePath) {
        HttpURLConnection connection = null;
        URL url = null;
        try {
            url = this.getEc2MetadataServiceUrlForResource(resourcePath);
            log.debug((Object)("Connecting to EC2 instance metadata service at URL: " + url.toString()));
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(SECOND * 2);
            connection.setReadTimeout(SECOND * 7);
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.connect();
            if (connection.getResponseCode() >= 200 && connection.getResponseCode() < 400) {
                String string = this.readResponse(connection);
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(HttpURLConnection connection) throws IOException {
        InputStream inputStream = connection.getInputStream();
        try {
            int c;
            StringBuilder buffer = new StringBuilder();
            while ((c = inputStream.read()) != -1) {
                buffer.append((char)c);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }
}

