/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotCachingService;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistentMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotSavedId;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DefaultDataSnapshotPersistentMetadata;
import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.jasperreports.data.cache.DataSnapshot;

public class DataSnapshotEhcacheService
implements DataSnapshotCachingService {
    private Ehcache metadataCache;
    private Ehcache contentsCache;

    @Override
    public DataSnapshotPersistentMetadata getSnapshotMetadata(ExecutionContext context, long snapshotId) {
        Element element = this.metadataCache.get((Serializable)Long.valueOf(snapshotId));
        if (element == null) {
            return null;
        }
        DataSnapshotPersistentMetadata metadata = (DataSnapshotPersistentMetadata)element.getObjectValue();
        return metadata;
    }

    @Override
    public void putSnapshotMetadata(ExecutionContext context, long snapshotId, DataSnapshotPersistentMetadata metadata) {
        Element element = new Element((Object)snapshotId, (Object)metadata);
        this.metadataCache.put(element);
    }

    @Override
    public DataSnapshot getSnapshotContents(ExecutionContext context, long contentsId) {
        Element element = this.contentsCache.get((Serializable)Long.valueOf(contentsId));
        if (element == null) {
            return null;
        }
        DataSnapshot snapshot = (DataSnapshot)element.getObjectValue();
        return snapshot;
    }

    @Override
    public void putSnapshotContents(ExecutionContext context, long contentsId, DataSnapshot dataSnapshot) {
        Element element = new Element((Object)contentsId, (Object)dataSnapshot);
        this.contentsCache.put(element);
    }

    @Override
    public void put(ExecutionContext context, DataSnapshotSavedId savedId, DataCacheSnapshot snapshot) {
        DefaultDataSnapshotPersistentMetadata persistentMetadata = new DefaultDataSnapshotPersistentMetadata();
        persistentMetadata.setSnapshotMetadata(snapshot.getMetadata());
        persistentMetadata.setVersion(savedId.getVersion());
        persistentMetadata.setContentsId(savedId.getContentsId());
        this.putSnapshotMetadata(context, savedId.getSnapshotId(), (DataSnapshotPersistentMetadata)persistentMetadata);
        this.putSnapshotContents(context, savedId.getContentsId(), snapshot.getSnapshot());
    }

    @Override
    public void invalidateSnapshot(ExecutionContext context, long snapshotId) {
        Element element = this.metadataCache.get((Serializable)Long.valueOf(snapshotId));
        if (element == null) {
            return;
        }
        DataSnapshotPersistentMetadata metadata = (DataSnapshotPersistentMetadata)element.getObjectValue();
        this.metadataCache.remove((Serializable)Long.valueOf(snapshotId));
        this.contentsCache.remove((Serializable)Long.valueOf(metadata.getContentsId()));
    }

    public Ehcache getMetadataCache() {
        return this.metadataCache;
    }

    public void setMetadataCache(Ehcache metadataCache) {
        this.metadataCache = metadataCache;
    }

    public Ehcache getContentsCache() {
        return this.contentsCache;
    }

    public void setContentsCache(Ehcache contentsCache) {
        this.contentsCache = contentsCache;
    }
}

