/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid;

import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.teiid.MemoryConfig;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.teiid.ServerConfig;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.SimpleMock;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.service.BufferService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;

public class TeiidEmbeddedServer
extends EmbeddedServer {
    private MemoryConfig memoryConfig;
    private static final Log log = LogFactory.getLog(TeiidEmbeddedServer.class);
    private ConcurrentHashMap<String, EmbeddedServer.ConnectionFactoryProvider<?>> connectionFactoryProviders = new ConcurrentHashMap();

    public TeiidEmbeddedServer(EmbeddedConfiguration config, MemoryConfig memoryConfig, ServerConfig serverConfig) {
        if (serverConfig != null && serverConfig.getServerInit() != null) {
            serverConfig.getServerInit().init((EmbeddedServer)this);
        }
        if (config.getTransactionManager() == null) {
            boolean useMockTranscationManager = true;
            String transactionManagerLookup = null;
            if (serverConfig != null) {
                transactionManagerLookup = serverConfig.getTransactionManagerJNDILookup();
            }
            if (transactionManagerLookup != null && !transactionManagerLookup.trim().equals("")) {
                try {
                    InitialContext ic = new InitialContext();
                    Object utm = ic.lookup(transactionManagerLookup);
                    if (utm != null && utm instanceof TransactionManager) {
                        log.debug((Object)("Teiid Embedded Server: set transcation manager = " + transactionManagerLookup));
                        config.setTransactionManager((TransactionManager)utm);
                        useMockTranscationManager = false;
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)("Teiid Embedded Server: fail to set transcation manager = " + transactionManagerLookup), (Throwable)ex);
                }
            }
            if (useMockTranscationManager) {
                log.debug((Object)"Teiid Embedded Server: use simple transcation manager");
                config.setTransactionManager(SimpleMock.createSimpleMock(TransactionManager.class));
            }
            if (serverConfig != null && serverConfig.getXaTerminator() != null) {
                this.setXaTerminator(serverConfig.getXaTerminator());
            }
        }
        this.repo.odbcEnabled();
        this.memoryConfig = memoryConfig;
        this.start(config);
    }

    public void addConnectionFactoryProvider(String name, EmbeddedServer.ConnectionFactoryProvider<?> connectionFactoryProvider) {
        this.connectionFactoryProviders.put(name, connectionFactoryProvider);
    }

    public void setXaTerminator(XATerminator xaTerminator) {
        this.transactionService.setXaTerminator(xaTerminator);
    }

    public void setWorkManager(WorkManager workManager) {
        this.transactionService.setWorkManager(workManager);
    }

    public void setDetectTransactions(boolean detectTransactions) {
        this.detectTransactions = detectTransactions;
    }

    protected BufferService getBufferService() {
        if (this.memoryConfig != null) {
            if (this.memoryConfig.getDiskDirectory() != null) {
                this.bufferService.setDiskDirectory(this.memoryConfig.getDiskDirectory());
                log.debug((Object)("[Teiid Memory Setting] Disk Directory = " + this.memoryConfig.getDiskDirectory()));
            }
            this.bufferService.setUseDisk(this.memoryConfig.isUseDisk());
            log.debug((Object)("[Teiid Memory Setting] Use Disk = " + this.memoryConfig.isUseDisk()));
            this.bufferService.setProcessorBatchSize(this.memoryConfig.getProcessorBatchSize());
            log.debug((Object)("[Teiid Memory Setting] Processor Batch Size = " + this.memoryConfig.getProcessorBatchSize()));
            this.bufferService.setConnectorBatchSize(this.memoryConfig.getConnectorBatchSize());
            log.debug((Object)("[Teiid Memory Setting] Connector Batch Size = " + this.memoryConfig.getConnectorBatchSize()));
            this.bufferService.setMaxOpenFiles(this.memoryConfig.getMaxOpenFiles());
            log.debug((Object)("[Teiid Memory Setting] Max Open Files = " + this.memoryConfig.getMaxOpenFiles()));
            this.bufferService.setMaxFileSize(this.memoryConfig.getMaxFileSize());
            log.debug((Object)("[Teiid Memory Setting] Max File Size = " + this.memoryConfig.getMaxFileSize()));
            this.bufferService.setMaxProcessingKb(this.memoryConfig.getMaxProcessingKb());
            log.debug((Object)("[Teiid Memory Setting] Max Processing Kb = " + this.memoryConfig.getMaxProcessingKb()));
            this.bufferService.setMaxReserveKb(this.memoryConfig.getMaxReserveKb());
            log.debug((Object)("[Teiid Memory Setting] Max Reserve Kb = " + this.memoryConfig.getMaxReserveKb()));
            this.bufferService.setMaxBufferSpace(this.memoryConfig.getMaxBufferSpace());
            log.debug((Object)("[Teiid Memory Setting] Max Buffer Space = " + this.memoryConfig.getMaxBufferSpace()));
            this.bufferService.setInlineLobs(this.memoryConfig.isInlineLobs());
            log.debug((Object)("[Teiid Memory Setting] Inline Lobs = " + this.memoryConfig.isInlineLobs()));
            this.bufferService.setMemoryBufferSpace((int)this.memoryConfig.getMemoryBufferSpace());
            log.debug((Object)("[Teiid Memory Setting] Memory Buffer Space = " + this.memoryConfig.getMemoryBufferSpace()));
            this.bufferService.setMaxStorageObjectSize(this.memoryConfig.getMaxStorageObjectSize());
            log.debug((Object)("[Teiid Memory Setting] Max Storage Object Size = " + this.memoryConfig.getMaxStorageObjectSize()));
            this.bufferService.setMemoryBufferOffHeap(this.memoryConfig.isMemoryBufferOffHeap());
            log.debug((Object)("[Teiid Memory Setting] Memory Buffer Off Heap = " + this.memoryConfig.isMemoryBufferOffHeap()));
        }
        return super.getBufferService();
    }

    public ConnectorManagerRepository getConnectorManagerRepository() {
        return this.cmr;
    }

    public void setConnectorManagerRepository(ConnectorManagerRepository cmr) {
        this.cmr = cmr;
    }

    public ConnectionImpl createConnection(String embeddedURL) throws SQLException {
        return this.getDriver().connect(embeddedURL, null);
    }

    public boolean isVDBExisted(String vdbName) {
        return this.repo.getVDB(vdbName, 1) != null;
    }
}

