/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery;

import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.ConnectionFactory;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualSQLDataSourceMetaData;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualSQLDataSource
implements DataSource {
    ConnectionFactory connectionFactory;
    Connection connection = null;
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_CAT = "TABLE_CAT";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final Log log = LogFactory.getLog(VirtualSQLDataSource.class);

    public VirtualSQLDataSource(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        this.connection = this.connectionFactory.createConnection();
        return this.connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        this.connection = this.connectionFactory.createConnection();
        return this.connection;
    }

    public Set<String> getSchemas() throws SQLException {
        Set<String> schemas = null;
        if (this.connectionFactory instanceof VirtualSQLDataSourceMetaData) {
            schemas = ((VirtualSQLDataSourceMetaData)this.connectionFactory).getSchemas();
        }
        if (schemas == null) {
            return VirtualSQLDataSource.discoverSchemas(this.getConnection());
        }
        return schemas;
    }

    public Set<String> getCatalogs() throws SQLException {
        Set<String> catalogs = null;
        if (this.connectionFactory instanceof VirtualSQLDataSourceMetaData) {
            catalogs = ((VirtualSQLDataSourceMetaData)this.connectionFactory).getCatalogs();
        }
        if (catalogs == null) {
            return VirtualSQLDataSource.discoverCatalogs(this.getConnection());
        }
        return catalogs;
    }

    public Set<String> getSubDSTableList(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.connectionFactory instanceof VirtualSQLDataSourceMetaData) {
            return ((VirtualSQLDataSourceMetaData)this.connectionFactory).getSubDSTableList(catalog, schemaPattern, tableNamePattern, types);
        }
        throw new SQLException("This method only works JDBC/ JNDI sub data source for virtual data source");
    }

    public String getDatabaseProductName() throws SQLException {
        String databaseProductName = null;
        if (this.connectionFactory instanceof VirtualSQLDataSourceMetaData) {
            databaseProductName = ((VirtualSQLDataSourceMetaData)this.connectionFactory).getDatabaseProductName();
        }
        if (databaseProductName == null) {
            return this.getConnection().getMetaData().getDatabaseProductName();
        }
        return databaseProductName;
    }

    public String getIdentifierQuoteString() throws SQLException {
        String identifierQuoteString = null;
        if (this.connectionFactory instanceof VirtualSQLDataSourceMetaData) {
            identifierQuoteString = ((VirtualSQLDataSourceMetaData)this.connectionFactory).getIdentifierQuoteString();
        }
        if (identifierQuoteString == null) {
            return this.getConnection().getMetaData().getDatabaseProductName();
        }
        return identifierQuoteString;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        PrintWriter logWriter = null;
        logWriter = new PrintWriter(new LoggerOutputStream());
        return logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(new PrintWriter(new LoggerOutputStream()));
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequeryVirtualSQLDataSource");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public static Set<String> discoverSchemas(Connection conn) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        ResultSet rs = null;
        try {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            rs = dbMetaData.getSchemas();
            while (rs.next()) {
                String schema = rs.getString(TABLE_SCHEM);
                if (schema == null) continue;
                set.add(schema);
            }
            LinkedHashSet<String> linkedHashSet = set;
            return linkedHashSet;
        }
        catch (SQLException ex) {
            log.error((Object)"Cannot get schemas", (Throwable)ex);
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> discoverNonEmptySchemas(Connection conn) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        try {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            Set<String> schemaList = VirtualSQLDataSource.getResult(dbMetaData.getSchemas(), TABLE_SCHEM);
            String[] types = new String[]{"TABLE"};
            for (String schema : schemaList) {
                ResultSet rs2 = null;
                try {
                    rs2 = conn.getMetaData().getTables(null, schema, null, types);
                    if (rs2.next()) {
                        set.add(schema);
                        continue;
                    }
                    log.debug((Object)(schema + " schema contains no table.  Ignore in VDS"));
                }
                catch (SQLException ex2) {
                    log.debug((Object)("Fail to read schema, " + schema + ".  Ignore in VDS"));
                    ex2.printStackTrace();
                }
                finally {
                    if (rs2 == null) continue;
                    rs2.close();
                }
            }
            return set;
        }
        catch (SQLException ex) {
            log.error((Object)"Cannot get schemas", (Throwable)ex);
            throw ex;
        }
    }

    private static Set<String> getResult(ResultSet rs, String columnName) {
        HashSet<String> result = new HashSet<String>();
        try {
            while (rs.next()) {
                result.add(rs.getString(columnName));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Set discoverCatalogs(Connection conn) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        ResultSet rs = null;
        try {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            rs = dbMetaData.getCatalogs();
            while (rs.next()) {
                String catalog = rs.getString(TABLE_CAT);
                set.add(catalog);
            }
            LinkedHashSet<String> linkedHashSet = set;
            return linkedHashSet;
        }
        catch (SQLException ex) {
            log.error((Object)"Cannot get catalogs", (Throwable)ex);
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void testConnection() throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        System.out.println("MetaDataConstants.DATASOURCE_VENDOR = [" + dbMetaData.getDatabaseProductName() + "]");
        System.out.println("MetaDataConstants.NAME_QUOTE_CHAR = [" + dbMetaData.getIdentifierQuoteString() + "]");
        Set<String> set = VirtualSQLDataSource.discoverSchemas(this.connection);
        for (String val : set) {
            System.out.println("SCHEMA = " + val);
        }
    }

    class LoggerOutputStream
    extends OutputStream {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        LoggerOutputStream() {
        }

        @Override
        public void write(int b) {
            if (b != 10) {
                this.bOut.write(b);
            }
            log.debug((Object)this.bOut.toString());
        }
    }
}

