/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.ConnectionFactory;
import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.VirtualDataSourceQueryService;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.VirtualSQLDataSource;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.DataSourceImpl;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.JdbcDataSourceImpl;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.impl.JndiDataSourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceAcessDeniedException;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.security.AccessDeniedException;

public class VirtualDataSourceHandler {
    RepositoryService repositoryService;
    VirtualDataSourceQueryService virtualDataSourceQueryService;
    private static String dataSourceSchemaSeparator = "_";

    public static String getDataSourceSchemaSeparator() {
        return dataSourceSchemaSeparator;
    }

    public void setDataSourceSchemaSeparator(String dataSourceSchemaSeparator) {
        VirtualDataSourceHandler.dataSourceSchemaSeparator = dataSourceSchemaSeparator;
    }

    public VirtualDataSourceQueryService getVirtualDataSourceQueryService() {
        return this.virtualDataSourceQueryService;
    }

    public void setVirtualDataSourceQueryService(VirtualDataSourceQueryService virtualDataSourceQueryService) {
        this.virtualDataSourceQueryService = virtualDataSourceQueryService;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repositoryService = repository;
    }

    public DataSource getSqlDataSource(ExecutionContext context, VirtualReportDataSource jsDataSource) throws Exception {
        ArrayList<DataSourceImpl> subDataSourceList = new ArrayList<DataSourceImpl>();
        for (Map.Entry entry : jsDataSource.getDataSourceUriMap().entrySet()) {
            try {
                Object reportDataSource = this.getResource(context, (ResourceReference)entry.getValue());
                if (reportDataSource instanceof JdbcReportDataSource) {
                    JdbcDataSourceImpl jdbcDataSource = new JdbcDataSourceImpl((JdbcReportDataSource)reportDataSource, this.findSchemas(jsDataSource.getSchemas(), (String)entry.getKey()), (String)entry.getKey(), jsDataSource);
                    subDataSourceList.add(jdbcDataSource);
                }
                if (!(reportDataSource instanceof JndiJdbcReportDataSource)) continue;
                JndiDataSourceImpl jndiDataSource = new JndiDataSourceImpl((JndiJdbcReportDataSource)reportDataSource, this.findSchemas(jsDataSource.getSchemas(), (String)entry.getKey()), (String)entry.getKey(), jsDataSource);
                subDataSourceList.add(jndiDataSource);
            }
            catch (AccessDeniedException accessDeniedEx) {
                throw new JSResourceAcessDeniedException((ResourceReference)entry.getValue(), "Data Source Access Denied: " + ((ResourceReference)entry.getValue()).getReferenceURI());
            }
        }
        ConnectionFactory connectionFactory = this.virtualDataSourceQueryService.getConnectionFactory(subDataSourceList);
        VirtualSQLDataSource virtualSQLDataSource = new VirtualSQLDataSource(connectionFactory);
        return virtualSQLDataSource;
    }

    private Object getResource(ExecutionContext context, ResourceReference resourceReference) {
        if (resourceReference.isLocal()) {
            return resourceReference.getLocalResource();
        }
        return this.repositoryService.getResource(context, resourceReference.getReferenceURI());
    }

    private Set<String> findSchemas(Set<String> virtualSchemaList, String dataSourceName) {
        if (virtualSchemaList == null) {
            return null;
        }
        LinkedHashSet<String> schemaList = new LinkedHashSet<String>();
        String schemaPrefix = (dataSourceName + VirtualDataSourceHandler.getDataSourceSchemaSeparator()).toLowerCase();
        int beginIndex = schemaPrefix.length();
        for (String schemaName : virtualSchemaList) {
            if (!schemaName.toLowerCase().startsWith(schemaPrefix)) continue;
            schemaList.add(schemaName.substring(beginIndex));
        }
        return schemaList;
    }
}

