/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.engine.common.domain.ReportResult;
import com.jaspersoft.jasperserver.api.engine.common.service.VirtualizerFactory;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.StoreFactoryVirtualizer;
import net.sf.jasperreports.engine.fill.VirtualizerStoreFactory;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SharedVirtualizerStoreFactory
implements VirtualizerFactory,
InitializingBean {
    private static final Log log = LogFactory.getLog(SharedVirtualizerStoreFactory.class);
    public static final int DEFAULT_MAX_SIZE = 2000;
    private int maxSize = 2000;
    private VirtualizerStoreFactory storeFactory;
    private StoreFactoryVirtualizer virtualizer;

    public void afterPropertiesSet() {
        this.virtualizer = this.createVirtualizer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("created virtualizer " + this.virtualizer + " with max size " + this.maxSize + " and store factory " + this.storeFactory));
        }
    }

    protected StoreFactoryVirtualizer createVirtualizer() {
        return new StoreFactoryVirtualizer(this.maxSize, this.storeFactory);
    }

    public JRVirtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public void setReadOnly(ReportResult report) {
        JRVirtualizationContext virtualizationContext = this.contextForReport(report, true);
        if (virtualizationContext != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting virt context " + virtualizationContext + " as read only for " + report.getRequestId()));
            }
            virtualizationContext.setReadOnly(true);
        }
    }

    public void disposeReport(ReportResult report) {
        JRVirtualizationContext virtualizationContext = this.contextForReport(report, false);
        if (virtualizationContext != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("disposing virt context " + virtualizationContext + " for " + report.getRequestId()));
            }
            this.virtualizer.dispose(virtualizationContext);
        }
    }

    protected JRVirtualizationContext contextForReport(ReportResult report, boolean finalJasperPrint) {
        JRVirtualizationContext virtualizationContext = null;
        JasperPrintAccessor accessor = report.getJasperPrintAccessor();
        if (accessor != null) {
            JasperPrint jasperPrint;
            JasperPrint jasperPrint2 = jasperPrint = finalJasperPrint ? accessor.getFinalJasperPrint() : accessor.getJasperPrint();
            if (jasperPrint != null) {
                virtualizationContext = JRVirtualizationContext.getRegistered((JasperPrint)jasperPrint);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("found virt context " + virtualizationContext + " for report " + report.getRequestId()));
        }
        return virtualizationContext;
    }

    public VirtualizerStoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(VirtualizerStoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

