/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.repository.RepositoryResourceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputControlHandler
extends RepositoryResourceHandler {
    protected static final Log log = LogFactory.getLog(InputControlHandler.class);

    @Override
    public Class getResourceType() {
        return InputControl.class;
    }

    @Override
    protected void doDescribe(Resource resource, ResourceDescriptor descriptor, Map arguments, RepositoryServiceContext serviceContext) throws WSException {
        InputControl fileResource = (InputControl)resource;
        descriptor.setWsType("inputControl");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setMandatory(fileResource.isMandatory());
        descriptor.setReadOnly(fileResource.isReadOnly());
        descriptor.setVisible(fileResource.isVisible());
        descriptor.setControlType(fileResource.getType());
        ResourceReference childReference = null;
        if (descriptor.getControlType() == 2) {
            childReference = fileResource.getDataType();
        } else if (descriptor.getControlType() == 3 || descriptor.getControlType() == 8 || descriptor.getControlType() == 6 || descriptor.getControlType() == 10) {
            childReference = fileResource.getListOfValues();
        } else if (descriptor.getControlType() == 4 || descriptor.getControlType() == 9 || descriptor.getControlType() == 7 || descriptor.getControlType() == 11) {
            log.info((Object)("Adding query and columns: " + fileResource.getQueryValueColumn()));
            childReference = fileResource.getQuery();
            descriptor.setQueryValueColumn(fileResource.getQueryValueColumn());
            descriptor.setQueryVisibleColumns(fileResource.getQueryVisibleColumns());
        }
        if (childReference != null) {
            ResourceDescriptor childRd = null;
            if (childReference.isLocal()) {
                childRd = serviceContext.createResourceDescriptor(childReference.getLocalResource());
            } else {
                childRd = new ResourceDescriptor();
                childRd.setWsType("reference");
                childRd.setReferenceUri(childReference.getReferenceURI());
            }
            if (childRd != null) {
                descriptor.getChildren().add(childRd);
            }
        }
        if (arguments != null && arguments.containsKey("IC_GET_QUERY_DATA")) {
            String dsUri = (String)arguments.get("IC_GET_QUERY_DATA");
            List data = this.getInputControlItems(fileResource, dsUri, serviceContext, (Map)arguments.get("PARAMS_ARG"));
            descriptor.setQueryData(data);
        }
    }

    protected List getInputControlItems(InputControl control, String datasourceUri, RepositoryServiceContext serviceContext, Map params) throws JSException {
        ArrayList<InputControlQueryDataRow> rows;
        ResourceReference fallbackDataSource = null;
        if (datasourceUri != null && datasourceUri.trim().length() > 0) {
            fallbackDataSource = new ResourceReference(datasourceUri);
        }
        ResourceReference queryRef = control.getQuery();
        String valueColumn = control.getQueryValueColumn();
        String[] visibleColumns = control.getQueryVisibleColumns();
        Map parameters = params == null ? new HashMap() : params;
        parameters.put("REPORT_MAX_COUNT", new Integer(100000));
        OrderedMap results = serviceContext.getEngine().executeQuery(null, queryRef, valueColumn, visibleColumns, fallbackDataSource, parameters);
        if (results == null || results.isEmpty()) {
            rows = new ArrayList<InputControlQueryDataRow>(0);
        } else {
            rows = new ArrayList(results.size());
            for (Map.Entry entry : results.entrySet()) {
                Object keyValue = entry.getKey();
                String[] columnValues = (String[])entry.getValue();
                InputControlQueryDataRow ic = new InputControlQueryDataRow();
                ic.setValue(keyValue);
                for (int i = 0; i < columnValues.length; ++i) {
                    String value = columnValues[i];
                    ic.getColumnValues().add(value != null ? value : "");
                }
                rows.add(ic);
            }
        }
        return rows;
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        InputControl inputControl = (InputControl)resource;
        inputControl.setMandatory(descriptor.isMandatory());
        inputControl.setReadOnly(descriptor.isReadOnly());
        inputControl.setVisible(descriptor.isVisible());
        inputControl.setType(descriptor.getControlType());
        if (inputControl.getType() == 2) {
            if (descriptor.getChildren().size() == 0) {
                throw new WSException(2, serviceContext.getMessage("webservices.error.missingDataType", null));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            if (rd.getWsType().equals("reference")) {
                inputControl.setDataTypeReference(rd.getReferenceUri());
            } else {
                DataType dataType = (DataType)this.toChildResource(rd, serviceContext);
                inputControl.setDataType(dataType);
            }
        } else if (inputControl.getType() == 3 || inputControl.getType() == 8 || inputControl.getType() == 6 || inputControl.getType() == 10) {
            if (descriptor.getChildren().size() == 0) {
                throw new WSException(2, serviceContext.getMessage("webservices.error.missingLOV", null));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            if (rd.getWsType().equals("reference")) {
                inputControl.setListOfValuesReference(rd.getReferenceUri());
            } else {
                ListOfValues lovResource = (ListOfValues)this.toChildResource(rd, serviceContext);
                inputControl.setListOfValues(lovResource);
            }
        } else if (inputControl.getType() == 4 || inputControl.getType() == 9 || inputControl.getType() == 7 || inputControl.getType() == 11) {
            int i;
            if (descriptor.getChildren().size() == 0) {
                throw new WSException(2, serviceContext.getMessage("webservices.error.missingQuery", null));
            }
            ResourceDescriptor rd = (ResourceDescriptor)descriptor.getChildren().get(0);
            inputControl.setQueryValueColumn(descriptor.getQueryValueColumn());
            String[] visibleColumns = descriptor.getQueryVisibleColumns();
            String[] oldColumns = inputControl.getQueryVisibleColumns();
            if (oldColumns != null) {
                for (i = 0; i < oldColumns.length; ++i) {
                    inputControl.removeQueryVisibleColumn(oldColumns[i]);
                }
            }
            for (i = 0; i < visibleColumns.length; ++i) {
                inputControl.addQueryVisibleColumn(visibleColumns[i]);
            }
            if (rd.getWsType().equals("reference")) {
                inputControl.setQueryReference(rd.getReferenceUri());
            } else {
                Query queryResource = (Query)this.toChildResource(rd, serviceContext);
                inputControl.setQuery(queryResource);
            }
        }
    }
}

