/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverterService;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.repository.RepositoryResourceHandler;
import java.util.Map;

public class DataTypeHandler
extends RepositoryResourceHandler {
    private DataConverterService dataConverterService;

    public DataConverterService getDataConverterService() {
        return this.dataConverterService;
    }

    public void setDataConverterService(DataConverterService dataConverterService) {
        this.dataConverterService = dataConverterService;
    }

    @Override
    public Class getResourceType() {
        return DataType.class;
    }

    @Override
    protected void doDescribe(Resource resource, ResourceDescriptor descriptor, Map arguments, RepositoryServiceContext serviceContext) {
        DataType fileResource = (DataType)resource;
        descriptor.setWsType("dataType");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setDataType(fileResource.getType());
        descriptor.setPattern(fileResource.getRegularExpr());
        descriptor.setMaxValue(fileResource.getMaxValue() == null ? null : this.dataConverterService.formatSingleValue((Object)fileResource.getMaxValue(), fileResource, fileResource.getMaxValue().getClass()));
        descriptor.setMinValue(fileResource.getMinValue() == null ? null : this.dataConverterService.formatSingleValue((Object)fileResource.getMinValue(), fileResource, fileResource.getMinValue().getClass()));
        descriptor.setStrictMax(fileResource.isStrictMax());
        descriptor.setStrictMin(fileResource.isStrictMin());
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) {
        DataType dataType = (DataType)resource;
        dataType.setType(descriptor.getDataType());
        dataType.setRegularExpr(descriptor.getPattern());
        String rawMaxValue = descriptor.getMaxValue();
        String rawMinValue = descriptor.getMinValue();
        try {
            dataType.setMaxValue(rawMaxValue != null ? (Comparable)this.dataConverterService.convertSingleValue(rawMaxValue, dataType) : null);
            dataType.setMinValue(rawMinValue != null ? (Comparable)this.dataConverterService.convertSingleValue(rawMinValue, dataType) : null);
        }
        catch (InputControlValidationException e) {
            throw new RuntimeException(e.getValidationError() != null && e.getValidationError().getDefaultMessage() != null ? e.getValidationError().getDefaultMessage() : e.getMessage(), e);
        }
        dataType.setStrictMax(descriptor.isStrictMax());
        dataType.setStrictMin(descriptor.isStrictMin());
    }
}

