/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.authority;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.remote.common.AbstractRemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.common.CallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceWrapperWithCheckedException;
import com.jaspersoft.jasperserver.remote.common.RoleSearchCriteria;
import com.jaspersoft.jasperserver.remote.common.UserSearchCriteria;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.UserAndRoleService;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSRoleSearchCriteria;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.authority.WSUserSearchCriteria;
import com.jaspersoft.jasperserver.ws.axis2.authority.RoleBeanTraslator;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserAndRoleManagementService;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserBeanTraslator;
import com.jaspersoft.jasperserver.ws.axis2.util.RemoteServiceFromWsCallTemplate;
import java.util.List;
import org.apache.axis.AxisFault;

@CallTemplate(value=RemoteServiceFromWsCallTemplate.class)
public class UserAndRoleManagementServiceImpl
extends RemoteServiceWrapperWithCheckedException<UserAndRoleService, AxisFault>
implements UserAndRoleManagementService {
    @Override
    public WSUser[] findUsers(final WSUserSearchCriteria criteria) throws AxisFault {
        List users = (List)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<List<User>>(){

            public List<User> call(UserAndRoleService userAndRoleService) throws RemoteException {
                return userAndRoleService.findUsers(UserAndRoleManagementServiceImpl.this.toUserSearchCriteria(criteria));
            }
        });
        return UserBeanTraslator.toWSUserArray(users);
    }

    @Override
    public WSUser putUser(final WSUser wsUser) throws AxisFault {
        User aUser = (User)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<User>(){

            public User call(UserAndRoleService userAndRoleService) throws RemoteException {
                return userAndRoleService.putUser(UserBeanTraslator.toUser(wsUser));
            }
        });
        return UserBeanTraslator.toWSUser(aUser);
    }

    @Override
    public void deleteUser(final WSUser wsUser) throws AxisFault {
        this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Object>(){

            public Object call(UserAndRoleService userAndRoleService) throws RemoteException {
                userAndRoleService.deleteUser(UserBeanTraslator.toUser(wsUser));
                return null;
            }
        });
    }

    @Override
    public WSRole[] findRoles(final WSRoleSearchCriteria criteria) throws AxisFault {
        List roles = (List)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<List<Role>>(){

            public List<Role> call(UserAndRoleService userAndRoleService) throws RemoteException {
                return userAndRoleService.findRoles(UserAndRoleManagementServiceImpl.this.toRoleSearchCriteria(criteria));
            }
        });
        return RoleBeanTraslator.toWSRoleArray(roles);
    }

    @Override
    public WSRole putRole(final WSRole wsRole) throws AxisFault {
        Role role = (Role)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Role>(){

            public Role call(UserAndRoleService userAndRoleService) throws RemoteException {
                return userAndRoleService.putRole(RoleBeanTraslator.toRole(wsRole));
            }
        });
        return RoleBeanTraslator.toWSRole(role);
    }

    @Override
    public WSRole updateRoleName(final WSRole oldWSRole, final String newName) throws AxisFault {
        Role role = (Role)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Role>(){

            public Role call(UserAndRoleService userAndRoleService) throws RemoteException {
                return userAndRoleService.updateRoleName(RoleBeanTraslator.toRole(oldWSRole), newName);
            }
        });
        return RoleBeanTraslator.toWSRole(role);
    }

    @Override
    public void deleteRole(final WSRole wsRole) throws AxisFault {
        this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Object>(){

            public Object call(UserAndRoleService userAndRoleService) throws RemoteException {
                userAndRoleService.deleteRole(RoleBeanTraslator.toRole(wsRole));
                return null;
            }
        });
    }

    private RoleSearchCriteria toRoleSearchCriteria(WSRoleSearchCriteria wsRoleSearchCriteria) {
        if (wsRoleSearchCriteria == null) {
            return null;
        }
        RoleSearchCriteria roleSearchCriteria = new RoleSearchCriteria();
        roleSearchCriteria.setIncludeSubOrgs(wsRoleSearchCriteria.getIncludeSubOrgs());
        roleSearchCriteria.setMaxRecords(wsRoleSearchCriteria.getMaxRecords());
        roleSearchCriteria.setRoleName(wsRoleSearchCriteria.getRoleName());
        roleSearchCriteria.setTenantId(wsRoleSearchCriteria.getTenantId());
        return roleSearchCriteria;
    }

    private UserSearchCriteria toUserSearchCriteria(WSUserSearchCriteria wsUserSearchCriteria) {
        if (wsUserSearchCriteria == null) {
            return null;
        }
        UserSearchCriteria userSearchCriteria = new UserSearchCriteria();
        userSearchCriteria.setIncludeSubOrgs(wsUserSearchCriteria.getIncludeSubOrgs());
        userSearchCriteria.setMaxRecords(wsUserSearchCriteria.getMaxRecords());
        userSearchCriteria.setName(wsUserSearchCriteria.getName());
        userSearchCriteria.setRequiredRoles(RoleBeanTraslator.toRoleList(wsUserSearchCriteria.getRequiredRoles()));
        userSearchCriteria.setTenantId(wsUserSearchCriteria.getTenantId());
        return userSearchCriteria;
    }

    public void setUserAndRoleService(UserAndRoleService userAndRoleService) {
        this.remoteService = userAndRoleService;
    }
}

