/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.utils;

import com.jaspersoft.jasperserver.remote.services.LegacyRunReportService;
import com.jaspersoft.jasperserver.rest.MultipartFileDataSource;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSRoleSearchCriteria;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.authority.WSUserSearchCriteria;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.DataSource;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;

@Service(value="restUtils")
public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    public static final String REQUEST_PARAMENTER_RD = "ResourceDescriptor";
    public static final String REQUEST_PARAMENTER_MOVE_TO = "moveTo";
    public static final String REQUEST_PARAMENTER_COPY_TO = "copyTo";
    public static final String SWITCH_PARAM_GET_LOCAL_RESOURCE = "GET_LOCAL_RESOURCE";
    public static final String REQUEST_PARAMENTER_ROLES = "roles";
    public static final String REQUEST_PARAMENTER_USERS = "users";
    public static final String REQUEST_PARAMENTER_SEPARATOR = ",";
    public static final String REQUEST_PARAMENTER_ATTRIBUTES = "attributeKeys";
    public static final String REQUEST_PARAMENTER_LIST_SUB_ORGS = "listSubOrgs";
    public static final String SUPERUSER = "SUPERUSER";
    public static final String ADMINISTRATOR = "ADMINISTRATOR";
    public static final String FILE_DATA = "fileData";
    @Resource(name="specialRoles")
    private Map<String, String> specialRoles = new HashMap<String, String>();

    public boolean isMultipartContent(HttpServletRequest request) {
        if (!"put".equals(request.getMethod().toLowerCase()) && !"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public HttpServletRequest extractAttachments(LegacyRunReportService service, HttpServletRequest hRequest) {
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        if (this.isMultipartContent(hRequest) && hRequest.getContentLength() != -1) {
            MultipartHttpServletRequest mreq = resolver.resolveMultipart(hRequest);
            if (mreq != null && mreq.getFileMap().size() != 0) {
                Iterator iterator = mreq.getFileNames();
                String fieldName = null;
                while (iterator.hasNext()) {
                    fieldName = (String)iterator.next();
                    MultipartFile file = mreq.getFile(fieldName);
                    if (file == null) continue;
                    MultipartFileDataSource ds = new MultipartFileDataSource(file);
                    service.getInputAttachments().put(fieldName, ds);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(service.getInputAttachments().size() + " attachments were extracted from the PUT"));
                }
                return mreq;
            }
            if (hRequest instanceof DefaultMultipartHttpServletRequest) {
                DefaultMultipartHttpServletRequest dmServletRequest = (DefaultMultipartHttpServletRequest)hRequest;
                Iterator iterator = ((DefaultMultipartHttpServletRequest)hRequest).getFileNames();
                String fieldName = null;
                while (iterator.hasNext()) {
                    fieldName = (String)iterator.next();
                    MultipartFile file = dmServletRequest.getFile(fieldName);
                    if (file == null) continue;
                    MultipartFileDataSource ds = new MultipartFileDataSource(file);
                    service.getInputAttachments().put(fieldName, ds);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(service.getInputAttachments().size() + " attachments were extracted from the POST"));
        }
        return hRequest;
    }

    public UserDetails getCurrentlyLoggedUserDetails() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        return (UserDetails)authenticationToken.getPrincipal();
    }

    public String extractServiceName(String path) {
        int startIndex;
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((startIndex = path.indexOf("/")) > 0) {
            path = path.substring(0, startIndex);
        }
        return path;
    }

    public String extractRepositoryUri(String path) {
        int startIndex;
        if (path == null) {
            return "/";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((startIndex = path.indexOf("/")) > 0) {
            path = path.substring(startIndex);
        }
        while (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String getURIName(String uri) {
        return uri.replace("\\", "").replace("//", "");
    }

    public Map<String, Object> extractParameters(HttpServletRequest req) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration penum = req.getParameterNames();
        while (penum.hasMoreElements()) {
            String pname = (String)penum.nextElement();
            if (pname.startsWith("P_")) {
                parameters.put(pname.substring(2), req.getParameter(pname));
                continue;
            }
            if (!pname.startsWith("PL_")) continue;
            parameters.put(pname.substring(3), Arrays.asList(req.getParameterValues(pname)));
        }
        return parameters;
    }

    public void setStatusAndBody(int errorCode, HttpServletResponse response, String body) {
        response.setStatus(errorCode);
        try {
            PrintWriter pw = response.getWriter();
            pw.print(body == null ? "" : body);
        }
        catch (Exception ioEx) {
            log.error((Object)"Error sending output a file", (Throwable)ioEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(DataSource ds, HttpServletResponse response) {
        response.setContentType(ds.getContentType());
        if (ds.getName() != null && ds.getName().length() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + ds.getName());
        }
        ServletOutputStream outputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            outputStream = response.getOutputStream();
            bufferedInputStream = new BufferedInputStream(ds.getInputStream());
            int readBytes = 0;
            while ((readBytes = bufferedInputStream.read()) != -1) {
                outputStream.write(readBytes);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"finished sending bytes");
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error serving a file: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception ex) {}
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public String getDetinationUri(HttpServletRequest req) {
        if (req.getParameterMap().containsKey(REQUEST_PARAMENTER_MOVE_TO)) {
            return req.getParameter(REQUEST_PARAMENTER_MOVE_TO);
        }
        if (req.getParameterMap().containsKey(REQUEST_PARAMENTER_COPY_TO)) {
            return req.getParameter(REQUEST_PARAMENTER_COPY_TO);
        }
        return null;
    }

    public Marshaller getMarshaller(boolean isFragment, Class ... docClass) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])docClass);
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.fragment", (Object)isFragment);
        return m;
    }

    public <T> T unmarshal(Class<T> docClass, InputStream inputStream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{docClass});
        Unmarshaller u = jc.createUnmarshaller();
        return (T)u.unmarshal(inputStream);
    }

    public Marshaller getMarshaller(Class ... docClass) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])docClass);
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return m;
    }

    public Object unmarshal(InputStream inputStream, Class ... docClass) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])docClass);
        Unmarshaller u = jc.createUnmarshaller();
        return u.unmarshal(inputStream);
    }

    public String extractResourceName(String pathInfo) {
        String[] elements = pathInfo.split("/");
        for (int i = elements.length - 1; i >= 0; --i) {
            if (elements[i] == null || "".equals(elements[i])) continue;
            return elements[i];
        }
        return pathInfo;
    }

    public String extractResourceName(String serviceName, String path) {
        if (serviceName == null) {
            serviceName = "/" + serviceName + "/";
            return path.substring(path.indexOf(serviceName) + serviceName.length(), path.length());
        }
        return this.extractResourceName(path);
    }

    public <T> T populateServiceObject(String pathInfo, Map parametersMap, Class<T> usedClass) {
        String uri = this.extractResourceName(pathInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("populateServiceAgent: uri: " + uri + " with class: " + usedClass.getName().toString()));
        }
        if (usedClass.equals(WSRole.class)) {
            WSRole role = new WSRole();
            role.setRoleName(uri);
            return (T)role;
        }
        if (usedClass.equals(WSUser.class)) {
            WSUser user = new WSUser();
            user.setUsername(uri);
            return (T)user;
        }
        if (usedClass.equals(WSRoleSearchCriteria.class)) {
            WSRoleSearchCriteria criteria = new WSRoleSearchCriteria();
            criteria.setRoleName(uri);
            criteria.setIncludeSubOrgs(Boolean.valueOf(Boolean.parseBoolean((String)parametersMap.get(REQUEST_PARAMENTER_LIST_SUB_ORGS))));
            return (T)criteria;
        }
        return null;
    }

    public <T> T populateServiceObject(T usedClass) {
        return usedClass;
    }

    public boolean isLocalResource(String uri) {
        return this.getParentFolder(uri).endsWith("_files");
    }

    private String getParentFolder(String uri) {
        int parentFolderNameEnd = uri.lastIndexOf("/");
        if (parentFolderNameEnd == -1 || parentFolderNameEnd == 0) {
            return "";
        }
        uri = uri.substring(0, parentFolderNameEnd);
        int parentFolderNameStart = uri.lastIndexOf("/");
        return uri.substring(parentFolderNameStart);
    }

    public static List<String> stringToList(String roles, String delimiter) {
        LinkedList<String> lst = new LinkedList<String>();
        StringTokenizer sTok = new StringTokenizer(roles, delimiter);
        while (sTok.hasMoreTokens()) {
            lst.add(sTok.nextToken().trim());
        }
        return lst;
    }

    public WSUserSearchCriteria getWSUserSearchCriteria(String searchCriteria) {
        WSUserSearchCriteria c = new WSUserSearchCriteria();
        c.setName(searchCriteria);
        if (log.isDebugEnabled()) {
            log.debug((Object)("user search criteria was created. userName: " + searchCriteria));
        }
        return c;
    }

    public String getFullUserName(String pathInfo) {
        return pathInfo;
    }

    public WSRoleSearchCriteria getWSRoleSearchCriteria(String searchCriteria) {
        WSRoleSearchCriteria c = new WSRoleSearchCriteria();
        int tenantStartIndex = searchCriteria.indexOf("|");
        if (tenantStartIndex == -1) {
            c.setRoleName(searchCriteria);
            c.setTenantId(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("role search criteria was created. roleName: " + searchCriteria + " tenant: null"));
            }
        } else {
            String userName = searchCriteria.substring(0, tenantStartIndex);
            String tenantId = searchCriteria.substring(tenantStartIndex + 1, searchCriteria.length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("role search criteria was created. roleName: " + userName + " tenant:" + tenantId));
            }
            c.setRoleName(userName);
            c.setTenantId(tenantId);
        }
        return c;
    }

    public String removeSpecialSpaces(String str) {
        str = str.replaceAll("\\\n", "");
        str = str.replaceAll("\\\t", "");
        return str;
    }

    public UserDetails getCurrentlyLoggedUser() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        return (UserDetails)authenticationToken.getPrincipal();
    }

    public GrantedAuthority[] getCurrentlyLoggedUserAuthorities() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        return authenticationToken.getAuthorities();
    }

    public Map<String, String> getSpecialRoles() {
        return this.specialRoles;
    }

    public void setSpecialRoles(Map<String, String> specialRoles) {
        this.specialRoles = specialRoles;
    }

    public boolean isCurrentlyLoggedUserHasSuperUserRole() {
        GrantedAuthority[] currentlyLoggedUserAuthorities = this.getCurrentlyLoggedUserAuthorities();
        String superuserAuthority = this.getSpecialRoles().get(SUPERUSER);
        if (currentlyLoggedUserAuthorities != null && currentlyLoggedUserAuthorities.length > 0) {
            for (GrantedAuthority authority : currentlyLoggedUserAuthorities) {
                if (authority.getAuthority() == null || !authority.getAuthority().equals(superuserAuthority)) continue;
                return true;
            }
        }
        return false;
    }
}

