/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ObjectPermissionImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.TenantImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.rest.test.RESTTestUtils;
import com.jaspersoft.jasperserver.rest.test.RESTTestUtilsAndConsts;
import com.jaspersoft.jasperserver.rest.test.ReportDescriptor;
import com.jaspersoft.jasperserver.rest.test.helper.Common;
import com.jaspersoft.jasperserver.rest.utils.JAXBList;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class RESTTest {
    protected static final String REQUEST_PARAMENTER_RD = "ResourceDescriptor";
    protected static final String REQUEST_PARAMENTER_RESOURCE_BIN = "ResourceBinaries";
    protected static final String REQUEST_SAMPLE_IMAGE_PATH = "/ContentFiles/JUNIT_IMAGE_FILE";
    private HttpClient httpClient;
    private CookieStore cookieStore;
    private HttpContext httpContext;
    protected HttpRequestBase httpReqCE;
    protected HttpRequestBase httpReqPro;
    protected HttpRequestBase httpReq;
    protected HttpRequestBase tempHttpReq;
    protected HttpResponse httpRes;
    private final Log log = LogFactory.getLog(this.getClass());

    @Before
    public void setUp() {
        this.httpClient = new DefaultHttpClient();
        this.cookieStore = new BasicCookieStore();
        this.httpContext = new BasicHttpContext();
        this.httpContext.setAttribute("http.cookie-store", (Object)this.cookieStore);
    }

    @After
    public void tearDown() throws Exception {
        if (this.httpRes.getEntity().getContent().available() != 0) {
            this.httpRes.getEntity().getContent();
        }
        this.httpClient.getConnectionManager().closeExpiredConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRESTOrganization(Tenant tenant, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpPut();
        StringWriter sw = new StringWriter();
        RESTUtils.getMarshaller(TenantImpl.class).marshal((Object)tenant, (Writer)sw);
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new ByteArrayInputStream(sw.toString().getBytes()));
        ((HttpEntityEnclosingRequestBase)this.httpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReq, "/organization");
        try {
            RESTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        }
        finally {
            RESTTest.getResponseBody(this.httpRes.getEntity());
        }
    }

    public static String getResponseBody(HttpEntity entity) throws IOException, ParseException {
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream instream = entity.getContent();
        return RESTTest.inputStreamToString(instream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToString(InputStream instream) throws IOException, ParseException {
        if (instream == null) {
            throw new IllegalArgumentException("InputStream can not be null");
        }
        InputStreamReader reader = new InputStreamReader(instream);
        StringBuilder buffer = new StringBuilder();
        try {
            int l;
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return buffer.toString();
    }

    public static void assertValid404ResponseCode(int actualCode) throws Exception {
        RESTTest.assertValidResponseCode(404, actualCode);
    }

    public static void assertValidResponseCode(int expectedCode, int actualCode) throws Exception {
        Assert.assertTrue((String)("Basic response check did not pass; Expected code = " + expectedCode + "; Actual code = " + actualCode), (boolean)RESTTest.isValidResponse(expectedCode, actualCode));
    }

    public static boolean isValidResponse(int expected_Code, int actualCode) throws Exception {
        return actualCode == expected_Code;
    }

    public void deleteResource(String uri) throws Exception {
        this.deleteResource_CE(uri);
        this.deleteResource_PRO(uri);
    }

    public void deleteResource_CE(String uri) throws Exception {
        this.httpRes = this.sendRequestCE((HttpRequestBase)new HttpDelete(), uri);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    public void deleteResource_PRO(String uri) throws Exception {
        this.httpRes = this.sendRequestPRO((HttpRequestBase)new HttpDelete(), uri);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse());
    }

    protected void putSampleFolderAndFile() throws Exception {
        this.putSampleFolderAndFile((HttpRequestBase)new HttpPut(), "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/image_URI.JUNIT_NEW_FOLDER.JUNIT_IMAGE_FILE.xml", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperSoftLogo.jpg");
    }

    protected void putSampleFolderAndFile(HttpRequestBase req, String fileRDPath, String fileBinPath) throws Exception {
        this.putSampleFolder();
        this.putSampleFileInSampleFolder(req, fileRDPath, fileBinPath, "");
    }

    public void putSampleFileInSampleFolder(HttpRequestBase req, String fileRDPath, String fileBinPath, String path) throws Exception {
        this.tempHttpReq = req;
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart(REQUEST_PARAMENTER_RD, (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRDPath))));
        FileBody bin = new FileBody(new File(fileBinPath));
        reqEntity.addPart("/JUNIT_NEW_FOLDER/JUNIT_IMAGE_FILE", (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestCE(this.tempHttpReq, "/resource/JUNIT_NEW_FOLDER" + path);
        Assert.assertTrue((String)"basic response check did not pass", (this.isValidResposnse(this.httpRes, 201) || this.httpRes.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
        this.httpRes = this.sendRequestPRO(this.tempHttpReq, "/resource/JUNIT_NEW_FOLDER" + path);
        Assert.assertTrue((String)"basic response check did not pass", (this.isValidResposnse(201) || this.httpRes.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
    }

    protected void putSampleFolder() throws Exception {
        this.tempHttpReq = new HttpPut();
        this.sendAndAssert_CE(this.tempHttpReq, "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
        this.sendAndAssert_PRO(this.tempHttpReq, "/resource/JUNIT_NEW_FOLDER", "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/folder_URI.newFolder.xml", 201);
    }

    protected void putSampleReport() throws Exception {
        this.putSampleFolder();
        this.putSampleReport((HttpRequestBase)new HttpPut(), "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperSoftLogo.jpg", "");
    }

    protected void putSampleReport(HttpRequestBase req, String fileBinPath, String path) throws Exception {
        String SalesByMonthReportURI = "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/SalesByMonthReport";
        String ScriptletURI = "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Scriptlet";
        String LogoURI = "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/Logo";
        String SalesByMonthDetailURI = "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/SalesByMonthDetail";
        String sales_propertiesURI = "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/sales.properties";
        String sales_ro_propertiesURI = "/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH_files/sales_ro.properties";
        String SalesByMonthReportLocalPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/SalesByMonthReport.jrxml";
        String ScriptletLocalPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/scriptlet.jar";
        String LogoLocalPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperSoftLogo.jpg";
        String SalesByMonthDetailLocalPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/jasperReport_AllAccounts.jrxml";
        String sales_propertiesLocalPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/sales.properties";
        String sales_ro_propertiesLocalPath = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/sales_ro.properties";
        String fileRd = "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/reportUnit_URI.JUNIT_NEW_FOLDER.COMPLEX_REPORT_UNIT_TEST.xml";
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart(REQUEST_PARAMENTER_RD, (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRd))));
        FileBody bin = new FileBody(new File(SalesByMonthReportLocalPath));
        reqEntity.addPart(SalesByMonthReportURI, (ContentBody)bin);
        bin = new FileBody(new File(ScriptletLocalPath));
        reqEntity.addPart(ScriptletURI, (ContentBody)bin);
        bin = new FileBody(new File(LogoLocalPath));
        reqEntity.addPart(LogoURI, (ContentBody)bin);
        bin = new FileBody(new File(SalesByMonthDetailLocalPath));
        reqEntity.addPart(SalesByMonthDetailURI, (ContentBody)bin);
        bin = new FileBody(new File(sales_propertiesLocalPath));
        reqEntity.addPart(sales_propertiesURI, (ContentBody)bin);
        bin = new FileBody(new File(sales_ro_propertiesLocalPath));
        reqEntity.addPart(sales_ro_propertiesURI, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestCE(req, "/resource/JUNIT_NEW_FOLDER" + path);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
        this.httpRes = this.sendRequestPRO(req, "/resource/JUNIT_NEW_FOLDER" + path);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
    }

    protected void deleteSampleReport() throws Exception {
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_REPORT_UNIT_SALES_BY_MONTH");
    }

    protected void deleteSampleFolder() throws Exception {
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER");
    }

    public void Resource_LocalResource_of_ReportUnit_PUT_200(HttpRequestBase req, String fileRDPath, String fileBinPath, String entityBinKey, String resourceURI) throws Exception {
        this.putSampleReport();
        this.tempHttpReq = req;
        MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        reqEntity.addPart(REQUEST_PARAMENTER_RD, (ContentBody)new StringBody(RESTTestUtilsAndConsts.getResourceDescriptor(new File(fileRDPath))));
        FileBody bin = new FileBody(new File(fileBinPath));
        reqEntity.addPart(entityBinKey, (ContentBody)bin);
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestCE(this.tempHttpReq, "/resource" + resourceURI);
        Assert.assertTrue((String)"basic response check did not pass", (this.isValidResposnse(this.httpRes, 201) || this.httpRes.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
        this.httpRes = this.sendRequestPRO(this.tempHttpReq, "/resource" + resourceURI);
        Assert.assertTrue((String)"basic response check did not pass", (this.isValidResposnse(201) || this.httpRes.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
    }

    void putSampleRole_CE() throws Exception {
        this.putSampleResource_CE("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_ce.xml", "/role");
    }

    void putSampleRole_PRO() throws Exception {
        this.putSampleResource_PRO("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/role/role_junit_pro.xml", "/role");
    }

    protected void putSampleResource(String rd_path, String call_path) throws Exception {
        this.putSampleResource_CE(rd_path, call_path);
        this.putSampleResource_PRO(rd_path, call_path);
    }

    protected void putSampleResource_CE(String rd_path, String call_path) throws Exception {
        this.tempHttpReq = new HttpPut();
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream(new File(rd_path)));
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestCE(this.tempHttpReq, call_path);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
    }

    protected void putSampleResource_PRO(String rd_path, String call_path) throws Exception {
        this.tempHttpReq = new HttpPut();
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream(new File(rd_path)));
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.tempHttpReq, call_path);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(201));
    }

    protected void putSampleInputControlInSampleFolder() throws Exception {
        this.putSampleInputControlInSampleFolder((HttpRequestBase)new HttpPut(), "src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/inputControl_URI.JUNIT_NEW_FOLDER.JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE.xml");
    }

    protected void putSampleInputControlInSampleFolder(HttpRequestBase req, String fileRDPath) throws Exception {
        this.putSampleFolder();
        this.putSampleInputControlInSampleFolder(req, fileRDPath, "", 201);
    }

    public void putSampleInputControlInSampleFolder(HttpRequestBase req, String fileRDPath, String path, int expectedStatus) throws Exception {
        this.sendAndAssert_CE(req, "/resource/JUNIT_NEW_FOLDER" + path, fileRDPath, expectedStatus);
        this.sendAndAssert_PRO(req, "/resource/JUNIT_NEW_FOLDER" + path, fileRDPath, expectedStatus);
    }

    public void deleteSampleInputControl() throws Exception {
        this.sendAndAssert_CE((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE");
        this.sendAndAssert_PRO((HttpRequestBase)new HttpDelete(), "/resource/JUNIT_NEW_FOLDER/JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE");
    }

    public void putSampleJob_CE() throws Exception {
        this.putJob(false);
    }

    public void putSampleJob_PRO() throws Exception {
        this.putJob(true);
    }

    private void putJob(boolean isPro) throws Exception {
        this.tempHttpReq = new HttpPut();
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream("src/main/java/com/jaspersoft/jasperserver/rest/test/resources/descriptors/new/reportJob_URI.reports.samples.allaccounts.xml"));
        ((HttpEntityEnclosingRequestBase)this.tempHttpReq).setEntity((HttpEntity)reqEntity);
        if (!isPro) {
            this.sendAndAssert_CE(this.tempHttpReq, "/job", 201);
        } else {
            this.sendAndAssert_PRO(this.tempHttpReq, "/job", 201);
        }
    }

    protected void deleteJob(int jobId, boolean isPro) throws Exception {
        this.tempHttpReq = new HttpDelete();
        if (!isPro) {
            this.sendAndAssert_CE(this.tempHttpReq, "/job/" + jobId);
        } else {
            this.sendAndAssert_PRO(this.tempHttpReq, "/job/" + jobId);
        }
    }

    public String getSampleJobSummary_CE() throws Exception {
        return this.getJobSummeryForReport(false);
    }

    public String getSampleJobSummary_PRO() throws Exception {
        return this.getJobSummeryForReport(true);
    }

    private String getJobSummeryForReport(boolean isPro) throws Exception {
        this.tempHttpReq = new HttpGet();
        this.httpRes = !isPro ? this.sendRequestCE(this.tempHttpReq, "/jobsummary/reports/samples/AllAccounts") : this.sendRequestPRO(this.tempHttpReq, "/jobsummary/reports/samples/AllAccounts");
        Assert.assertTrue((String)"basic response check did not pass", (this.httpRes.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
        return IOUtils.toString((InputStream)this.httpRes.getEntity().getContent());
    }

    protected int getJobIndexFromJobSummary(String jobSummaryXML) {
        int jobIDStartIndex = jobSummaryXML.indexOf("<id>") + "<id>".length();
        int jobIDEndIndex = jobSummaryXML.indexOf("</id>");
        return Integer.parseInt(jobSummaryXML.substring(jobIDStartIndex, jobIDEndIndex));
    }

    public void loginToServer() {
        this.loginToServer("jasperadmin", "jasperadmin", "jasperadmin%7Corganization_1", "jasperadmin");
    }

    public void loginToPROServer(String userName, String passoword) {
        this.loginToServer("jasperadmin", "jasperadmin", userName, passoword);
    }

    public void loginToPROServer(String userName, String passoword, String organization) {
        this.loginToServer("jasperadmin", "jasperadmin", userName + "%7C" + organization, passoword);
    }

    public void loginToServer(String ceUserName, String cePassword, String proUserName, String proPassword) {
        ArrayList<NameValuePair> ce_qparams = new ArrayList<NameValuePair>();
        ce_qparams.add((NameValuePair)new BasicNameValuePair("j_username", ceUserName));
        ce_qparams.add((NameValuePair)new BasicNameValuePair("j_password", cePassword));
        ArrayList<NameValuePair> pro_qparams = new ArrayList<NameValuePair>();
        pro_qparams.add((NameValuePair)new BasicNameValuePair("j_username", proUserName));
        pro_qparams.add((NameValuePair)new BasicNameValuePair("j_password", proPassword));
        try {
            this.httpRes = this.sendRequestCE((HttpRequestBase)new HttpPost(), "/login", ce_qparams);
            IOUtils.toString((InputStream)this.httpRes.getEntity().getContent());
            this.httpRes = this.sendRequestPRO((HttpRequestBase)new HttpPost(), "/login", pro_qparams);
            IOUtils.toString((InputStream)this.httpRes.getEntity().getContent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void sendAndAssert_CE(HttpRequestBase req, String service, String rdPath, int expectedStatus) throws Exception {
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream(rdPath));
        ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)reqEntity);
        this.sendAndAssert_CE(req, service, expectedStatus);
    }

    protected void sendAndAssert_PRO(HttpRequestBase req, String service, String rdPath, int expectedStatus) throws Exception {
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new FileInputStream(rdPath));
        ((HttpEntityEnclosingRequestBase)req).setEntity((HttpEntity)reqEntity);
        this.sendAndAssert_PRO(req, service, expectedStatus);
    }

    protected void sendAndAssert_CE(HttpRequestBase req, String service, String rdPath) throws Exception {
        this.sendAndAssert_CE(req, service, rdPath, 200);
    }

    protected void sendAndAssert_PRO(HttpRequestBase req, String service, String rdPath) throws Exception {
        this.sendAndAssert_PRO(req, service, rdPath, 200);
    }

    protected void sendAndAssert_CE(HttpRequestBase req, String service, int expectedStatus) throws Exception {
        this.httpRes = this.sendRequestCE(req, service);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(expectedStatus));
    }

    protected void sendAndAssert_PRO(HttpRequestBase req, String service, int expectedStatus) throws Exception {
        this.httpRes = this.sendRequestPRO(req, service);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(expectedStatus));
    }

    protected void sendAndAssert_CE(HttpRequestBase req, String service) throws Exception {
        this.httpRes = this.sendRequestCE(req, service);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(200));
    }

    protected void sendAndAssert_PRO(HttpRequestBase req, String service) throws Exception {
        this.httpRes = this.sendRequestPRO(req, service);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(200));
    }

    protected HttpResponse sendRequestCE(HttpRequestBase req, String service) throws Exception {
        return this.sendRequestCE(req, service, null);
    }

    protected HttpResponse sendRequestCE(HttpRequestBase req, String service, List<NameValuePair> qparams) throws Exception {
        URI uri = this.createURI(service, qparams, false);
        req.setURI(uri);
        return this.httpClient.execute((HttpUriRequest)req, this.httpContext);
    }

    protected HttpResponse sendRequestCeFroNonRestService(HttpRequestBase req, String service, List<NameValuePair> qparams) throws Exception {
        URI uri = this.createURIForNoneRestService(service, qparams, false);
        req.setURI(uri);
        return this.httpClient.execute((HttpUriRequest)req, this.httpContext);
    }

    protected HttpResponse sendRequestProFroNonRestService(HttpRequestBase req, String service, List<NameValuePair> qparams) throws Exception {
        URI uri = this.createURIForNoneRestService(service, qparams, true);
        req.setURI(uri);
        return this.httpClient.execute((HttpUriRequest)req, this.httpContext);
    }

    protected HttpResponse sendRequestPRO(HttpRequestBase req, String service) throws Exception {
        return this.sendRequestPRO(req, service, null);
    }

    protected HttpResponse sendRequestPRO(HttpRequestBase req, String service, List<NameValuePair> qparams) throws Exception {
        URI uri = this.createURI(service, qparams, true);
        req.setURI(uri);
        return this.httpClient.execute((HttpUriRequest)req, this.httpContext);
    }

    private URI createURIForNoneRestService(String servicePath, List<NameValuePair> qparams, boolean isPro) throws Exception {
        if (isPro) {
            return this.createURI("/jasperserver-pro" + servicePath, qparams);
        }
        return this.createURI("/jasperserver" + servicePath, qparams);
    }

    private URI createURI(String servicePath, List<NameValuePair> qparams, boolean isPro) throws Exception {
        if (isPro) {
            return this.createURI("/jasperserver-pro/rest" + servicePath, qparams);
        }
        return this.createURI("/jasperserver/rest" + servicePath, qparams);
    }

    private URI createURI(String servicePath, List<NameValuePair> qparams) throws Exception {
        URI uri = qparams != null ? URIUtils.createURI((String)"http", (String)"localhost", (int)8080, (String)servicePath, (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null) : new URL("http", "localhost", 8080, servicePath).toURI();
        return uri;
    }

    protected boolean isValidBinaryResposnse() throws Exception {
        return this.isValidResposnse() && this.httpRes.getHeaders("Content-Type") != null && this.httpRes.getHeaders("Content-Length") != null;
    }

    protected boolean isValidResposnse() throws Exception {
        return this.isValidResposnse(200);
    }

    protected boolean isValidResposnse(int expected_respose_code) throws Exception {
        String body = EntityUtils.toString((HttpEntity)this.httpRes.getEntity());
        return this.httpRes.getStatusLine().getStatusCode() == expected_respose_code;
    }

    protected boolean isValidResposnse(HttpResponse res, int expected_respose_code) throws Exception {
        InputStream is = res.getEntity().getContent();
        is.close();
        return this.httpRes.getStatusLine().getStatusCode() == expected_respose_code;
    }

    public ReportDescriptor runReport(String reportName, String reportUrl, RESTTestUtils.ReportOutputFormat outputFormat) throws Exception {
        ReportDescriptor reportDescriptor = new ReportDescriptor();
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setWsType("reportUnit");
        rd.setName(reportName);
        rd.setUriString(reportUrl + "/" + reportName);
        rd.setIsNew(false);
        this.httpReq = RESTTestUtils.assembleRequest(rd, (HttpRequestBase)new HttpPut());
        this.httpRes = this.sendRequestPRO(this.httpReq, "/report" + (outputFormat != null ? "/?RUN_OUTPUT_FORMAT=" + (Object)((Object)outputFormat) : ""));
        reportDescriptor.parseXMLResponse(this.httpRes);
        return reportDescriptor;
    }

    public void saveReport(ReportDescriptor reportDescriptor, Integer expectedFileSize) throws Exception {
        String fileExt = reportDescriptor.getFileExtension();
        String[] tmp = reportDescriptor.originalUri.split("[/]");
        String reportName = tmp[tmp.length - 1];
        this.tempHttpReq = new HttpGet();
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("file", reportDescriptor.isJasperPrint() ? "jasperPrint" : "report"));
        this.httpRes = this.sendRequestCE(this.tempHttpReq, "/report/" + reportDescriptor.uuid, qparams);
        Common.saveResourceToFile(this.httpRes, reportName, fileExt);
        RESTTestUtils.assertCorrectFileSize("src/main/java/com/jaspersoft/jasperserver/rest/test/serverresources/report/outputFiles/" + reportName + "." + fileExt, expectedFileSize != null ? expectedFileSize : 0);
    }

    public ReportDescriptor changeReportParametersInSession(ReportDescriptor reportDescriptor, List<NameValuePair> qparams) throws Exception {
        this.tempHttpReq = new HttpPost();
        this.httpRes = this.executeCall(this.tempHttpReq, "/report/" + reportDescriptor.uuid, qparams);
        reportDescriptor.parseXMLResponse(this.httpRes);
        return reportDescriptor;
    }

    protected HttpResponse executeCall(HttpRequestBase req, String action_path, List<NameValuePair> qparams) throws Exception {
        req.setURI(this.createURI(action_path, qparams));
        this.httpRes = this.httpClient.execute((HttpUriRequest)req, this.httpContext);
        return this.httpRes;
    }

    protected HttpResponse executeCall(HttpRequestBase req, String action_path) throws Exception {
        return this.executeCall(req, action_path, null);
    }

    public WSRole[] getRESTRoles(String role) throws Exception {
        List<WSRole> wsRoles = this.getRESTRoles("/" + role, 200);
        WSRole[] roles = new WSRole[wsRoles.size()];
        return wsRoles.toArray(roles);
    }

    public List<WSRole> getRESTRoles(String role, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpGet();
        this.httpRes = this.sendRequestPRO(this.httpReq, "/role" + role);
        RESTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        InputStream getUsersResp = this.httpRes.getEntity().getContent();
        String usersRespString = IOUtils.toString((InputStream)getUsersResp);
        ArrayList<WSRole> foundRoles = new ArrayList<WSRole>();
        String[] foundRolesParts = usersRespString.split("<role>");
        for (int i = 1; i < foundRolesParts.length; ++i) {
            String foundRolesPart = "<role>" + foundRolesParts[i].replace("</roles>", "");
            foundRoles.add(RESTUtils.unmarshal(WSRole.class, new ByteArrayInputStream(foundRolesPart.getBytes())));
        }
        return foundRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRESTUser(WSUser user, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpPut();
        StringWriter sw = new StringWriter();
        RESTUtils.getMarshaller(WSUser.class).marshal((Object)user, (Writer)sw);
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new ByteArrayInputStream(sw.toString().getBytes()));
        ((HttpEntityEnclosingRequestBase)this.httpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReq, RESTTestUtilsAndConsts.USER_BASE_URL);
        try {
            RESTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        }
        finally {
            RESTTest.getResponseBody(this.httpRes.getEntity());
        }
    }

    public List<WSUser> getRESTUsers(String username) throws Exception {
        return this.getRESTUsers("/" + username, 200);
    }

    public void verifyUser(WSUser user_to_check, boolean expected_exists) throws Exception {
        List<WSUser> wsUsers = this.getRESTUsers(user_to_check.getUsername());
        boolean actual_exists = false;
        String user_to_check_id = user_to_check.getTenantId() != null ? user_to_check.getTenantId() : "";
        for (WSUser wsUser : wsUsers) {
            String wsUser_id;
            String string = wsUser_id = wsUser.getTenantId() != null ? wsUser.getTenantId() : "";
            if (!user_to_check.getUsername().equals(wsUser.getUsername()) || !user_to_check.getPassword().equals(wsUser.getPassword()) || !user_to_check_id.equals(wsUser_id)) continue;
            actual_exists = true;
        }
        if (expected_exists) {
            Assert.assertEquals((String)"Such user should exist, but it doesn't exist!", (Object)actual_exists, (Object)true);
        } else {
            Assert.assertEquals((String)"Such user should not exist, but it was found!", (Object)actual_exists, (Object)false);
        }
    }

    public List<WSUser> getRESTUsers(String username, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpGet();
        this.httpRes = this.sendRequestPRO(this.httpReq, RESTTestUtilsAndConsts.USER_BASE_URL + username);
        RESTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        InputStream getUsersResp = this.httpRes.getEntity().getContent();
        String usersRespString = IOUtils.toString((InputStream)getUsersResp);
        ArrayList<WSUser> foundUsers = new ArrayList<WSUser>();
        String[] foundUsersParts = usersRespString.split("<user>");
        for (int i = 1; i < foundUsersParts.length; ++i) {
            String foundUsersPart = "<user>" + foundUsersParts[i].replace("</users>", "");
            foundUsers.add(RESTUtils.unmarshal(WSUser.class, new ByteArrayInputStream(foundUsersPart.getBytes())));
        }
        return foundUsers;
    }

    public WSUser sampleUserDescriptor() {
        WSUser wsUser = new WSUser();
        wsUser.setEnabled(Boolean.valueOf(true));
        wsUser.setExternallyDefined(Boolean.valueOf(false));
        wsUser.setFullName("test");
        wsUser.setPassword("test");
        wsUser.setUsername("test");
        wsUser.setTenantId("organization_1");
        return wsUser;
    }

    public Tenant sampleOrganizationDescriptor() {
        TenantImpl tenant = new TenantImpl();
        tenant.setParentId("organization_1");
        tenant.setId("REST_TEST_ORGANIZATION");
        tenant.setTenantName("REST_TEST_ORGANIZATION");
        tenant.setAlias("REST_TEST_ORGANIZATION");
        tenant.setTheme("default");
        return tenant;
    }

    public RoleImpl convertWSRole(WSRole wsRole) {
        RoleImpl roleToReturn = new RoleImpl();
        roleToReturn.setRoleName(wsRole.getRoleName());
        roleToReturn.setTenantId(wsRole.getTenantId());
        roleToReturn.setExternallyDefined(wsRole.getExternallyDefined().booleanValue());
        return roleToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRESTRole(WSRole role, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpPut();
        StringWriter sw = new StringWriter();
        RESTUtils.getMarshaller(WSRole.class).marshal((Object)role, (Writer)sw);
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new ByteArrayInputStream(sw.toString().getBytes()));
        ((HttpEntityEnclosingRequestBase)this.httpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReq, "/role");
        try {
            RESTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        }
        finally {
            RESTTest.getResponseBody(this.httpRes.getEntity());
        }
    }

    public ObjectPermission getSampleObjectPermission(String url, Object recipient, int mask) {
        ObjectPermissionImpl o = new ObjectPermissionImpl();
        o.setPermissionMask(mask);
        o.setPermissionRecipient(recipient);
        o.setURI(url);
        return o;
    }

    public void putRESTPermissions(JAXBList permission, int expectedStatsCode) throws Exception {
        this.put_postRESTPermissions(permission, expectedStatsCode, (HttpRequestBase)new HttpPut());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put_postRESTPermissions(JAXBList permission, int expectedStatsCode, HttpRequestBase request) throws Exception {
        this.httpReq = request;
        StringWriter sw = new StringWriter();
        RESTUtils.getMarshaller(JAXBList.class, ObjectPermissionImpl.class, UserImpl.class, RoleImpl.class).marshal((Object)permission, (Writer)sw);
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new ByteArrayInputStream(sw.toString().getBytes()));
        ((HttpEntityEnclosingRequestBase)this.httpReq).setEntity((HttpEntity)reqEntity);
        this.httpRes = this.sendRequestPRO(this.httpReq, "/permission");
        try {
            RESTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        }
        finally {
            RESTTest.getResponseBody(this.httpRes.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRESTRole(String rolename, int expectedStatsCode) throws Exception {
        this.httpReq = new HttpDelete();
        this.httpRes = this.sendRequestPRO(this.httpReq, "/role" + rolename);
        try {
            RESTTest.assertValidResponseCode(expectedStatsCode, this.httpRes.getStatusLine().getStatusCode());
        }
        finally {
            RESTTest.getResponseBody(this.httpRes.getEntity());
        }
    }

    public void deleteRESTRole(String rolename) throws Exception {
        this.deleteRESTRole("/" + rolename, 200);
    }

    public void deleteRESTRole(WSRole wsRole) throws Exception {
        this.deleteRESTRole(wsRole.getRoleName() + (wsRole.getTenantId() != null ? "%7C" + wsRole.getTenantId() : ""));
    }
}

