/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.core.util.XMLUtil;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.LegacyRunReportService;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Set;
import javax.activation.DataSource;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component(value="restResourceService")
@Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class RESTResource
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTResource.class);
    @Resource
    private ResourcesManagementRemoteService resourcesManagementRemoteService;
    @Resource(name="legacyRunReportService")
    private LegacyRunReportService runReportService;

    public void setResourcesManagementRemoteService(ResourcesManagementRemoteService resourcesManagementRemoteService) {
        this.resourcesManagementRemoteService = resourcesManagementRemoteService;
    }

    public void setRunReportService(LegacyRunReportService runReportService) {
        this.runReportService = runReportService;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        uri = this.restUtils.extractRepositoryUri(req.getPathInfo());
        if (!this.validParameters(req.getParameterMap().keySet())) {
            throw new ServiceException(400, "request contains unsupported parameters");
        }
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        options = new HashMap<String, Object>();
        if (req.getParameter("IC_GET_QUERY_DATA") != null) {
            options.put("IC_GET_QUERY_DATA", req.getParameter("IC_GET_QUERY_DATA"));
            parameters = this.restUtils.extractParameters(req);
            if (parameters.size() > 0) {
                options.put("PARAMS_ARG", parameters);
            }
        }
        if (!this.restUtils.isLocalResource(uri)) ** GOTO lbl-1000
        if (req.getParameterMap().containsKey("fileData")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        options.put("GET_LOCAL_RESOURCE", v0);
        if (RESTResource.log.isDebugEnabled()) {
            RESTResource.log.debug((Object)"adding the local resource with data flag");
        }
        rd = null;
        try {
            rd = this.resourcesManagementRemoteService.getResource(uri, options);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceException(ex.getMessage());
        }
        if (rd == null) {
            if (RESTResource.log.isDebugEnabled()) {
                RESTResource.log.debug((Object)("Could not find resource: " + uri));
            }
            throw new ServiceException(400, "Could not find resource: " + uri);
        }
        if (Boolean.parseBoolean(req.getParameter("fileData"))) {
            if (this.runReportService.getReportAttachments(rd.getUriString()).get(rd.getUriString()) != null) {
                this.restUtils.sendFile((DataSource)this.runReportService.getReportAttachments(rd.getUriString()).get(rd.getUriString()), resp);
            } else if (this.runReportService.getReportAttachments(rd.getUriString()).get("attachment") != null) {
                this.restUtils.sendFile((DataSource)this.runReportService.getReportAttachments(rd.getUriString()).get("attachment"), resp);
            }
            return;
        }
        m = new Marshaller();
        xml = m.writeResourceDescriptor(rd);
        resp.setContentType("text/xml");
        this.restUtils.setStatusAndBody(200, resp, xml);
    }

    private boolean validParameters(Set<String> set) throws ServiceException {
        for (String key : set) {
            if (key.equals("fileData") || key.equals("IC_GET_QUERY_DATA") || key.startsWith("P_") || key.startsWith("PL_")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("request contains unsupported parameters: " + key));
            }
            return false;
        }
        return true;
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        HttpServletRequest mreq = this.restUtils.extractAttachments(this.runReportService, req);
        String resourceDescriptorXml = null;
        if (mreq instanceof MultipartHttpServletRequest) {
            resourceDescriptorXml = mreq.getParameter("ResourceDescriptor");
        } else {
            try {
                resourceDescriptorXml = IOUtils.toString((InputStream)req.getInputStream());
            }
            catch (IOException ex) {
                throw new ServiceException(500, ex.getLocalizedMessage());
            }
        }
        if (resourceDescriptorXml == null) {
            this.restUtils.setStatusAndBody(400, resp, "Missing parameter " + "ResourceDescriptor" + " " + this.runReportService.getInputAttachments());
            return;
        }
        InputSource is = new InputSource(new StringReader(resourceDescriptorXml));
        Document doc = null;
        ResourceDescriptor rd = null;
        try {
            doc = XMLUtil.getNewDocumentBuilder().parse(is);
            rd = Unmarshaller.readResourceDescriptor((Element)doc.getDocumentElement());
            if (log.isDebugEnabled()) {
                log.debug((Object)("resource descriptor was created successfully for: " + rd.getUriString()));
            }
            rd.setIsNew(true);
            ResourceDescriptor createdRd = this.resourcesManagementRemoteService.putResource(rd);
            Marshaller m = new Marshaller();
            String xml = m.writeResourceDescriptor(createdRd);
            this.restUtils.setStatusAndBody(201, resp, "");
        }
        catch (SAXException ex) {
            log.error((Object)("Unexpected error during resource descriptor marshaling: " + ex.getMessage()), (Throwable)ex);
            this.restUtils.setStatusAndBody(400, resp, "Invalid resource descriptor");
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error((Object)("Unexpected error during resource save: " + ex.getMessage()), (Throwable)ex);
            throw new ServiceException(500, ex.getLocalizedMessage());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String sourceURI = this.restUtils.extractRepositoryUri(req.getPathInfo());
        String destURI = this.restUtils.getDetinationUri(req);
        if (destURI != null) {
            if (req.getParameterMap().containsKey("copyTo")) {
                this.resourcesManagementRemoteService.copyResource(sourceURI, destURI);
            } else {
                this.resourcesManagementRemoteService.moveResource(sourceURI, destURI);
            }
        } else {
            HttpServletRequest mreq = this.restUtils.extractAttachments(this.runReportService, req);
            String resourceDescriptorXml = null;
            if (mreq instanceof MultipartHttpServletRequest) {
                resourceDescriptorXml = mreq.getParameter("ResourceDescriptor");
            } else {
                try {
                    resourceDescriptorXml = IOUtils.toString((InputStream)req.getInputStream());
                }
                catch (IOException ex) {
                    throw new ServiceException(500, ex.getLocalizedMessage());
                }
            }
            if (resourceDescriptorXml == null) {
                String msg = "Missing parameter " + "ResourceDescriptor" + " " + this.runReportService.getInputAttachments();
                this.restUtils.setStatusAndBody(400, resp, msg);
                throw new ServiceException(500, msg);
            }
            InputSource is = new InputSource(new StringReader(resourceDescriptorXml));
            Document doc = null;
            ResourceDescriptor rd = null;
            try {
                doc = XMLUtil.getNewDocumentBuilder().parse(is);
                rd = Unmarshaller.readResourceDescriptor((Element)doc.getDocumentElement());
                rd.setIsNew(false);
                if (rd.getUriString() == null || !rd.getUriString().equals(sourceURI)) {
                    throw new ServiceException(400, "Request URI and descriptor URI are not equals");
                }
                this.resourcesManagementRemoteService.updateResource(sourceURI, rd, true);
                this.restUtils.setStatusAndBody(200, resp, "");
            }
            catch (SAXException ex) {
                log.error((Object)"error parsing...", (Throwable)ex);
                throw new ServiceException(400, ex.getMessage());
            }
            catch (ServiceException ex) {
                log.error((Object)"error executing the service...", (Throwable)ex);
                throw ex;
            }
            catch (ParserConfigurationException e) {
                throw new ServiceException(400, e.getMessage());
            }
            catch (IOException e) {
                throw new ServiceException(400, e.getMessage());
            }
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String uri = this.restUtils.extractRepositoryUri(req.getPathInfo());
        this.resourcesManagementRemoteService.deleteResource(uri);
        resp.setStatus(200);
    }
}

