/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.DBSemaphore;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Util;

public class UpdateLockRowSemaphore
extends DBSemaphore {
    public static final String UPDATE_FOR_LOCK = "UPDATE {0}LOCKS SET LOCK_NAME = LOCK_NAME WHERE SCHED_NAME = {1} AND LOCK_NAME = ? ";
    public static final String INSERT_LOCK = "INSERT INTO {0}LOCKS(SCHED_NAME, LOCK_NAME) VALUES ({1}, ?)";

    public UpdateLockRowSemaphore() {
        super("QRTZ_", null, UPDATE_FOR_LOCK, INSERT_LOCK);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeSQL(Connection conn, String lockName, String expandedSQL, String expandedInsertSQL) throws LockException {
        PreparedStatement ps = null;
        int count = 0;
        do {
            Exception ignore3;
            Object var11_12;
            block17: {
                block18: {
                    int numUpdate;
                    ++count;
                    ps = conn.prepareStatement(expandedSQL);
                    ps.setString(1, lockName);
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
                    }
                    if ((numUpdate = ps.executeUpdate()) >= 1) break block17;
                    this.getLog().debug("Inserting new lock row for lock: '" + lockName + "' being obtained by thread: " + Thread.currentThread().getName());
                    ps.close();
                    ps = null;
                    ps = conn.prepareStatement(expandedInsertSQL);
                    ps.setString(1, lockName);
                    int res = ps.executeUpdate();
                    if (res == 1) break block18;
                    if (count >= 3) throw new SQLException(Util.rtp("No row exists, and one could not be inserted in table {0}LOCKS for lock named: " + lockName, this.getTablePrefix(), this.getSchedulerNameLiteral()));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore2) {
                        Thread.currentThread().interrupt();
                    }
                    var11_12 = null;
                    if (ps == null) continue;
                    try {
                        ps.close();
                    }
                    catch (Exception ignore3) {}
                    continue;
                }
                var11_12 = null;
                if (ps == null) return;
                try {
                    ps.close();
                    return;
                }
                catch (Exception ignore3) {}
                return;
            }
            var11_12 = null;
            if (ps == null) continue;
            try {
                ps.close();
            }
            catch (Exception ignore3) {}
            continue;
            {
                catch (SQLException sqle) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName() + (count < 3 ? " - will try again." : ""));
                    }
                    if (count >= 3) throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignore4) {
                        Thread.currentThread().interrupt();
                    }
                    var11_12 = null;
                    if (ps == null) continue;
                    try {
                        ps.close();
                    }
                    catch (Exception ignore3) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_12 = null;
                if (ps == null) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (Exception ignore3) {
                    // empty catch block
                }
                throw throwable;
            }
        } while (count < 2);
    }

    protected String getUpdateLockRowSQL() {
        return this.getSQL();
    }

    public void setUpdateLockRowSQL(String updateLockRowSQL) {
        this.setSQL(updateLockRowSQL);
    }
}

