/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import net.sf.jasperreports.engine.util.JEditorPaneHtmlMarkupProcessor;
import net.sf.jasperreports.engine.util.JEditorPaneRtfMarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;

public abstract class JEditorPaneMarkupProcessor
implements MarkupProcessor {
    protected Map<AttributedCharacterIterator.Attribute, Object> getAttributes(AttributeSet attrSet) {
        HashMap<AttributedCharacterIterator.Attribute, Object> attrMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if (attrSet.isDefined(StyleConstants.FontFamily)) {
            attrMap.put(TextAttribute.FAMILY, StyleConstants.getFontFamily(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Bold)) {
            attrMap.put(TextAttribute.WEIGHT, StyleConstants.isBold(attrSet) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Italic)) {
            attrMap.put(TextAttribute.POSTURE, StyleConstants.isItalic(attrSet) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        }
        if (attrSet.isDefined(StyleConstants.Underline)) {
            attrMap.put(TextAttribute.UNDERLINE, StyleConstants.isUnderline(attrSet) ? TextAttribute.UNDERLINE_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.StrikeThrough)) {
            attrMap.put(TextAttribute.STRIKETHROUGH, StyleConstants.isStrikeThrough(attrSet) ? TextAttribute.STRIKETHROUGH_ON : null);
        }
        if (attrSet.isDefined(StyleConstants.FontSize)) {
            attrMap.put(TextAttribute.SIZE, new Float(StyleConstants.getFontSize(attrSet)));
        }
        if (attrSet.isDefined(StyleConstants.Foreground)) {
            attrMap.put(TextAttribute.FOREGROUND, StyleConstants.getForeground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Background)) {
            attrMap.put(TextAttribute.BACKGROUND, StyleConstants.getBackground(attrSet));
        }
        if (attrSet.isDefined(StyleConstants.Superscript) && !StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        }
        if (attrSet.isDefined(StyleConstants.Subscript) && StyleConstants.isSubscript(attrSet)) {
            attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        }
        return attrMap;
    }

    @Override
    public abstract String convert(String var1);

    public static final class HtmlFactory
    implements MarkupProcessorFactory {
        @Override
        public MarkupProcessor createMarkupProcessor() {
            return JEditorPaneHtmlMarkupProcessor.getInstance();
        }
    }

    public static final class RtfFactory
    implements MarkupProcessorFactory {
        @Override
        public MarkupProcessor createMarkupProcessor() {
            return JEditorPaneRtfMarkupProcessor.getInstance();
        }
    }
}

