/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.MemoryDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshotData;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshotMetadata;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DefaultDataCacheSnapshotMetadata;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.repository.beans.DataSnapshotMetadataBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import java.util.List;
import java.util.Map;

public class ReportUnitBean
extends ResourceBean {
    private static final String DATA_SNAPSHOT_SERVICE_BEAN = "dataSnapshotService";
    private ResourceReferenceBean dataSource;
    private ResourceReferenceBean query;
    private ResourceReferenceBean[] inputControls;
    private ResourceReferenceBean mainReport;
    private ResourceReferenceBean[] resources;
    private String inputControlRenderingView;
    private String reportRenderingView;
    private boolean alwaysPromptControls;
    private byte controlsLayout = (byte)2;
    private DataSnapshotMetadataBean dataSnapshotMetadata;

    @Override
    protected void additionalCopyFrom(Resource res, ResourceExportHandler exportHandler) {
        ReportUnit ru = (ReportUnit)res;
        this.setDataSource(exportHandler.handleReference(ru.getDataSource()));
        this.setQuery(exportHandler.handleReference(ru.getQuery()));
        this.setInputControls(this.handleReferences(ru.getInputControls(), exportHandler));
        this.setMainReport(exportHandler.handleReference(ru.getMainReport()));
        this.setResources(this.handleReferences(ru.getResources(), exportHandler));
        this.setInputControlRenderingView(ru.getInputControlRenderingView());
        this.setReportRenderingView(ru.getReportRenderingView());
        this.setAlwaysPromptControls(ru.isAlwaysPromptControls());
        this.setControlsLayout(ru.getControlsLayout());
        this.copyDataSnapshotFrom(exportHandler, ru);
    }

    protected void copyDataSnapshotFrom(ResourceExportHandler exportHandler, ReportUnit ru) {
        Long snapshotId = ru.getDataSnapshotId();
        if (snapshotId != null) {
            DataSnapshotService snapshotService = this.getSnapshotService(exportHandler.getConfiguration());
            if (!snapshotService.isSnapshotPersistenceEnabled()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("data snapshot persistence disabled, ignoring snapshot " + snapshotId + " of report " + ru.getURIString()));
                }
                return;
            }
            DataCacheSnapshotData dataSnapshot = snapshotService.loadSnapshotData(exportHandler.getExecutionContext(), snapshotId);
            if (dataSnapshot != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("exporting data snapshot " + snapshotId + " for report " + ru.getURIString()));
                }
                this.dataSnapshotMetadata = new DataSnapshotMetadataBean();
                this.dataSnapshotMetadata.copyFrom(dataSnapshot.getMetadata(), ru.getURIString(), exportHandler);
                String fileName = this.snapshotDataFileName(ru);
                exportHandler.handleData((Resource)ru, fileName, dataSnapshot.getSnapshotData().getInputStream());
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Did not find data snapshot " + snapshotId + " for report " + ru.getURIString()));
            }
        }
    }

    protected String snapshotDataFileName(ReportUnit ru) {
        return ru.getName() + "_data_snapshot.dump";
    }

    protected DataSnapshotService getSnapshotService(ResourceModuleConfiguration configuration) {
        DataSnapshotService snapshotService = (DataSnapshotService)configuration.getApplicationContext().getBean(DATA_SNAPSHOT_SERVICE_BEAN, DataSnapshotService.class);
        return snapshotService;
    }

    @Override
    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        ReportUnit ru = (ReportUnit)res;
        ru.setDataSource(importHandler.handleReference(this.getDataSource()));
        ru.setQuery(importHandler.handleReference(this.getQuery()));
        ru.setInputControls(this.handleReferences(this.getInputControls(), importHandler));
        ru.setMainReport(importHandler.handleReference(this.getMainReport()));
        List<ResourceReference> rs = this.handleReferences(this.getResources(), importHandler);
        if (ru.getResources() == null) {
            ru.setResources(rs);
        } else if (rs != null) {
            ru.getResources().addAll(rs);
        }
        ru.setInputControlRenderingView(this.getInputControlRenderingView());
        ru.setReportRenderingView(this.getReportRenderingView());
        ru.setAlwaysPromptControls(this.isAlwaysPromptControls());
        ru.setControlsLayout(this.getControlsLayout());
        this.copyDataSnapshotTo(importHandler, ru);
    }

    protected void copyDataSnapshotTo(ResourceImportHandler importHandler, ReportUnit ru) {
        if (this.dataSnapshotMetadata == null) {
            ru.setDataSnapshotId(null);
        } else {
            DataSnapshotService snapshotService = this.getSnapshotService(importHandler.getConfiguration());
            if (!snapshotService.isSnapshotPersistenceEnabled()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("data snapshot persistencee disabled, not importing snapshot for report " + ru.getURIString()));
                }
                ru.setDataSnapshotId(null);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("importing data snapshot for report " + ru.getURIString()));
            }
            Map<String, Object> parametersMap = this.dataSnapshotMetadata.getParametersMap(ru, importHandler);
            DefaultDataCacheSnapshotMetadata metadata = new DefaultDataCacheSnapshotMetadata(parametersMap, this.dataSnapshotMetadata.getSnapshotDate());
            byte[] snapshotBytes = importHandler.handleData(this, this.snapshotDataFileName(ru), null);
            MemoryDataContainer snapshotData = new MemoryDataContainer(snapshotBytes);
            DataCacheSnapshotData dataSnapshot = new DataCacheSnapshotData();
            dataSnapshot.setMetadata((DataCacheSnapshotMetadata)metadata);
            dataSnapshot.setSnapshotData((DataContainer)snapshotData);
            long snapshotId = snapshotService.saveDataSnapshot(importHandler.getExecutionContext(), dataSnapshot);
            ru.setDataSnapshotId(Long.valueOf(snapshotId));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("saved data snapshot " + snapshotId + " for report " + ru.getURIString()));
            }
        }
    }

    public ResourceReferenceBean getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ResourceReferenceBean dataSource) {
        this.dataSource = dataSource;
    }

    public ResourceReferenceBean getQuery() {
        return this.query;
    }

    public void setQuery(ResourceReferenceBean query) {
        this.query = query;
    }

    public ResourceReferenceBean[] getInputControls() {
        return this.inputControls;
    }

    public void setInputControls(ResourceReferenceBean[] inputControls) {
        this.inputControls = inputControls;
    }

    public ResourceReferenceBean getMainReport() {
        return this.mainReport;
    }

    public void setMainReport(ResourceReferenceBean mainReport) {
        this.mainReport = mainReport;
    }

    public ResourceReferenceBean[] getResources() {
        return this.resources;
    }

    public void setResources(ResourceReferenceBean[] resources) {
        this.resources = resources;
    }

    public boolean isAlwaysPromptControls() {
        return this.alwaysPromptControls;
    }

    public void setAlwaysPromptControls(boolean alwaysPromptControls) {
        this.alwaysPromptControls = alwaysPromptControls;
    }

    public byte getControlsLayout() {
        return this.controlsLayout;
    }

    public void setControlsLayout(byte controlsLayout) {
        this.controlsLayout = controlsLayout;
    }

    public String getInputControlRenderingView() {
        return this.inputControlRenderingView;
    }

    public void setInputControlRenderingView(String inputControlRenderingView) {
        this.inputControlRenderingView = inputControlRenderingView;
    }

    public String getReportRenderingView() {
        return this.reportRenderingView;
    }

    public void setReportRenderingView(String reportRenderingView) {
        this.reportRenderingView = reportRenderingView;
    }

    public DataSnapshotMetadataBean getDataSnapshotMetadata() {
        return this.dataSnapshotMetadata;
    }

    public void setDataSnapshotMetadata(DataSnapshotMetadataBean dataSnapshotMetadata) {
        this.dataSnapshotMetadata = dataSnapshotMetadata;
    }
}

