/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.export.modules.repository.RepositoryExportFilter;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryExportPathFilter
implements RepositoryExportFilter {
    private static final Log log = LogFactory.getLog(RepositoryExportPathFilter.class);
    private String[] excludeContentsFolderPatterns;
    private Pattern[] excludeContentsFolderCompiledPatterns;

    public String[] getExcludeContentsFolderPatterns() {
        return this.excludeContentsFolderPatterns;
    }

    public void setExcludeContentsFolderPatterns(String[] excludeContentsFolderPatterns) {
        this.excludeContentsFolderPatterns = excludeContentsFolderPatterns;
        this.compileExcludeContentsFolderPatterns();
    }

    protected void compileExcludeContentsFolderPatterns() {
        if (this.excludeContentsFolderPatterns == null || this.excludeContentsFolderPatterns.length == 0) {
            this.excludeContentsFolderCompiledPatterns = null;
        } else {
            this.excludeContentsFolderCompiledPatterns = new Pattern[this.excludeContentsFolderPatterns.length];
            for (int i = 0; i < this.excludeContentsFolderPatterns.length; ++i) {
                this.excludeContentsFolderCompiledPatterns[i] = this.compilePattern(this.excludeContentsFolderPatterns[i]);
            }
        }
    }

    protected Pattern compilePattern(String pattern) {
        return Pattern.compile(pattern);
    }

    @Override
    public boolean toExportContents(Folder folder) {
        if (this.excludeContentsFolderCompiledPatterns == null) {
            return true;
        }
        String folderPath = folder.getURIString();
        for (int i = 0; i < this.excludeContentsFolderCompiledPatterns.length; ++i) {
            Pattern pattern = this.excludeContentsFolderCompiledPatterns[i];
            if (!pattern.matcher(folderPath).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Folder path " + folderPath + " matched exclude contents pattern " + pattern));
            }
            return false;
        }
        return true;
    }
}

