/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Connection;
import mondrian.olap.Exp;
import mondrian.olap.FunTable;
import mondrian.olap.Parser;
import mondrian.olap.Query;
import mondrian.olap.QueryPart;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import org.apache.log4j.Logger;

public abstract class ConnectionBase
implements Connection {
    public static void memoryUsageNotification(Query query, String msg) {
        query.setOutOfMemory(msg);
    }

    protected ConnectionBase() {
    }

    protected abstract Logger getLogger();

    public String getFullConnectString() {
        String s = this.getConnectString();
        String catalogName = this.getCatalogName();
        if (catalogName != null) {
            int len = s.length() + catalogName.length() + 32;
            StringBuilder buf = new StringBuilder(len);
            buf.append(s);
            if (!s.endsWith(";")) {
                buf.append(';');
            }
            buf.append("Initial Catalog=");
            buf.append(catalogName);
            buf.append(';');
            s = buf.toString();
        }
        return s;
    }

    public QueryPart parseStatement(String query) {
        return this.parseStatement(query, null, false);
    }

    public Query parseQuery(String query) {
        return (Query)this.parseStatement(query);
    }

    public Query parseQuery(String query, boolean load) {
        return (Query)this.parseStatement(query, null, false);
    }

    public QueryPart parseStatement(String query, FunTable funTable, boolean strictValidation) {
        Parser parser = new Parser();
        boolean debug = false;
        if (funTable == null) {
            funTable = this.getSchema().getFunTable();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(Util.nl + query));
        }
        try {
            return parser.parseInternal(this, query, debug, funTable, strictValidation);
        }
        catch (Exception e) {
            throw MondrianResource.instance().FailedToParseQuery.ex(query, e);
        }
    }

    public Exp parseExpression(String expr) {
        boolean debug = false;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(Util.nl + expr));
        }
        try {
            Parser parser = new Parser();
            FunTable funTable = this.getSchema().getFunTable();
            return parser.parseExpression(this, expr, debug, funTable);
        }
        catch (Throwable exception) {
            throw MondrianResource.instance().FailedToParseQuery.ex(expr, exception);
        }
    }
}

