/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.remote.exception.AccessDeniedException;
import com.jaspersoft.jasperserver.remote.exception.FolderNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceAlreadyExistsException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.services.SingleRepositoryService;
import java.util.Date;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.security.SpringSecurityException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="singleRepositoryService")
@Transactional(rollbackFor={Exception.class})
public class SingleRepositoryServiceImpl
implements SingleRepositoryService {
    private Pattern nameWithNumber = Pattern.compile("^.*_\\d+$", 2);
    @Resource(name="concreteRepository")
    protected RepositoryService repositoryService;

    @Override
    public com.jaspersoft.jasperserver.api.metadata.common.domain.Resource getResource(String uri) throws ResourceNotFoundException {
        return this.getResourceInternal(uri, false);
    }

    @Override
    public void deleteResource(String uri) throws IllegalParameterValueException, AccessDeniedException {
        if (uri == null || "".equals(uri) || "/".equals(uri)) {
            throw new IllegalParameterValueException("uri", uri);
        }
        try {
            com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.repositoryService.getResource(null, uri);
            if (resource != null) {
                this.repositoryService.deleteResource(null, uri);
            } else {
                resource = this.repositoryService.getFolder(null, uri);
                if (resource != null) {
                    this.repositoryService.deleteFolder(null, uri);
                }
            }
        }
        catch (SpringSecurityException sse) {
            throw new AccessDeniedException(uri);
        }
    }

    @Override
    public com.jaspersoft.jasperserver.api.metadata.common.domain.Resource createResource(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource serverResource, String parentUri, String accept, boolean createFolders) throws RemoteException {
        if (createFolders) {
            this.ensureFolderUri(parentUri);
        } else if (!this.repositoryService.folderExists(null, parentUri)) {
            throw new FolderNotFoundException(parentUri);
        }
        serverResource.setParentFolder(parentUri);
        serverResource.setName(this.generateName(parentUri, serverResource.getLabel()));
        if (serverResource instanceof Folder) {
            this.repositoryService.saveFolder(null, (Folder)serverResource);
        } else {
            this.repositoryService.saveResource(null, serverResource);
        }
        return this.getResource(serverResource.getURIString());
    }

    @Override
    public void copyResource(String sourceUri, String destinationUri, boolean createFolders, boolean overwrite) throws ResourceNotFoundException, AccessDeniedException, ResourceAlreadyExistsException, IllegalParameterValueException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.prepareToOperation(sourceUri, destinationUri, createFolders, overwrite);
        resource.setParentFolder(destinationUri);
        if (resource instanceof Folder) {
            this.repositoryService.copyFolder(null, sourceUri, resource.getURIString());
        } else {
            this.repositoryService.copyResource(null, sourceUri, resource.getURIString());
        }
    }

    @Override
    public void moveResource(String sourceUri, String destinationUri, boolean createFolders, boolean overwrite) throws ResourceNotFoundException, AccessDeniedException, ResourceAlreadyExistsException, IllegalParameterValueException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.prepareToOperation(sourceUri, destinationUri, createFolders, overwrite);
        resource.setParentFolder(destinationUri);
        if (resource instanceof Folder) {
            this.repositoryService.moveFolder(null, sourceUri, resource.getURIString());
        } else {
            this.repositoryService.moveResource(null, sourceUri, resource.getURIString());
        }
    }

    protected com.jaspersoft.jasperserver.api.metadata.common.domain.Resource getResourceInternal(String uri, boolean tolerateAbsence) throws ResourceNotFoundException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.repositoryService.getResource(null, uri);
        if (resource == null) {
            resource = this.repositoryService.getFolder(null, uri);
        }
        if (resource == null && !tolerateAbsence) {
            throw new ResourceNotFoundException(uri);
        }
        return resource;
    }

    private com.jaspersoft.jasperserver.api.metadata.common.domain.Resource prepareToOperation(String sourceUri, String destinationUri, boolean createFolders, boolean overwrite) throws ResourceNotFoundException, AccessDeniedException, ResourceAlreadyExistsException, IllegalParameterValueException {
        if (sourceUri == null || "".equals(sourceUri)) {
            throw new IllegalParameterValueException("sourceUri", sourceUri);
        }
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.getResourceInternal(sourceUri, false);
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource existing = null;
        String newUri = (destinationUri.endsWith("/") ? destinationUri : destinationUri + "/") + resource.getName();
        existing = this.getResourceInternal(newUri, true);
        if (existing != null) {
            if (overwrite) {
                this.deleteResource(newUri);
            } else {
                throw new ResourceAlreadyExistsException(newUri);
            }
        }
        if (createFolders) {
            this.ensureFolderUri(destinationUri);
        } else if (!this.repositoryService.folderExists(null, destinationUri)) {
            throw new FolderNotFoundException(destinationUri);
        }
        return resource;
    }

    private Folder ensureFolderUri(String uri) throws AccessDeniedException, ResourceAlreadyExistsException {
        try {
            Folder folder = this.repositoryService.getFolder(null, uri);
            if (folder == null) {
                if (this.repositoryService.getResource(null, uri) != null) {
                    throw new ResourceAlreadyExistsException(uri);
                }
                int lastSeparator = uri.lastIndexOf("/");
                String label = uri.substring(lastSeparator + 1, uri.length());
                folder = new FolderImpl();
                folder.setParentFolder(this.ensureFolderUri(uri.substring(0, lastSeparator)));
                folder.setName(this.generateName(uri.substring(0, lastSeparator), label.toLowerCase().replace("\\w", "_")));
                folder.setLabel(label);
                folder.setCreationDate(new Date());
                this.repositoryService.saveFolder(null, folder);
            }
            return folder;
        }
        catch (SpringSecurityException spe) {
            throw new AccessDeniedException("Access denied", uri);
        }
    }

    private String generateName(String parentUri, String label) {
        String uri = parentUri + "/" + label;
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.repositoryService.getResource(null, uri);
        if (resource == null) {
            resource = this.repositoryService.getFolder(null, uri);
        }
        if (resource != null) {
            if (this.nameWithNumber.matcher(label).matches()) {
                int divider = label.lastIndexOf("_");
                Integer number = Integer.parseInt(label.substring(divider + 1)) + 1;
                label = label.substring(0, divider + 1) + number.toString();
            } else {
                label = label.concat("_1");
            }
            label = this.generateName(parentUri, label);
        }
        return label;
    }
}

