/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportExecutionStatusInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.SchedulerReportExecutionStatusSearchCriteria;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.services.ExecutionStatus;
import com.jaspersoft.jasperserver.remote.services.ExportExecution;
import com.jaspersoft.jasperserver.remote.services.ExportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportExecution;
import com.jaspersoft.jasperserver.remote.services.ReportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportExecutor;
import com.jaspersoft.jasperserver.remote.services.ReportOutputPages;
import com.jaspersoft.jasperserver.remote.services.ReportOutputResource;
import com.jaspersoft.jasperserver.remote.services.RunReportService;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import com.jaspersoft.jasperserver.war.action.ReportParametersUtils;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlsLogicService;
import com.jaspersoft.jasperserver.war.cascade.InputControlsValidationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.GenericElementReportTransformer;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Service;

@Service(value="runReportService")
@Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class RunReportServiceImpl
implements RunReportService {
    private static final Log log = LogFactory.getLog(RunReportServiceImpl.class);
    @Resource
    private AuditHelper auditHelper;
    @Resource
    private ServicesUtils servicesUtils;
    @Resource(name="concreteEngineService")
    private EngineService engine;
    @Resource
    private InputControlsLogicService inputControlsLogicService;
    @Resource
    private ReportExecutor reportExecutor;
    private final Map<String, ReportExecution> executions = new ConcurrentHashMap<String, ReportExecution>();

    @Override
    public ReportExecution getReportExecution(String requestId) throws ResourceNotFoundException {
        ReportUnitResult reportUnitResult;
        ReportExecution execution = this.executions.get(requestId);
        ReportUnitResult reportUnitResult2 = reportUnitResult = execution != null ? execution.getReportUnitResult() : null;
        if (reportUnitResult != null) {
            ExecutionStatus executionStatus = null;
            ReportExecutionStatus reportStatus = reportUnitResult.getJasperPrintAccessor().getReportStatus();
            ReportExecutionStatus.Status status = reportStatus.getStatus();
            switch (status) {
                case CANCELED: {
                    executionStatus = ExecutionStatus.cancelled;
                    break;
                }
                case ERROR: {
                    executionStatus = ExecutionStatus.failed;
                    execution.setErrorDescriptor(new ErrorDescriptor(reportStatus.getError()));
                    break;
                }
                case FINISHED: {
                    executionStatus = ExecutionStatus.ready;
                    execution.setTotalPages(reportStatus.getTotalPageCount());
                    break;
                }
                case RUNNING: {
                    executionStatus = ExecutionStatus.execution;
                    execution.setCurrentPage(reportStatus.getCurrentPageCount());
                }
            }
            execution.setStatus(executionStatus);
            return execution;
        }
        throw new ResourceNotFoundException(requestId);
    }

    @Override
    public ReportExecution getReportExecutionFromRawParameters(String reportUnitURI, Map<String, String[]> rawParameters, ReportExecutionOptions inputOptions, ExportExecutionOptions exportOptions) throws RemoteException, JSValidationException {
        Map<String, Object> convertedParameters;
        if (exportOptions == null || exportOptions.getOutputFormat() == null) {
            throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("export.parameters.missing").setMessage("Output format must be specified").getErrorDescriptor());
        }
        ReportExecutionOptions options = inputOptions != null ? inputOptions : new ReportExecutionOptions();
        try {
            convertedParameters = this.executeInputControlsCascadeWithRawInput(reportUnitURI, rawParameters);
            for (String currentKey : rawParameters.keySet()) {
                Object valueToForward;
                String[] currentValue = rawParameters.get(currentKey);
                if (currentValue == null || convertedParameters.containsKey(currentKey)) continue;
                if (currentValue.length == 1) {
                    valueToForward = currentValue[0];
                } else {
                    ArrayList<String> collection = new ArrayList<String>();
                    collection.addAll(Arrays.asList(currentValue));
                    valueToForward = collection;
                }
                convertedParameters.put(currentKey, valueToForward);
            }
        }
        catch (CascadeResourceNotFoundException e) {
            throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
        }
        catch (InputControlsValidationException e) {
            throw new JSValidationException(e.getErrors());
        }
        ReportUnitResult reportUnitResult = this.reportExecutor.runReport(reportUnitURI, convertedParameters, options);
        String requestId = reportUnitResult.getRequestId();
        ReportExecution execution = new ReportExecution();
        execution.setReportUnitResult(reportUnitResult);
        this.executions.put(requestId, execution);
        execution.setRawParameters(rawParameters);
        execution.setOptions(options);
        ExportExecution exportExecution = this.executeExport(exportOptions, execution);
        if (!options.isAsync().booleanValue()) {
            exportExecution.getFinalOutputResource();
        }
        return this.getReportExecution(requestId);
    }

    @Override
    public ExportExecution executeExport(String executionId, ExportExecutionOptions exportOptions) throws RemoteException {
        ReportExecution execution = this.executions.get(executionId);
        if (execution == null) {
            throw new ResourceNotFoundException(executionId);
        }
        return this.executeExport(exportOptions, execution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExportExecution executeExport(ExportExecutionOptions exportOptions, final ReportExecution reportExecution) throws RemoteException {
        ExportExecution runningExport = reportExecution.getExports().get(exportOptions);
        if (runningExport == null) {
            Boolean startExport = false;
            ReportExecution reportExecution2 = reportExecution;
            synchronized (reportExecution2) {
                runningExport = reportExecution.getExports().get(exportOptions);
                if (runningExport == null) {
                    runningExport = new ExportExecution();
                    runningExport.setStatus(ExecutionStatus.queued);
                    runningExport.setOptions(exportOptions);
                    reportExecution.getExports().put(exportOptions, runningExport);
                    startExport = true;
                }
            }
            if (startExport.booleanValue()) {
                String attachmentsPrefix;
                final ExportExecution executionClosure = runningExport;
                final ReportExecutionOptions options = reportExecution.getOptions();
                String string = attachmentsPrefix = exportOptions.getAttachmentsPrefix() != null ? exportOptions.getAttachmentsPrefix() : options.getDefaultAttachmentsPrefixTemplate();
                if (attachmentsPrefix != null) {
                    attachmentsPrefix = attachmentsPrefix.replace("{contextPath}", options.getContextPath() != null ? options.getContextPath() : "").replace("{reportExecutionId}", reportExecution.getRequestId()).replace("{exportOptions}", exportOptions.toString());
                }
                final String attachmentsPrefixClosure = attachmentsPrefix;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        RunReportServiceImpl.this.executeExport(executionClosure, reportExecution.getReportURI(), reportExecution.getReportUnitResult().getJasperPrintAccessor(), attachmentsPrefixClosure, reportExecution.getRawParameters(), options);
                    }
                }).start();
            }
        }
        return runningExport;
    }

    protected void executeExport(ExportExecution exportExecution, String reportUnitURI, JasperPrintAccessor jasperPrintAccessor, String imagesUri, Map<String, String[]> rawParameters, ReportExecutionOptions options) {
        try {
            JasperPrint jasperPrint;
            ExportExecutionOptions exportOptions = exportExecution.getOptions();
            Integer exportStartPage = null;
            if (exportOptions.getPages() != null) {
                Integer n = exportStartPage = exportOptions.getPages().getPage() != null ? exportOptions.getPages().getPage() : exportOptions.getPages().getEndPage();
            }
            if (exportStartPage != null) {
                exportStartPage = exportStartPage - 1;
                jasperPrintAccessor.pageStatus(exportStartPage.intValue(), null);
                jasperPrint = jasperPrintAccessor.getJasperPrint();
            } else {
                jasperPrint = jasperPrintAccessor.getFinalJasperPrint();
            }
            exportExecution.setStatus(ExecutionStatus.execution);
            this.generateReportOutput(reportUnitURI, jasperPrint, exportExecution.getOptions().getOutputFormat(), imagesUri, exportExecution, rawParameters, exportExecution.getOptions().getPages(), options);
            exportExecution.setStatus(ExecutionStatus.ready);
        }
        catch (RemoteException ex) {
            exportExecution.setStatus(ExecutionStatus.failed);
            exportExecution.setErrorDescriptor(ex.getErrorDescriptor());
        }
        catch (Exception ex) {
            log.error((Object)"Unexpected error occurs during export", (Throwable)ex);
            exportExecution.setStatus(ExecutionStatus.failed);
            exportExecution.setErrorDescriptor(new ErrorDescriptor(ex));
        }
    }

    @Override
    public ReportOutputResource getOutputResource(String executionId, ExportExecutionOptions exportExecutionOptions) throws RemoteException {
        ReportExecution execution = this.executions.get(executionId);
        if (execution == null) {
            throw new ResourceNotFoundException(executionId);
        }
        return this.executeExport(exportExecutionOptions, execution).getFinalOutputResource();
    }

    @Override
    public ReportOutputResource getAttachment(String executionId, ExportExecutionOptions exportOptions, String attachmentName) throws ResourceNotFoundException {
        ReportOutputResource outputResource = this.getExportExecution(executionId, exportOptions).getAttachments().get(attachmentName);
        if (outputResource == null) {
            throw new ResourceNotFoundException(attachmentName);
        }
        return outputResource;
    }

    @Override
    public ExportExecution getExportExecution(String executionId, ExportExecutionOptions exportOptions) throws ResourceNotFoundException {
        ReportExecution execution = this.executions.get(executionId);
        if (execution == null) {
            throw new ResourceNotFoundException(executionId);
        }
        ExportExecution exportExecution = execution.getExports().get(exportOptions);
        if (exportExecution == null) {
            throw new ResourceNotFoundException(exportOptions.toString());
        }
        return exportExecution;
    }

    @Override
    public ReportOutputResource getReportOutputFromRawParameters(String reportUnitURI, Map<String, String[]> rawParameters, ReportExecutionOptions executionOptions, ExportExecutionOptions exportOptions) throws RemoteException {
        ReportExecution execution = this.getReportExecutionFromRawParameters(reportUnitURI, rawParameters, executionOptions, exportOptions);
        return this.getOutputResource(execution.getRequestId(), exportOptions);
    }

    @Override
    public ReportOutputResource getReportOutputFromRawParameters(String reportUnitURI, String outputFormat, Boolean ignorePagination, String attachmentsPrefix, Integer page, String transformerKey, Map<String, String[]> rawParameters, Boolean avoidCache, Boolean freshData, Boolean saveDataSnapshot, Boolean interactive) throws RemoteException {
        ReportExecutionOptions options = new ReportExecutionOptions().setIgnorePagination(ignorePagination != null ? ignorePagination : false).setTransformerKey(transformerKey).setFreshData(freshData != null ? freshData : false).setSaveDataSnapshot(saveDataSnapshot != null ? saveDataSnapshot : false).setInteractive(interactive != null ? interactive : false);
        ExportExecutionOptions exportOptions = new ExportExecutionOptions().setPages(new ReportOutputPages().setPage(page)).setAttachmentsPrefix(attachmentsPrefix);
        return this.getReportOutputFromRawParameters(reportUnitURI, rawParameters, options, exportOptions);
    }

    protected Map<String, Object> executeInputControlsCascadeWithRawInput(String reportUnitUri, Map<String, String[]> rawInputParameters) throws CascadeResourceNotFoundException, InputControlsValidationException {
        List valuesForInputControls = this.inputControlsLogicService.getValuesForInputControls(reportUnitUri, null, rawInputParameters);
        Map inputControlFormattedValues = ReportParametersUtils.getValueMapFromInputControlStates((List)valuesForInputControls);
        return this.inputControlsLogicService.getTypedParameters(reportUnitUri, inputControlFormattedValues);
    }

    protected void generateReportOutput(String reportUnitURI, JasperPrint jasperPrint, String rawOutputFormat, String imagesURI, ExportExecution exportExecution, Map<String, String[]> rawParameters, ReportOutputPages pages, ReportExecutionOptions reportExecutionOptions) throws RemoteException {
        long currentTime;
        block22: {
            currentTime = System.currentTimeMillis();
            this.auditHelper.createAuditEvent("runReport");
            try {
                Map<JRExporterParameter, Object> exporterParams;
                String outputFormat = rawOutputFormat != null ? rawOutputFormat.toUpperCase() : "PDF";
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                if (outputFormat.equals("JRPRINT")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Returning JasperPrint");
                    }
                    if (reportExecutionOptions.getTransformerKey() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Transforming JasperPrint generic element for key " + reportExecutionOptions.getTransformerKey()));
                        }
                        GenericElementReportTransformer.transformGenericElements((JasperReportsContext)this.reportExecutor.getJasperReportsContext(reportExecutionOptions.isInteractive()), (JasperPrint)jasperPrint, (String)reportExecutionOptions.getTransformerKey());
                    }
                    JRSaver.saveObject((Object)jasperPrint, (OutputStream)bos);
                    exportExecution.setOutputResource(new ReportOutputResource("application/octet-stream", bos.toByteArray()));
                    break block22;
                }
                HashMap<String, String[]> exportParameters = new HashMap<String, String[]>(rawParameters);
                if (pages != null) {
                    exportParameters.put("OUTPUT_PAGES", (String[])pages);
                }
                if (imagesURI != null) {
                    exportParameters.put("IMAGES_URI", (String[])imagesURI);
                }
                exportParameters.put("contextPath", (String[])(reportExecutionOptions.getContextPath() != null ? reportExecutionOptions.getContextPath() : ""));
                try {
                    exporterParams = this.reportExecutor.exportReport(reportUnitURI, jasperPrint, outputFormat, bos, exportParameters);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporter params: " + Arrays.asList(exporterParams.keySet().toArray())));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error exporting report", (Throwable)e);
                    throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorExportingReportUnit").setParameters(e.getMessage()).getErrorDescriptor(), (Throwable)e);
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ex) {
                            log.error((Object)("caught exception: " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                }
                exportExecution.setOutputResource(new ReportOutputResource(this.reportExecutor.getContentType(outputFormat), bos.toByteArray()));
                if ("HTML".equals(outputFormat)) {
                    this.putImages(exporterParams, exportExecution.getAttachments());
                }
            }
            catch (RemoteException e) {
                this.auditHelper.addExceptionToAllAuditEvents(e);
                throw e;
            }
            catch (ServiceException e) {
                log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
                this.auditHelper.addExceptionToAllAuditEvents((Throwable)((Object)e));
            }
            catch (Throwable e) {
                log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
                this.auditHelper.addExceptionToAllAuditEvents(e);
            }
        }
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
    }

    protected void putImages(Map<JRExporterParameter, Object> exportParameters, Map<String, ReportOutputResource> outputContainer) throws RemoteException {
        try {
            Map imagesMap = (Map)exportParameters.get(JRHtmlExporterParameter.IMAGES_MAP);
            if (imagesMap != null && !imagesMap.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("imagesMap : " + Arrays.asList(imagesMap.keySet().toArray())));
                }
                for (String name : imagesMap.keySet()) {
                    byte[] data = (byte[])imagesMap.get(name);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding image for HTML: " + name));
                    }
                    outputContainer.put(name, new ReportOutputResource(JRTypeSniffer.getImageTypeValue((byte[])data).getMimeType(), data, name));
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorAddingImage").setParameters(e.getMessage()).getErrorDescriptor(), e);
        }
    }

    @Override
    public Set<ReportExecutionStatusInformation> getCurrentlyRunningReports(SchedulerReportExecutionStatusSearchCriteria searchCriteria) {
        List reportExecutionStatusList;
        HashSet result = null;
        List list = reportExecutionStatusList = searchCriteria != null ? this.engine.getSchedulerReportExecutionStatusList(searchCriteria) : this.engine.getReportExecutionStatusList();
        if (reportExecutionStatusList != null && !reportExecutionStatusList.isEmpty()) {
            result = new HashSet();
            result.addAll(reportExecutionStatusList);
        }
        return result;
    }

    @Override
    public Boolean cancelReportExecution(String requestId) throws RemoteException {
        return this.engine.cancelExecution(requestId);
    }
}

