/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import com.jaspersoft.jasperserver.remote.services.LegacyRunReportService;
import com.jaspersoft.jasperserver.remote.services.ReportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportExecutor;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import com.jaspersoft.jasperserver.war.action.ReportParametersUtils;
import com.jaspersoft.jasperserver.war.cascade.InputControlsLogicService;
import com.jaspersoft.jasperserver.ws.xml.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.annotation.Resource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.GenericElementReportTransformer;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="legacyRunReportService")
@Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class LegacyRunReportServiceImpl
implements LegacyRunReportService {
    private static final Log log = LogFactory.getLog(LegacyRunReportServiceImpl.class);
    private static final String KEY_JASPER_PRINT_RESOURCE = "jasperPrint";
    @Resource
    private AuditHelper auditHelper;
    @Resource
    private ReportExecutor reportExecutor;
    @Autowired
    private MessageSource messageSource;
    @Resource
    private ServicesUtils servicesUtils;
    @Resource
    private InputControlsLogicService inputControlsLogicService;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, Map<String, DataSource>> outputAttachments = new HashMap<String, Map<String, DataSource>>();
    private final Map<String, DataSource> inputAttachments = new HashMap<String, DataSource>();

    @Override
    public Map<String, DataSource> getInputAttachments() {
        return this.inputAttachments;
    }

    @Override
    public synchronized Map<String, DataSource> getReportAttachments(String reportName) {
        if (this.outputAttachments.get(reportName) == null) {
            this.outputAttachments.put(reportName, new HashMap());
        }
        return this.outputAttachments.get(reportName);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public OperationResult runReport(String reportUnitURI, Map<String, Object> parameters, Map<String, String> arguments) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.auditHelper.createAuditEvent("runReport");
        OperationResult or = this.servicesUtils.createOperationResult(0, null);
        try {
            ReportExecutionOptions executionOptions = new ReportExecutionOptions();
            executionOptions.setFreshData(Boolean.parseBoolean(arguments.get("FRESH_DATA")));
            executionOptions.setSaveDataSnapshot(Boolean.parseBoolean(arguments.get("SAVE_DATA_SNAPSHOT")));
            executionOptions.setInteractive(Boolean.parseBoolean(arguments.get("interactive")));
            HashMap rawParameters = parameters == null || parameters.isEmpty() ? new HashMap() : this.inputControlsLogicService.formatTypedParameters(reportUnitURI, parameters);
            List valuesForInputControls = this.inputControlsLogicService.getValuesForInputControls(reportUnitURI, null, rawParameters);
            Map inputControlFormattedValues = ReportParametersUtils.getValueMapFromInputControlStates((List)valuesForInputControls);
            Map runtimeParameters = this.inputControlsLogicService.getTypedParameters(reportUnitURI, inputControlFormattedValues);
            for (String currentKey : parameters.keySet()) {
                Object currentValue = parameters.get(currentKey);
                if (currentValue == null || currentValue.equals(runtimeParameters.get(currentKey))) continue;
                runtimeParameters.put(currentKey, parameters.get(currentKey));
            }
            ReportUnitResult result = this.reportExecutor.runReport(reportUnitURI, runtimeParameters, executionOptions);
            if (result == null) {
                throw new ServiceException(5, this.messageSource.getMessage("webservices.error.errorExecutingReportUnit", new Object[]{reportUnitURI}, LocaleContextHolder.getLocale()));
            }
            JasperPrint jasperPrint = result.getJasperPrint();
            or = this.exportReport(reportUnitURI, jasperPrint, arguments);
            this.getAttributes().put(KEY_JASPER_PRINT_RESOURCE, jasperPrint);
            if (or.getReturnCode() != 0) {
                this.auditHelper.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (ServiceException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents((Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents(e);
        }
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return or;
    }

    @Override
    public OperationResult exportReport(String reportUnitURI, JasperPrint jasperPrint, Map<String, String> arguments) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.auditHelper.createAuditEvent("runReport");
        OperationResult or = this.servicesUtils.createOperationResult(0, null);
        try {
            String format = arguments.get("RUN_OUTPUT_FORMAT");
            if (format == null) {
                format = "PDF";
            }
            format = format.toUpperCase();
            String transformerKey = arguments.get("TRANSFORMER_KEY");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (format.equals("JRPRINT")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Returning JasperPrint");
                }
                if (transformerKey != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Transforming JasperPrint generic element for key " + transformerKey));
                    }
                    JasperReportsContext jasperReportsContext = this.reportExecutor.getJasperReportsContext(Boolean.parseBoolean(arguments.get("interactive")));
                    GenericElementReportTransformer.transformGenericElements((JasperReportsContext)jasperReportsContext, (JasperPrint)jasperPrint, (String)transformerKey);
                }
                JRSaver.saveObject((Object)jasperPrint, (OutputStream)bos);
                ByteArrayDataSource bads = new ByteArrayDataSource(bos.toByteArray());
                this.getReportAttachments(reportUnitURI).put(KEY_JASPER_PRINT_RESOURCE, (DataSource)bads);
            } else {
                Map<JRExporterParameter, Object> exporterParams;
                HashMap<String, String> exportParameters = new HashMap<String, String>();
                String value = arguments.get("PAGE");
                if (value != null) {
                    exportParameters.put("PAGE", value);
                }
                if ((value = arguments.get("IMAGES_URI")) != null) {
                    exportParameters.put("IMAGES_URI", value);
                }
                try {
                    exporterParams = this.reportExecutor.exportReport(reportUnitURI, jasperPrint, format, bos, exportParameters);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporter params: " + Arrays.asList(exporterParams.keySet().toArray())));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error exporting report", (Throwable)e);
                    throw new ServiceException(4, this.messageSource.getMessage("webservices.error.errorExportingReportUnit", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale()));
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ex) {
                            log.error((Object)("caught exception: " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                }
                ByteArrayDataSource bads = new ByteArrayDataSource(bos.toByteArray(), this.reportExecutor.getContentType(format));
                this.getReportAttachments(reportUnitURI).put("report", (DataSource)bads);
                this.addAdditionalAttachmentsForReport(format, exporterParams, reportUnitURI);
            }
            if (or.getReturnCode() != 0) {
                this.auditHelper.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (ServiceException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents((Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents(e);
        }
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return or;
    }

    private void addAdditionalAttachmentsForReport(String format, Map<JRExporterParameter, Object> exportParameters, String reportUri) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Format requested: " + format + "  " + "HTML"));
        }
        if (!format.equals("HTML")) {
            return;
        }
        try {
            Map imagesMap = (Map)exportParameters.get(JRHtmlExporterParameter.IMAGES_MAP);
            if (log.isDebugEnabled()) {
                log.debug((Object)("imagesMap : " + Arrays.asList(imagesMap.keySet().toArray())));
            }
            for (String name : imagesMap.keySet()) {
                byte[] data = (byte[])imagesMap.get(name);
                String mimeType = JRTypeSniffer.getImageTypeValue((byte[])data).getMimeType();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding image for HTML: " + name + ", type: " + mimeType));
                }
                ByteArrayDataSource bads = new ByteArrayDataSource(data, mimeType);
                this.getReportAttachments(reportUri).put(name, (DataSource)bads);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new ServiceException(4, this.messageSource.getMessage("webservices.error.errorAddingImage", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale()));
        }
    }
}

