/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.remote.exception.AccessDeniedException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.services.BatchRepositoryService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.security.SpringSecurityException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class BatchRepositoryServiceImpl
implements BatchRepositoryService {
    @Resource(name="concreteRepository")
    private RepositoryService service;

    @Override
    public void deleteResources(List<String> uris) throws AccessDeniedException, ResourceNotFoundException {
        for (String uri : uris) {
            try {
                com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.service.getResource(null, uri);
                if (resource != null) {
                    this.service.deleteResource(null, uri);
                    continue;
                }
                resource = this.service.getFolder(null, uri);
                if (resource == null) continue;
                this.service.deleteFolder(null, uri);
            }
            catch (SpringSecurityException sse) {
                throw new AccessDeniedException(uri);
            }
        }
    }
}

