/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.AttributesRemoteService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="attributesRemoteService")
public class AttributesRemoteServiceImpl
implements AttributesRemoteService {
    private static final Log log = LogFactory.getLog(AttributesRemoteServiceImpl.class);
    @Resource(name="concreteUserAuthorityService")
    private UserAuthorityService userAuthorityService;
    @Resource
    private ProfileAttributeService profileAttributeService;

    public void setProfileAttributeService(ProfileAttributeService profileAttributeService) {
        this.profileAttributeService = profileAttributeService;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    @Override
    public void deleteAttribute(String userName, ProfileAttribute pa) {
        User user = this.userAuthorityService.getUser(null, userName);
        if (user == null) {
            throw new ServiceException(404, "user: " + userName + " not found ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("user " + user.getUsername() + " was found"));
        }
        List l = this.profileAttributeService.getProfileAttributesForPrincipal(null, (Object)user);
        for (ProfileAttribute att : l) {
            if (!att.getAttrName().equals(pa.getAttrName())) continue;
            att.setPrincipal((Object)user);
            this.profileAttributeService.deleteProfileAttribute(null, att);
            if (log.isDebugEnabled()) {
                log.debug((Object)("attribute " + pa.getAttrName() + " was deleted successfully from " + userName));
            }
            return;
        }
        throw new ServiceException(404, "attribute with key=" + pa.getAttrName() + " does not exist");
    }

    @Override
    public String getAttribute(String attName) throws ServiceException {
        return this.profileAttributeService.getCurrentUserPreferenceValue(attName);
    }

    @Override
    public List<ProfileAttribute> getAttributesOfUser(String userName) throws ServiceException {
        User user = this.userAuthorityService.getUser(null, userName);
        if (user == null) {
            throw new ServiceException(404, "resource.not.found");
        }
        return this.profileAttributeService.getProfileAttributesForPrincipal(null, (Object)user);
    }

    @Override
    public void putAttribute(String userName, ProfileAttribute pa) {
        User user = this.userAuthorityService.getUser(null, userName);
        if (user == null) {
            throw new IllegalArgumentException("could not find user: " + userName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("user " + user.getUsername() + " was found"));
        }
        pa.setPrincipal((Object)user);
        this.profileAttributeService.putProfileAttribute(null, pa);
        if (log.isDebugEnabled()) {
            log.debug((Object)"attribute was set successfully");
        }
    }
}

