/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.async;

import com.jaspersoft.jasperserver.remote.exception.NoResultException;
import com.jaspersoft.jasperserver.remote.exception.NotReadyResultException;
import com.jaspersoft.jasperserver.remote.services.async.BaseImportExportTaskRunnable;
import com.jaspersoft.jasperserver.remote.services.async.StateDto;
import com.jaspersoft.jasperserver.remote.services.async.Task;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportExportTask<T>
implements Task {
    protected static final Log log = LogFactory.getLog(Task.class);
    protected String uuid;
    protected BaseImportExportTaskRunnable<T> taskRunner;
    protected Thread thread;

    public ImportExportTask(BaseImportExportTaskRunnable<T> taskRunner) {
        this.taskRunner = taskRunner;
        this.thread = new Thread(taskRunner);
    }

    @Override
    public String getUniqueId() {
        return this.uuid;
    }

    @Override
    public void setUniqueId(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public StateDto getState() {
        return this.taskRunner.getState();
    }

    @Override
    public T getResult() throws NotReadyResultException, NoResultException {
        return this.taskRunner.getResult();
    }

    @Override
    public void start() {
        this.taskRunner.prepare();
        this.thread.start();
    }

    @Override
    public void stop() {
        if (!this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        if (!this.taskRunner.getState().getPhase().equals("inprogress")) {
            new Remover(this.taskRunner.getFile()).start();
        }
    }

    protected class Remover
    extends Thread {
        private final File toRemove;
        private int counter = 0;

        public Remover(File toRemove) {
            this.toRemove = toRemove;
        }

        @Override
        public void run() {
            try {
                while (!this.toRemove.delete()) {
                    Thread.sleep(10000L);
                    if (this.counter++ <= 100) continue;
                    throw new Exception();
                }
            }
            catch (Exception e) {
                log.error((Object)("File " + this.toRemove.getAbsolutePath() + " was not deleted!"));
            }
        }
    }
}

