/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientSubDataSourceReference;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class VirtualDataSourceResourceConverter
extends ResourceConverterImpl<VirtualReportDataSource, ClientVirtualDataSource> {
    @Override
    protected VirtualReportDataSource resourceSpecificFieldsToServer(ClientVirtualDataSource clientObject, VirtualReportDataSource resultToUpdate) throws IllegalParameterValueException {
        List subDataSources = clientObject.getSubDataSources();
        HashMap<String, ResourceReference> dataSourceUriMap = null;
        if (subDataSources != null && !subDataSources.isEmpty()) {
            dataSourceUriMap = new HashMap<String, ResourceReference>(subDataSources.size());
            for (ClientSubDataSourceReference currentReference : subDataSources) {
                dataSourceUriMap.put(currentReference.getId(), new ResourceReference(currentReference.getUri()));
            }
        }
        resultToUpdate.setDataSourceUriMap(dataSourceUriMap);
        return resultToUpdate;
    }

    @Override
    protected ClientVirtualDataSource resourceSpecificFieldsToClient(ClientVirtualDataSource client, VirtualReportDataSource serverObject) {
        Map dataSourceUriMap = serverObject.getDataSourceUriMap();
        ArrayList<ClientSubDataSourceReference> subDataSources = null;
        if (dataSourceUriMap != null && !dataSourceUriMap.isEmpty()) {
            subDataSources = new ArrayList<ClientSubDataSourceReference>(dataSourceUriMap.size());
            for (String currentId : dataSourceUriMap.keySet()) {
                ClientSubDataSourceReference currentReference = new ClientSubDataSourceReference();
                currentReference.setId(currentId);
                currentReference.setUri(((ResourceReference)dataSourceUriMap.get(currentId)).getReferenceURI());
                subDataSources.add(currentReference);
            }
        }
        client.setSubDataSources(subDataSources);
        return client;
    }
}

