/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.dto.authority.ClientRole;
import com.jaspersoft.jasperserver.dto.authority.ClientUser;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.converters.RoleConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ToClientConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ToServerConverter;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserConverter
implements ToServerConverter<ClientUser, User>,
ToClientConverter<User, ClientUser> {
    @Resource
    private RoleConverter roleConverter;

    @Override
    public ClientUser toClient(User user) {
        ClientUser clientUser = new ClientUser();
        clientUser.setFullName(user.getFullName());
        clientUser.setEmailAddress(user.getEmailAddress());
        clientUser.setExternallyDefined(Boolean.valueOf(user.isExternallyDefined()));
        clientUser.setEnabled(Boolean.valueOf(user.isEnabled()));
        clientUser.setPreviousPasswordChangeTime(user.getPreviousPasswordChangeTime());
        clientUser.setTenantId(user.getTenantId());
        clientUser.setUsername(user.getUsername());
        if (user.getRoles() != null) {
            HashSet<ClientRole> roleSet = new HashSet<ClientRole>();
            for (Role role : user.getRoles()) {
                roleSet.add(this.roleConverter.toClient(role));
            }
            clientUser.setRoleSet(roleSet);
        }
        return clientUser;
    }

    @Override
    public User toServer(ClientUser clientObject, User user) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        if (clientObject.getTenantId() != null) {
            user.setTenantId(clientObject.getTenantId());
        }
        if (clientObject.getUsername() != null) {
            user.setUsername(clientObject.getUsername());
        }
        if (clientObject.getEmailAddress() != null) {
            user.setEmailAddress(clientObject.getEmailAddress());
        }
        if (clientObject.getFullName() != null) {
            user.setFullName(clientObject.getFullName());
        }
        if (clientObject.isEnabled() != null) {
            user.setEnabled(clientObject.isEnabled().booleanValue());
        }
        if (clientObject.isExternallyDefined() != null) {
            user.setExternallyDefined(clientObject.isExternallyDefined().booleanValue());
        }
        if (clientObject.getPassword() != null) {
            if (user.getPassword() != null && !clientObject.getPassword().equals(user.getPassword())) {
                user.setPreviousPasswordChangeTime(new Date());
            }
            user.setPassword(clientObject.getPassword());
        }
        if (clientObject.getRoleSet() != null) {
            HashSet<Role> newRoles = new HashSet<Role>();
            for (ClientRole role : clientObject.getRoleSet()) {
                newRoles.add(this.roleConverter.toServer(role));
            }
            user.setRoles(newRoles);
        }
        return user;
    }

    @Override
    public User toServer(ClientUser clientObject) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        return this.toServer(clientObject, (User)new UserImpl());
    }

    @Override
    public String getServerResourceType() {
        return User.class.getName();
    }

    @Override
    public String getClientResourceType() {
        return ClientUser.class.getName();
    }
}

