/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterProvider;
import com.jaspersoft.jasperserver.remote.resources.converters.ToClientConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ToServerConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="resourceConverterProvider")
public class ResourceConverterProviderImpl
implements ResourceConverterProvider {
    @Autowired
    private ApplicationContext context;
    private Map<String, ToClientConverter<? super Resource, ? extends ClientResourceLookup>> toClientConverters;
    private Map<String, ToServerConverter<? super ClientResourceLookup, ? extends Resource>> toServerConverters;
    private volatile boolean initialized = false;

    @Override
    public ToClientConverter<? super Resource, ? extends ClientResourceLookup> getToClientConverter(String serverType) throws IllegalParameterValueException {
        this.prepareConverters();
        ToClientConverter<? super Resource, ? extends ClientResourceLookup> toClientConverter = this.toClientConverters.get(serverType);
        if (toClientConverter == null) {
            throw new IllegalParameterValueException("type", serverType);
        }
        return toClientConverter;
    }

    @Override
    public ToClientConverter<? super Resource, ? extends ClientResourceLookup> getToClientConverter(Resource serverObject) {
        try {
            return this.getToClientConverter(serverObject instanceof ResourceLookup ? ResourceLookup.class.getName() : serverObject.getResourceType());
        }
        catch (IllegalParameterValueException e) {
            throw new IllegalStateException("Couldn't find converter for " + serverObject.getResourceType());
        }
    }

    @Override
    public ToServerConverter<? super ClientResourceLookup, ? extends Resource> getToServerConverter(ClientResourceLookup clientObject) throws IllegalParameterValueException {
        return this.getToServerConverter(GenericParametersReflectionHelper.extractClientType(clientObject.getClass()));
    }

    @Override
    public ToServerConverter<? super ClientResourceLookup, ? extends Resource> getToServerConverter(String clientType) throws IllegalParameterValueException {
        this.prepareConverters();
        ToServerConverter<? super ClientResourceLookup, ? extends Resource> toServerConverter = this.toServerConverters.get(clientType);
        if (toServerConverter == null) {
            throw new IllegalParameterValueException("type", clientType);
        }
        return toServerConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareConverters() {
        if (!this.initialized) {
            ResourceConverterProviderImpl resourceConverterProviderImpl = this;
            synchronized (resourceConverterProviderImpl) {
                if (!this.initialized) {
                    this.toClientConverters = new HashMap<String, ToClientConverter<? super Resource, ? extends ClientResourceLookup>>();
                    this.toServerConverters = new HashMap<String, ToServerConverter<? super ClientResourceLookup, ? extends Resource>>();
                    List<ResourceConverter<? super Resource, ? extends ClientResourceLookup>> converters = this.getConverters();
                    if (this.getConverters() != null) {
                        for (ResourceConverter<? super Resource, ? extends ClientResourceLookup> currentConverter : converters) {
                            this.toClientConverters.put(currentConverter.getServerResourceType(), currentConverter);
                            this.toServerConverters.put(currentConverter.getClientResourceType(), currentConverter);
                        }
                    }
                    this.initialized = true;
                }
            }
        }
    }

    protected List<ResourceConverter<? super Resource, ? extends ClientResourceLookup>> getConverters() {
        Map convertersMap = this.context.getBeansOfType(ResourceConverter.class);
        return new ArrayList<ResourceConverter<? super Resource, ? extends ClientResourceLookup>>(convertersMap.values());
    }
}

