/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.common.util.TimeZoneContextHolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverter;
import com.jaspersoft.jasperserver.remote.services.PermissionsService;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.text.DateFormat;
import java.text.ParseException;
import javax.annotation.Resource;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public abstract class ResourceConverterImpl<ResourceType extends com.jaspersoft.jasperserver.api.metadata.common.domain.Resource, ClientType extends ClientResourceLookup>
implements ResourceConverter<ResourceType, ClientType> {
    @Resource(name="mappingResourceFactory")
    protected ResourceFactory objectFactory;
    @Resource(name="messagesCalendarFormatProvider")
    protected CalendarFormatProvider calendarFormatProvider;
    @Resource(name="concretePermissionsService")
    private PermissionsService permissionsService;
    private Class<ClientType> clientTypeClass;
    private String serverResourceType;
    private String clientResourceType;

    protected ResourceType getNewResourceInstance() {
        return (ResourceType)this.objectFactory.newResource(null, this.getServerResourceType());
    }

    protected DateFormat getDateTimeFormat() {
        return this.calendarFormatProvider.getDatetimeFormat();
    }

    @Override
    public String getServerResourceType() {
        if (this.serverResourceType == null) {
            this.serverResourceType = GenericParametersReflectionHelper.getGenericTypeArgument(this.getClass(), ResourceConverter.class, 0).getName();
        }
        return this.serverResourceType;
    }

    @Override
    public ResourceType toServer(ClientType clientObject) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        ResourceType newResourceInstance = this.getNewResourceInstance();
        return this.toServer(clientObject, newResourceInstance);
    }

    @Override
    public ResourceType toServer(ClientType clientObject, ResourceType resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        resultToUpdate = this.genericFieldsToServer(clientObject, resultToUpdate);
        return this.resourceSpecificFieldsToServer(clientObject, resultToUpdate);
    }

    protected ResourceType genericFieldsToServer(ClientType clientObject, ResourceType resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        if (clientObject.getLabel() == null || "".equals(clientObject.getLabel())) {
            throw new MandatoryParameterNotFoundException(this.getClientResourceType() + ".label");
        }
        resultToUpdate.setURIString(clientObject.getUri());
        DateFormat dateTimeFormatter = this.getDateTimeFormat();
        dateTimeFormatter.setTimeZone(TimeZoneContextHolder.getTimeZone());
        if (clientObject.getCreationDate() != null) {
            try {
                resultToUpdate.setCreationDate(dateTimeFormatter.parse(clientObject.getCreationDate()));
            }
            catch (ParseException ex) {
                throw new IllegalParameterValueException("creationDate", clientObject.getCreationDate());
            }
        }
        if (clientObject.getUpdateDate() != null) {
            try {
                resultToUpdate.setUpdateDate(dateTimeFormatter.parse(clientObject.getUpdateDate()));
            }
            catch (ParseException ex) {
                throw new IllegalParameterValueException("updateDate", clientObject.getUpdateDate());
            }
        }
        resultToUpdate.setDescription(clientObject.getDescription());
        resultToUpdate.setLabel(clientObject.getLabel());
        resultToUpdate.setVersion(clientObject.getVersion() != null ? clientObject.getVersion() : -1);
        return resultToUpdate;
    }

    protected abstract ResourceType resourceSpecificFieldsToServer(ClientType var1, ResourceType var2) throws IllegalParameterValueException, MandatoryParameterNotFoundException;

    @Override
    public ClientType toClient(ResourceType serverObject) {
        ClientType client = this.genericFieldsToClient(this.getNewClientObjectInstance(), serverObject);
        return this.resourceSpecificFieldsToClient(client, serverObject);
    }

    protected ClientType genericFieldsToClient(ClientType client, ResourceType serverObject) {
        DateFormat dateTimeFormatter = this.getDateTimeFormat();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        dateTimeFormatter.setTimeZone(TimeZoneContextHolder.getTimeZone());
        if (serverObject.getCreationDate() != null) {
            client.setCreationDate(dateTimeFormatter.format(serverObject.getCreationDate()));
        }
        client.setDescription(serverObject.getDescription());
        client.setLabel(serverObject.getLabel());
        client.setResourceType(this.getClientResourceType());
        if (serverObject.getUpdateDate() != null) {
            client.setUpdateDate(dateTimeFormatter.format(serverObject.getUpdateDate()));
        }
        client.setUri(serverObject.getURIString());
        client.setVersion(Integer.valueOf(serverObject.getVersion()));
        client.setPermissionMask(Integer.valueOf(this.permissionsService.getEffectivePermission((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)serverObject, authentication).getPermissionMask()));
        return client;
    }

    protected abstract ClientType resourceSpecificFieldsToClient(ClientType var1, ResourceType var2);

    protected ClientType getNewClientObjectInstance() {
        try {
            return (ClientType)((ClientResourceLookup)this.getClientTypeClass().newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't instantiate client object", e);
        }
    }

    protected Class<ClientType> getClientTypeClass() {
        if (this.clientTypeClass == null) {
            this.clientTypeClass = GenericParametersReflectionHelper.getGenericTypeArgument(this.getClass(), ResourceConverter.class, 1);
        }
        return this.clientTypeClass;
    }

    @Override
    public String getClientResourceType() {
        if (this.clientResourceType == null) {
            this.clientResourceType = GenericParametersReflectionHelper.extractClientType(this.getClientTypeClass());
        }
        return this.clientResourceType;
    }
}

