/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReportUnit;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import com.jaspersoft.jasperserver.remote.resources.converters.DataSourceHolderResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.FileResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceReferenceConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ReportUnitResourceConverter
extends DataSourceHolderResourceConverter<ReportUnit, ClientReportUnit> {
    private static final String EXTRACT_RESOURCE_NAME_FROM_URI_PATTERN = ".+/([^/]+)$";
    @Resource
    private FileResourceConverter fileResourceConverter;
    @Resource(name="mappingResourceFactory")
    private ResourceFactory objectFactory;

    @Override
    protected ReportUnit resourceSpecificFieldsToServer(ClientReportUnit clientObject, ReportUnit resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        byte controlsLayout;
        resultToUpdate.setAlwaysPromptControls(clientObject.isAlwaysPromptControls());
        switch (clientObject.getControlsLayout()) {
            case popupScreen: {
                controlsLayout = 1;
                break;
            }
            case separatePage: {
                controlsLayout = 2;
                break;
            }
            case inPage: {
                controlsLayout = 4;
                break;
            }
            case topOfPage: {
                controlsLayout = 3;
                break;
            }
            default: {
                controlsLayout = 1;
            }
        }
        resultToUpdate.setControlsLayout(controlsLayout);
        resultToUpdate.setDataSnapshotId(clientObject.getDataSnapshotId());
        resultToUpdate.setInputControlRenderingView(clientObject.getInputControlRenderingView());
        resultToUpdate.setReportRenderingView(clientObject.getReportRenderingView());
        resultToUpdate.setQuery(this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableQuery.class).toServer(clientObject.getQuery(), resultToUpdate.getQuery()));
        resultToUpdate.setMainReport(this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableFile.class).addReferenceRestriction(new ResourceReferenceConverter.FileTypeRestriction(ClientFile.FileType.jrxml)).toServer(clientObject.getJrxml(), resultToUpdate.getMainReport()));
        ArrayList<ResourceReference> inputControls = null;
        List clientInputControls = clientObject.getInputControls();
        if (clientInputControls != null && !clientInputControls.isEmpty()) {
            inputControls = new ArrayList<ResourceReference>(clientInputControls.size());
            ResourceReferenceConverter<ClientReferenceableInputControl> inputControlReferenceConverter = this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableInputControl.class);
            for (ClientReferenceableInputControl inputControlReference : clientInputControls) {
                inputControls.add(inputControlReferenceConverter.toServer(inputControlReference));
            }
        }
        resultToUpdate.setInputControls(inputControls);
        List resources = resultToUpdate.getResources();
        resultToUpdate.setResources(this.convertResourcesToServer(clientObject.getFiles(), resources));
        return resultToUpdate;
    }

    protected List<ResourceReference> convertResourcesToServer(Map<String, ClientReferenceableFile> clientResources, List<ResourceReference> serverReferencesToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        ArrayList<ResourceReference> result = new ArrayList<ResourceReference>();
        if (clientResources != null && !clientResources.isEmpty()) {
            Map<String, ResourceReference> serverResourcesMap = this.getServerResourcesAsMap(serverReferencesToUpdate);
            for (String currentResourceName : clientResources.keySet()) {
                ClientReferenceableFile clientObject = clientResources.get(currentResourceName);
                ResourceReference serverObjectToUpdate = serverResourcesMap.get(currentResourceName);
                if (serverObjectToUpdate != null && serverObjectToUpdate.isLocal() && !(serverObjectToUpdate.getLocalResource() instanceof FileResource)) {
                    serverObjectToUpdate = null;
                }
                ResourceReferenceConverter<ClientReferenceableFile> fileResourceReferenceConverter = this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableFile.class);
                if (clientObject instanceof ClientReference && (serverObjectToUpdate == null || serverObjectToUpdate.isLocal())) {
                    if (serverObjectToUpdate == null) {
                        fileResourceReferenceConverter.toServer(clientObject);
                        FileResource fileResourceReference = (FileResource)this.objectFactory.newResource(null, FileResource.class);
                        fileResourceReference.setReferenceURI(clientObject.getUri());
                        serverObjectToUpdate = new ResourceReference((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)fileResourceReference);
                    } else if (!clientObject.getUri().equals(((FileResource)serverObjectToUpdate.getLocalResource()).getReferenceURI())) {
                        fileResourceReferenceConverter.toServer(clientObject);
                        ((FileResource)serverObjectToUpdate.getLocalResource()).setReferenceURI(clientObject.getUri());
                    }
                } else {
                    serverObjectToUpdate = fileResourceReferenceConverter.toServer(clientObject, serverObjectToUpdate);
                }
                result.add(serverObjectToUpdate);
            }
            if (serverReferencesToUpdate == null) {
                serverReferencesToUpdate = new ArrayList<ResourceReference>(result);
            } else {
                serverReferencesToUpdate.clear();
                serverReferencesToUpdate.addAll(result);
            }
        } else if (serverReferencesToUpdate != null) {
            serverReferencesToUpdate.clear();
        }
        return serverReferencesToUpdate;
    }

    protected Map<String, ResourceReference> getServerResourcesAsMap(List<ResourceReference> list) {
        HashMap<String, ResourceReference> result = new HashMap<String, ResourceReference>();
        if (list != null) {
            for (ResourceReference reference : list) {
                String name = reference.isLocal() ? reference.getLocalResource().getName() : this.getResourceNameForReference(reference);
                result.put(name, reference);
            }
        }
        return result;
    }

    protected String getResourceNameForReference(ResourceReference reference) {
        String referenceURI = reference.getReferenceURI();
        Matcher matcher = Pattern.compile(EXTRACT_RESOURCE_NAME_FROM_URI_PATTERN).matcher(referenceURI);
        if (!matcher.find()) {
            throw new IllegalStateException("Invalid reference URI '" + referenceURI + "'. Resource name can't be extracted");
        }
        String name = matcher.group(1);
        return name;
    }

    protected Map<String, ClientReferenceableFile> convertResourcesToClient(List<ResourceReference> serverResources) {
        HashMap<String, Object> result = null;
        if (serverResources != null && !serverResources.isEmpty()) {
            ResourceReferenceConverter<ClientReferenceableFile> fileResourceReferenceConverter = this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableFile.class);
            result = new HashMap<String, Object>(serverResources.size());
            for (ResourceReference reference : serverResources) {
                if (reference.isLocal()) {
                    if (reference.getLocalResource() instanceof FileResource) {
                        FileResource file = (FileResource)reference.getLocalResource();
                        if (file.isReference()) {
                            result.put(file.getName(), fileResourceReferenceConverter.toClient(new ResourceReference(file.getReferenceURI())));
                            continue;
                        }
                        result.put(file.getName(), this.fileResourceConverter.toClient(file));
                        continue;
                    }
                    throw new IllegalStateException("ReportUnit can't contain references of type " + reference.getLocalResource());
                }
                result.put(this.getResourceNameForReference(reference), fileResourceReferenceConverter.toClient(reference));
            }
        }
        return result;
    }

    @Override
    protected void setDataSourceToResource(ResourceReference dataSourceReference, ReportUnit resource) {
        resource.setDataSource(dataSourceReference);
    }

    @Override
    protected ResourceReference getDataSourceFromResource(ReportUnit resource) {
        return resource.getDataSource();
    }

    @Override
    protected ClientReportUnit resourceSpecificFieldsToClient(ClientReportUnit client, ReportUnit serverObject) {
        ClientReportUnit.ControlsLayoutType controlsLayout;
        client.setAlwaysPromptControls(serverObject.isAlwaysPromptControls());
        switch (serverObject.getControlsLayout()) {
            case 1: {
                controlsLayout = ClientReportUnit.ControlsLayoutType.popupScreen;
                break;
            }
            case 2: {
                controlsLayout = ClientReportUnit.ControlsLayoutType.separatePage;
                break;
            }
            case 4: {
                controlsLayout = ClientReportUnit.ControlsLayoutType.inPage;
                break;
            }
            case 3: {
                controlsLayout = ClientReportUnit.ControlsLayoutType.topOfPage;
                break;
            }
            default: {
                controlsLayout = ClientReportUnit.ControlsLayoutType.popupScreen;
            }
        }
        client.setControlsLayout(controlsLayout);
        client.setDataSnapshotId(serverObject.getDataSnapshotId());
        client.setInputControlRenderingView(serverObject.getInputControlRenderingView());
        client.setReportRenderingView(serverObject.getReportRenderingView());
        client.setQuery(this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableQuery.class).toClient(serverObject.getQuery()));
        client.setJrxml(this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableFile.class).toClient(serverObject.getMainReport()));
        ArrayList<ClientReferenceableInputControl> inputControls = null;
        List serverInputControls = serverObject.getInputControls();
        if (serverInputControls != null && !serverInputControls.isEmpty()) {
            inputControls = new ArrayList<ClientReferenceableInputControl>(serverInputControls.size());
            ResourceReferenceConverter<ClientReferenceableInputControl> inputControlResourceReferenceConverter = this.resourceReferenceConverterProvider.getConverterForType(ClientReferenceableInputControl.class);
            for (ResourceReference inputControlReference : serverInputControls) {
                inputControls.add(inputControlResourceReferenceConverter.toClient(inputControlReference));
            }
        }
        client.setInputControls(inputControls);
        List resources = serverObject.getResources();
        client.setFiles(this.convertResourcesToClient(resources));
        return client;
    }
}

