/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ObjectPermissionImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.dto.permissions.RepositoryPermission;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import com.jaspersoft.jasperserver.remote.helpers.PermissionsRecipientIdentityResolver;
import com.jaspersoft.jasperserver.remote.resources.converters.ToClientConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ToServerConverter;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PermissionConverter
implements ToClientConverter<ObjectPermission, RepositoryPermission>,
ToServerConverter<RepositoryPermission, ObjectPermission> {
    @Resource(name="concretePermissionsRecipientIdentityResolver")
    private PermissionsRecipientIdentityResolver resolver;

    @Override
    public RepositoryPermission toClient(ObjectPermission serverObject) {
        RepositoryPermission client = new RepositoryPermission(this.stripRepo(serverObject.getURI()), null, serverObject.getPermissionMask());
        if (serverObject.getPermissionRecipient() instanceof InternalURI) {
            client.setRecipient(((InternalURI)serverObject.getPermissionRecipient()).getURI());
        } else if (serverObject.getPermissionRecipient() instanceof MetadataUserDetails) {
            UserImpl internalUri = new UserImpl();
            User metaUser = (User)serverObject.getPermissionRecipient();
            internalUri.setUsername(metaUser.getUsername());
            internalUri.setTenantId(metaUser.getTenantId());
            client.setRecipient(((InternalURI)internalUri).getURI());
        }
        return client;
    }

    @Override
    public String getClientResourceType() {
        return RepositoryPermission.class.getName();
    }

    @Override
    public ObjectPermission toServer(RepositoryPermission clientObject) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        return this.toServer(clientObject, (ObjectPermission)new ObjectPermissionImpl());
    }

    @Override
    public ObjectPermission toServer(RepositoryPermission clientObject, ObjectPermission resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        if (clientObject.getMask() == null) {
            throw new MandatoryParameterNotFoundException("mask");
        }
        if (clientObject.getRecipient() == null) {
            throw new MandatoryParameterNotFoundException("recipient");
        }
        if (clientObject.getUri() == null) {
            throw new MandatoryParameterNotFoundException("uri");
        }
        resultToUpdate.setPermissionMask(clientObject.getMask().intValue());
        resultToUpdate.setPermissionRecipient((Object)this.resolver.toIdentity(clientObject.getRecipient()));
        resultToUpdate.setURI(this.addRepo(clientObject.getUri()));
        return resultToUpdate;
    }

    @Override
    public String getServerResourceType() {
        return ObjectPermission.class.getName();
    }

    private String stripRepo(String source) {
        if (source != null && source.startsWith("repo:")) {
            source = source.substring("repo:".length());
        }
        return source;
    }

    private String addRepo(String source) {
        if (!source.startsWith("repo:")) {
            source = "repo:".concat(source);
        }
        return source;
    }
}

