/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValues;
import com.jaspersoft.jasperserver.dto.resources.ClientListOfValuesItem;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ListOfValuesResourceConverter
extends ResourceConverterImpl<ListOfValues, ClientListOfValues> {
    @Override
    protected ListOfValues resourceSpecificFieldsToServer(ClientListOfValues clientObject, ListOfValues resultToUpdate) throws IllegalParameterValueException {
        List items = clientObject.getItems();
        if (items != null) {
            for (ClientListOfValuesItem currentItem : items) {
                ListOfValuesItemImpl serverItem = new ListOfValuesItemImpl();
                serverItem.setLabel(currentItem.getLabel());
                serverItem.setValue((Object)currentItem.getValue());
                resultToUpdate.addValue((ListOfValuesItem)serverItem);
            }
        }
        return resultToUpdate;
    }

    @Override
    protected ClientListOfValues resourceSpecificFieldsToClient(ClientListOfValues client, ListOfValues serverObject) {
        ListOfValuesItem[] values = serverObject.getValues();
        if (values != null && values.length > 0) {
            ArrayList<ClientListOfValuesItem> clientItems = new ArrayList<ClientListOfValuesItem>(values.length);
            client.setItems(clientItems);
            for (ListOfValuesItem currentItem : values) {
                clientItems.add(new ClientListOfValuesItem(currentItem.getLabel(), currentItem.getValue().toString()));
            }
        }
        return client;
    }
}

