/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.dto.resources.ClientDataType;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterImpl;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverterService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DataTypeResourceConverter
extends ResourceConverterImpl<DataType, ClientDataType> {
    @Resource
    private DataConverterService dataConverterService;

    @Override
    protected DataType resourceSpecificFieldsToServer(ClientDataType clientObject, DataType resultToUpdate) throws IllegalParameterValueException {
        int type = 1;
        if (clientObject.getType() != null) {
            switch (clientObject.getType()) {
                case text: {
                    type = 1;
                    break;
                }
                case date: {
                    type = 3;
                    break;
                }
                case datetime: {
                    type = 4;
                    break;
                }
                case number: {
                    type = 2;
                    break;
                }
                case time: {
                    type = 5;
                }
            }
        }
        resultToUpdate.setType((byte)type);
        try {
            resultToUpdate.setMaxValue((Comparable)this.dataConverterService.convertSingleValue(clientObject.getMaxValue(), resultToUpdate));
        }
        catch (InputControlValidationException e) {
            throw new IllegalParameterValueException("maxValue", clientObject.getMaxValue());
        }
        try {
            resultToUpdate.setMinValue((Comparable)this.dataConverterService.convertSingleValue(clientObject.getMinValue(), resultToUpdate));
        }
        catch (InputControlValidationException e) {
            throw new IllegalParameterValueException("minValue", clientObject.getMinValue());
        }
        resultToUpdate.setRegularExpr(clientObject.getPattern());
        resultToUpdate.setStrictMax(clientObject.isStrictMax().booleanValue());
        resultToUpdate.setStrictMin(clientObject.isStrictMin().booleanValue());
        resultToUpdate.setMaxLength(clientObject.getMaxLength());
        resultToUpdate.setDecimals(clientObject.getDecimals());
        return resultToUpdate;
    }

    @Override
    protected ClientDataType resourceSpecificFieldsToClient(ClientDataType client, DataType serverObject) {
        ClientDataType.TypeOfDataType type;
        switch (serverObject.getType()) {
            case 1: {
                type = ClientDataType.TypeOfDataType.text;
                break;
            }
            case 3: {
                type = ClientDataType.TypeOfDataType.date;
                break;
            }
            case 4: {
                type = ClientDataType.TypeOfDataType.datetime;
                break;
            }
            case 2: {
                type = ClientDataType.TypeOfDataType.number;
                break;
            }
            case 5: {
                type = ClientDataType.TypeOfDataType.time;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported dataType '" + serverObject.getType() + "'");
            }
        }
        client.setType(type);
        if (serverObject.getMaxValue() != null) {
            client.setMaxValue(this.dataConverterService.formatSingleValue((Object)serverObject.getMaxValue(), serverObject, String.class));
        }
        if (serverObject.getMinValue() != null) {
            client.setMinValue(this.dataConverterService.formatSingleValue((Object)serverObject.getMinValue(), serverObject, String.class));
        }
        client.setPattern("".equals(serverObject.getRegularExpr()) ? null : serverObject.getRegularExpr());
        client.setStrictMax(Boolean.valueOf(serverObject.isStrictMax()));
        client.setStrictMin(Boolean.valueOf(serverObject.isStrictMin()));
        client.setMaxLength(serverObject.getMaxLength());
        client.setDecimals(serverObject.getDecimals());
        return client;
    }
}

