/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.resources;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

public class GenericParametersReflectionHelper {
    public static String extractClientType(Class<?> clientObjectClass) {
        String clientResourceType = null;
        XmlRootElement xmlRootElement = clientObjectClass.getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null && !"##default".equals(xmlRootElement.name())) {
            clientResourceType = xmlRootElement.name();
        } else {
            XmlType xmlType = clientObjectClass.getAnnotation(XmlType.class);
            if (xmlType != null && !"##default".equals(xmlType.name())) {
                clientResourceType = xmlType.name();
            }
        }
        if (clientResourceType == null) {
            String classSimpleName = clientObjectClass.getSimpleName();
            clientResourceType = classSimpleName.replaceFirst("^.", classSimpleName.substring(0, 1).toLowerCase());
        }
        return clientResourceType;
    }

    public static Class<?> getGenericTypeArgument(Class<?> classToParse, Class<?> genericClassToFind, Integer argumentIndex) {
        Class result = null;
        ParameterizedType parameterizedType = null;
        Class currentClass = classToParse;
        HashMap<String, Class> currentParameterValues = new HashMap<String, Class>();
        Type[] previousTypeArguments = null;
        while (parameterizedType == null) {
            TypeVariable<Class<?>>[] typeParameters = currentClass.getTypeParameters();
            if (typeParameters != null && typeParameters.length > 0) {
                for (int i = 0; i < typeParameters.length; ++i) {
                    TypeVariable<Class<?>> currentVariable = typeParameters[i];
                    if (previousTypeArguments != null && previousTypeArguments.length > i) {
                        Type argumentType = previousTypeArguments[i];
                        if (argumentType instanceof Class) {
                            currentParameterValues.put(currentVariable.getName(), (Class)argumentType);
                            continue;
                        }
                        if (argumentType instanceof TypeVariable && currentParameterValues.containsKey(((TypeVariable)argumentType).getName())) {
                            currentParameterValues.put(currentVariable.getName(), (Class)currentParameterValues.remove(((TypeVariable)argumentType).getName()));
                            continue;
                        }
                    }
                    Class variableClass = null;
                    Type[] bounds = currentVariable.getBounds();
                    if (bounds != null && bounds.length > 0 && bounds[0] instanceof Class) {
                        variableClass = (Class)bounds[0];
                    }
                    currentParameterValues.put(currentVariable.getName(), variableClass);
                }
            }
            if ((parameterizedType = GenericParametersReflectionHelper.findParametrizedType(currentClass, genericClassToFind)) != null) continue;
            Type genericSuperclassType = currentClass.getGenericSuperclass();
            if (genericSuperclassType instanceof Class) {
                throw new IllegalArgumentException(classToParse.getName() + " is raw subclass of " + genericClassToFind.getName());
            }
            ParameterizedType genericSuperclass = (ParameterizedType)genericSuperclassType;
            previousTypeArguments = genericSuperclass.getActualTypeArguments();
            currentClass = (Class)genericSuperclass.getRawType();
        }
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments[argumentIndex] instanceof Class) {
            result = (Class)actualTypeArguments[argumentIndex];
        } else if (actualTypeArguments[argumentIndex] instanceof TypeVariable) {
            result = (Class)currentParameterValues.get(((TypeVariable)actualTypeArguments[argumentIndex]).getName());
        }
        if (result == null) {
            throw new IllegalArgumentException("Class " + classToParse.getName() + " has unsupported inheritance structure");
        }
        return result;
    }

    protected static ParameterizedType findParametrizedType(Class<?> classToParse, Class<?> genericClassToFind) {
        ParameterizedType type = null;
        if (genericClassToFind.isInterface()) {
            Type[] genericInterfaces = classToParse.getGenericInterfaces();
            if (genericInterfaces != null && genericInterfaces.length > 0) {
                for (Type genericInterface : genericInterfaces) {
                    if (genericInterface == genericClassToFind) {
                        throw new IllegalArgumentException(classToParse.getName() + " is raw implementation of " + genericClassToFind.getName());
                    }
                    if (!(genericInterface instanceof ParameterizedType) || ((ParameterizedType)genericInterface).getRawType() != genericClassToFind) continue;
                    type = (ParameterizedType)genericInterface;
                    break;
                }
            }
        } else {
            Type genericSuperclass = classToParse.getGenericSuperclass();
            if (genericSuperclass == genericClassToFind) {
                throw new IllegalArgumentException(classToParse.getName() + " is raw subclass of " + genericClassToFind.getName());
            }
            if (genericSuperclass instanceof ParameterizedType && ((ParameterizedType)genericSuperclass).getRawType() == genericClassToFind) {
                type = (ParameterizedType)genericSuperclass;
            }
        }
        return type;
    }
}

