/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.helpers;

import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.helpers.PermissionsRecipientIdentity;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PermissionsRecipientIdentityResolver {
    @Resource(name="protocolMapping")
    protected Map<String, Class<?>> map;

    public Class<?> getClassForProtocol(String protocol) throws IllegalParameterValueException {
        return this.map.get(protocol);
    }

    public String getProtocolForClass(Class<?> clazz) {
        for (String key : this.map.keySet()) {
            if (!this.map.get(key).equals(clazz)) continue;
            return key;
        }
        return null;
    }

    public PermissionsRecipientIdentity toIdentity(String uri) throws IllegalParameterValueException {
        String[] protocolLevel = uri.split(":/");
        if (protocolLevel.length != 2) {
            throw new IllegalParameterValueException("recipientUri", uri);
        }
        Class<?> clazz = this.map.get(protocolLevel[0]);
        if (clazz == null) {
            throw new IllegalParameterValueException("type", protocolLevel[0]);
        }
        return new PermissionsRecipientIdentity(clazz, protocolLevel[1]);
    }
}

