/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class JdbcDataSourceHandler
extends RepositoryResourceHandler {
    @Override
    public Class getResourceType() {
        return JdbcReportDataSource.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        JdbcReportDataSource dsResource = (JdbcReportDataSource)resource;
        descriptor.setDriverClass(dsResource.getDriverClass());
        descriptor.setPassword(dsResource.getPassword());
        descriptor.setUsername(dsResource.getUsername());
        descriptor.setConnectionUrl(dsResource.getConnectionUrl());
        descriptor.setWsType("jdbc");
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        JdbcReportDataSource jdbcReportDataSource = (JdbcReportDataSource)resource;
        jdbcReportDataSource.setConnectionUrl(descriptor.getConnectionUrl());
        jdbcReportDataSource.setDriverClass(descriptor.getDriverClass());
        jdbcReportDataSource.setUsername(descriptor.getUsername());
        jdbcReportDataSource.setPassword(descriptor.getPassword());
    }
}

