/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverterService;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DataTypeHandler
extends RepositoryResourceHandler {
    @Resource
    private DataConverterService dataConverterService;

    @Override
    public Class getResourceType() {
        return DataType.class;
    }

    @Override
    protected void doGet(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        DataType fileResource = (DataType)resource;
        descriptor.setWsType("dataType");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setDataType(fileResource.getType());
        descriptor.setPattern(fileResource.getRegularExpr());
        descriptor.setMaxValue(fileResource.getMaxValue() == null ? null : this.dataConverterService.formatSingleValue((Object)fileResource.getMaxValue(), fileResource, fileResource.getMaxValue().getClass()));
        descriptor.setMinValue(fileResource.getMinValue() == null ? null : this.dataConverterService.formatSingleValue((Object)fileResource.getMinValue(), fileResource, fileResource.getMinValue().getClass()));
        descriptor.setStrictMax(fileResource.isStrictMax());
        descriptor.setStrictMin(fileResource.isStrictMin());
    }

    @Override
    protected void updateResource(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        DataType dataType = (DataType)resource;
        dataType.setType(descriptor.getDataType());
        dataType.setRegularExpr(descriptor.getPattern());
        dataType.setStrictMax(descriptor.isStrictMax());
        String rawMaxValue = descriptor.getMaxValue();
        String rawMinValue = descriptor.getMinValue();
        try {
            dataType.setMaxValue(rawMaxValue != null ? (Comparable)this.dataConverterService.convertSingleValue(rawMaxValue, dataType) : null);
            dataType.setMinValue(rawMinValue != null ? (Comparable)this.dataConverterService.convertSingleValue(rawMinValue, dataType) : null);
        }
        catch (InputControlValidationException e) {
            throw new RuntimeException(e.getValidationError() != null && e.getValidationError().getDefaultMessage() != null ? e.getValidationError().getDefaultMessage() : e.getMessage(), e);
        }
        dataType.setStrictMin(descriptor.isStrictMin());
    }
}

