/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.PdfExportParametersBean;
import com.jaspersoft.jasperserver.remote.ReportExporter;
import com.jaspersoft.jasperserver.remote.services.ReportOutputPages;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="remotePdfExporter")
@Scope(value="prototype")
public class PdfExporter
implements ReportExporter {
    @Resource(name="pdfExportParameters")
    PdfExportParametersBean exportParams;

    @Override
    public Map<JRExporterParameter, Object> exportReport(JasperPrint jasperPrint, OutputStream output, EngineService engineService, HashMap exportParameters, ExecutionContext executionContext, String reportUnitURI) throws Exception {
        exportParameters.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exportParameters.put(JRExporterParameter.OUTPUT_STREAM, output);
        if (this.exportParams != null) {
            String printLocaleCode = jasperPrint.getLocaleCode();
            Locale printLocale = LocaleHelper.getInstance().getLocale(printLocaleCode);
            Map fontMap = this.exportParams.getFontMap(printLocale);
            if (fontMap != null) {
                exportParameters.put(JRExporterParameter.FONT_MAP, fontMap);
            }
        }
        if (exportParameters.get("PAGE") != null) {
            int pageIndex = Integer.parseInt((String)exportParameters.get("PAGE"));
            exportParameters.put(JRExporterParameter.PAGE_INDEX, --pageIndex);
        } else if (exportParameters.get("OUTPUT_PAGES") != null) {
            ReportOutputPages pages = (ReportOutputPages)exportParameters.get("OUTPUT_PAGES");
            if (pages.getPage() != null) {
                exportParameters.put(JRExporterParameter.PAGE_INDEX, pages.getPage() - 1);
            } else if (pages.getStartPage() != null && pages.getEndPage() != null) {
                exportParameters.put(JRExporterParameter.START_PAGE_INDEX, pages.getStartPage() - 1);
                exportParameters.put(JRExporterParameter.END_PAGE_INDEX, pages.getEndPage() - 1);
            }
        }
        engineService.exportToPdf(executionContext, reportUnitURI, (Map)exportParameters);
        return exportParameters;
    }

    @Override
    public String getContentType() {
        return "application/pdf";
    }

    public PdfExportParametersBean getExportParams() {
        return this.exportParams;
    }

    public void setExportParams(PdfExportParametersBean exportParams) {
        this.exportParams = exportParams;
    }
}

